/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.srp.ISRPConnection;
import com.ibm.ws.webcontainer.srt.NilSRPConnection;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.ws.webcontainer.srt.WebGroup;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import sun.io.ByteToCharConverter;

class SRTConnectionContext {
    private static String DEFAULT_CHARACTER_ENCODING;
    private static String SYSTEM_CLIENT_ENCODING;
    private ISRPConnection _conn;
    private SRTServletRequest _request;
    private SRTServletResponse _response;
    private WebGroup _webgroup;
    private String charEncoding;
    private static TraceComponent tc;
    private static String sessUrlRewritePrefix;
    private static final String qMark = "?";
    public static final String ACCEPT_CHARSET_HEADER = "Accept-Charset";
    public static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String DEFAULT_CLIENT_ENCODING = "iso-8859-1";
    public static final String HEADER_SEPARATOR = ",";
    public static final String EQUALS = "=";
    public static final String CONTENT_TYPE_SEPARATOR = ";";
    public static final String LANG_CHINESE_S = "zh-cn";
    public static final String LANG_CHINESE = "zh";
    public static final String LANG_CHINESE_T = "zh-tw";
    public static final String LANG_EN = "en";
    public static final String LANG_KOREA = "ko";
    public static final String LANG_JAPAN1 = "ja";
    public static final String LANG_JAPAN2 = "jp";
    public static final String ENC_CHINESE_S = "Cp1381";
    public static final String ENC_CHINESE_T = "Cp950";
    public static final String ENC_ENGLISH = "iso-8859-1";
    public static final String ENC_KOREA = "KSC5601";
    public static final String ENC_JAPAN = "SJIS";
    public static final String SYS_PROP_FILE_ENCODING = "file.encoding";
    private static final String SHORT_ASCII = "8859";
    private static final String SHORT_ENGLISH = "8859_1";
    private static final String ACCEPT_ALL_VAL = "*";
    private static final String CP1047_ENCODING = "Cp1047";
    private static final String ISO8859_1_ENCODING = "8859_1";
    private static final String CP939_ENCODING = "Cp939";
    private static final String SJIS_ENCODING = "SJIS";
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$srt$SRTConnectionContext;

    SRTConnectionContext(WebGroup webGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor");
        }
        this._webgroup = webGroup;
        this._request = new SRTServletRequest(this);
        this._response = new SRTServletResponse(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    void prepareForNextConnection(ISRPConnection iSRPConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareForNextConnection");
        }
        this._conn = iSRPConnection;
        this._request.initForNextRequest();
        this._response.initForNextResponse();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareForNextConnection");
        }
    }

    void finishConnection() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishConnection");
        }
        try {
            this._request.finish();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", (String)"88", (Object)this);
            this._webgroup.logError("Error while finishing the connection", throwable);
        }
        try {
            this._response.finish();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.finishConnection", (String)"101", (Object)this);
            this._webgroup.logError("Error while finishing the connection", throwable);
        }
        this._conn = NilSRPConnection.instance();
        this.charEncoding = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishConnection");
        }
    }

    SRTServletRequest getRequest() {
        return this._request;
    }

    SRTServletResponse getResponse() {
        return this._response;
    }

    ISRPConnection getSRPConnection() {
        return this._conn;
    }

    void setWebGroup(WebGroup webGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setWebGroup");
        }
        this._webgroup = webGroup;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setWebGroup");
        }
    }

    WebGroup getWebGroup() {
        return this._webgroup;
    }

    Object getAttribute(String string) {
        return this._conn.getAttribute(string);
    }

    String getRequestURI() {
        return this.getDecodeURL(this.getEncodedRequestURI());
    }

    String getEncodedRequestURI() {
        return this._conn.getRequestURI();
    }

    String decodeURL(String string) {
        return this.getDecodeURL(string);
    }

    String getDecodeURL(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decodeURL", (Object)string);
        }
        int n = string.indexOf(sessUrlRewritePrefix);
        int n2 = string.indexOf(qMark);
        String string2 = null;
        if (n2 != -1 && n2 > n) {
            string2 = string.substring(n2);
        }
        if (n != -1) {
            string = string.substring(0, n);
            if (string2 != null) {
                string = string + string2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decodeURL");
        }
        return string;
    }

    static String getLanguage(HttpServletRequest httpServletRequest) {
        String string = null;
        String string2 = httpServletRequest.getHeader(ACCEPT_LANGUAGE_HEADER);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, HEADER_SEPARATOR);
            String string3 = stringTokenizer.nextToken().trim().toLowerCase();
            if (string3.startsWith(LANG_EN)) {
                string = "iso-8859-1";
            } else if (string3.equals(LANG_JAPAN1) || string3.equals(LANG_JAPAN2)) {
                string = "SJIS";
            } else if (string3.equals(LANG_CHINESE_T)) {
                string = ENC_CHINESE_T;
            } else if (string3.equals(LANG_KOREA)) {
                string = ENC_KOREA;
            } else if (string3.equals(LANG_CHINESE_S) || string3.equals(LANG_CHINESE)) {
                string = ENC_CHINESE_S;
            }
        } else {
            string = System.getProperty(SYS_PROP_FILE_ENCODING);
            string = string.equals(CP1047_ENCODING) ? "8859_1" : (string.equals(CP939_ENCODING) ? "SJIS" : "iso-8859-1");
        }
        try {
            ByteToCharConverter.getConverter((String)string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.getLanguage", (String)"317");
            string = System.getProperty(SYS_PROP_FILE_ENCODING);
            if (string == null) {
                string = "iso-8859-1";
            }
            return string;
        }
        return string;
    }

    static String getClientEncoding(HttpServletRequest httpServletRequest, boolean bl) {
        StringTokenizer stringTokenizer;
        String string = null;
        if (SYSTEM_CLIENT_ENCODING != null) {
            string = SYSTEM_CLIENT_ENCODING;
            return string;
        }
        String string2 = httpServletRequest.getHeader(CONTENT_TYPE_HEADER);
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, CONTENT_TYPE_SEPARATOR);
            if (!stringTokenizer.hasMoreTokens()) {
                string2 = null;
            } else {
                String string3 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) {
                    string2 = null;
                } else {
                    string3 = stringTokenizer.nextToken();
                    stringTokenizer = new StringTokenizer(string3 = string3.trim(), EQUALS);
                    if (!stringTokenizer.hasMoreTokens()) {
                        string2 = null;
                    } else {
                        string = stringTokenizer.nextToken();
                        if (!stringTokenizer.hasMoreTokens()) {
                            string2 = null;
                        } else {
                            string = stringTokenizer.nextToken();
                            if ((string = string.trim()).equals(ACCEPT_ALL_VAL)) {
                                string = "iso-8859-1";
                            }
                        }
                    }
                }
            }
        }
        if (string2 == null && (string2 = httpServletRequest.getHeader(ACCEPT_CHARSET_HEADER)) != null && (string = (stringTokenizer = new StringTokenizer(string2, HEADER_SEPARATOR)).nextToken().trim()).equals(ACCEPT_ALL_VAL)) {
            string = "iso-8859-1";
        }
        if (string2 == null) {
            if (bl) {
                string = SRTConnectionContext.getLanguage(httpServletRequest);
                return string;
            }
            return null;
        }
        try {
            ByteToCharConverter.getConverter((String)string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.srt.SRTConnectionContext.getClientEncoding", (String)"429");
            string = SRTConnectionContext.getLanguage(httpServletRequest);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        tc = Tr.register((String)(class$com$ibm$ws$webcontainer$srt$SRTConnectionContext == null ? (class$com$ibm$ws$webcontainer$srt$SRTConnectionContext = SRTConnectionContext.class$("com.ibm.ws.webcontainer.srt.SRTConnectionContext")) : class$com$ibm$ws$webcontainer$srt$SRTConnectionContext).getName(), (String)"Servlet_Engine");
        String string = System.getProperty(SYS_PROP_FILE_ENCODING);
        string = string.equals(CP1047_ENCODING) ? "8859_1" : (string.equals(CP939_ENCODING) ? "SJIS" : "iso-8859_1");
        DEFAULT_CHARACTER_ENCODING = string;
        SYSTEM_CLIENT_ENCODING = System.getProperty("default.client.encoding");
        sessUrlRewritePrefix = ";jsessionid=";
        if (WebContainer.getWebContainerProperties().get("SessionRewriteIdentifier") != null) {
            sessUrlRewritePrefix = CONTENT_TYPE_SEPARATOR + WebContainer.getWebContainerProperties().get("SessionRewriteIdentifier") + EQUALS;
        }
    }
}

