/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class SRTRequestUtils {
    private static TraceComponent tc;
    private static Properties _localeProps;
    private static Properties _jvmProps;
    private static HashMap _localeMap;
    private static HashMap _converterMap;
    private static final Hashtable localesCache;
    private static Locale cachedLocale;
    private static String cachedEncoding;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$srt$SRTRequestUtils;

    public static String getCharsetFromContentType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        int n2 = string2.indexOf("charset=");
        if (n2 == -1) {
            return null;
        }
        return string2.substring(n2 + 8).trim();
    }

    public static Vector getLocales(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("Accept-Language");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Accept-Language: {0}", (Object)string);
        }
        if (string == null) {
            Vector<Locale> vector = new Vector<Locale>();
            vector.addElement(Locale.getDefault());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processed Locales: {0}", vector);
            }
            return vector;
        }
        Vector vector = null;
        vector = (Vector)localesCache.get(string);
        if (vector == null) {
            vector = SRTRequestUtils.processAcceptLanguage(string);
            vector = SRTRequestUtils.extractLocales(vector);
            localesCache.put(string, vector);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processed Locales: {0}", (Object)vector);
        }
        return vector;
    }

    public static Vector processAcceptLanguage(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (object == null || ((String)object).length() == 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Encountered zero length language token without quality index.. skipping token");
                Tr.debug((TraceComponent)tc, (String)("acceptLanguage param = [" + string + "]"));
                continue;
            }
            int n = ((String)object).indexOf(59);
            Double d = new Double(1.0);
            if (n > -1) {
                int n2 = ((String)object).indexOf("q=");
                String string2 = ((String)object).substring(n2 + 2);
                try {
                    d = new Double(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webcontainer.srt.SRTRequestUtils.processAcceptLanguage", (String)"215");
                }
                object = ((String)object).substring(0, n);
            }
            if (((String)object).length() > 0) {
                if (!(d > 0.0) || ((String)object).charAt(0) == '*') continue;
                Vector vector = new Vector();
                if (treeMap.containsKey(d)) {
                    vector = (Vector)treeMap.get(d);
                }
                vector.addElement(object);
                treeMap.put(d, vector);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Encountered zero length language token with quality index.. skipping token");
            Tr.debug((TraceComponent)tc, (String)("acceptLanguage param = [" + string + "]"));
        }
        if (treeMap.isEmpty()) {
            object = new Vector();
            ((Vector)object).addElement(Locale.getDefault().toString());
            treeMap.put("1", object);
        }
        return new Vector(treeMap.values());
    }

    public static Vector extractLocales(Vector vector) {
        Enumeration enumeration = vector.elements();
        Vector<Locale> vector2 = new Vector<Locale>();
        while (enumeration.hasMoreElements()) {
            Vector vector3 = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                String string2 = "";
                String string3 = "";
                int n = string.indexOf("-");
                if (n > -1) {
                    string2 = string.substring(n + 1).trim();
                    string = string.substring(0, n).trim();
                    int n2 = string2.indexOf("-");
                    if (n2 > -1) {
                        string3 = string2.substring(n2 + 1).trim();
                        string2 = string2.substring(0, n2).trim();
                    }
                }
                vector2.addElement(new Locale(string, string2, string3));
            }
        }
        return vector2;
    }

    public static String getEncodingFromLocale(Locale locale) {
        if (locale == cachedLocale) {
            return cachedEncoding;
        }
        String string = (String)_localeMap.get(locale.toString());
        if (string == null && (string = (String)_localeMap.get(locale.getLanguage() + "_" + locale.getCountry())) == null) {
            string = (String)_localeMap.get(locale.getLanguage());
        }
        cachedEncoding = string;
        cachedLocale = locale;
        return string;
    }

    public static String getJvmConverter(String string) {
        String string2 = (String)_converterMap.get(string.toLowerCase());
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        tc = Tr.register((String)(class$com$ibm$ws$webcontainer$srt$SRTRequestUtils == null ? (class$com$ibm$ws$webcontainer$srt$SRTRequestUtils = SRTRequestUtils.class$("com.ibm.ws.webcontainer.srt.SRTRequestUtils")) : class$com$ibm$ws$webcontainer$srt$SRTRequestUtils).getName(), (String)"Servlet_Engine");
        _localeProps = new Properties();
        _jvmProps = new Properties();
        _localeMap = new HashMap();
        _converterMap = new HashMap();
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("server.root");
            }
        });
        try {
            string = string2 + File.separator + "properties" + File.separator + "encoding.properties";
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException, IOException {
                    _localeProps.load(new FileInputStream(string));
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTRequestUtils", (String)"56");
            Tr.error((TraceComponent)tc, (String)"failed.to.load.encoding.properties", (Object)throwable);
        }
        try {
            string = string2 + File.separator + "properties" + File.separator + "converter.properties";
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException, IOException {
                    _jvmProps.load(new FileInputStream(string));
                    return null;
                }
            });
            Properties properties = new Properties();
            Enumeration<?> enumeration = _jvmProps.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)_jvmProps.get(string3);
                properties.put(string3.toLowerCase(), string4);
            }
            _localeMap.putAll(_localeProps);
            _converterMap.putAll(properties);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTRequestUtils", (String)"74");
            Tr.error((TraceComponent)tc, (String)"failed.to.load.converter.properties", (Object)throwable);
        }
        localesCache = new Hashtable();
        cachedLocale = null;
        cachedEncoding = null;
    }
}

