/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.etools.webapplication.Servlet;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcherInfo;
import com.ibm.ws.webcontainer.webapp.WebAppSecurityCollaborator;
import java.security.Principal;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SRTServletRequestContext
implements Cloneable {
    private WebAppDispatcherContext _dispatcherContext;
    private HttpServletRequest _request;
    private String _servletPath;
    private String _pathInfo;
    private String _requestURI;
    private WebAppSecurityCollaborator _securityCollaborator;

    SRTServletRequestContext() {
    }

    public WebAppDispatcherContext setDispatcherContext(WebAppDispatcherContext webAppDispatcherContext) {
        WebAppDispatcherContext webAppDispatcherContext2 = this._dispatcherContext;
        this._dispatcherContext = webAppDispatcherContext;
        this.setCurrentRequest(webAppDispatcherContext.getRequest());
        return webAppDispatcherContext2;
    }

    public Principal getUserPrincipal() {
        return this._securityCollaborator.getUserPrincipal();
    }

    public boolean isUserInRole(String string) {
        WebApp webApp = this._dispatcherContext.getWebApp();
        String string2 = webApp.getServletNameByServletPath(this.getServletPath());
        Servlet servlet = webApp.getConfiguration().getServletNamed(string2);
        return this._securityCollaborator.isUserInRole(servlet, string);
    }

    public void setSecurityCollaborator(WebAppSecurityCollaborator webAppSecurityCollaborator) {
        this._securityCollaborator = webAppSecurityCollaborator;
    }

    public WebAppRequestDispatcherInfo getDispatcherInfo() {
        return this._dispatcherContext.getDispatcherInfo();
    }

    public String getPathInfo() {
        return this._pathInfo;
    }

    public void setPathInfo(String string) {
        this._pathInfo = string;
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public void setRequestURI(String string) {
        this._requestURI = string;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public void setServletPath(String string) {
        this._servletPath = string;
    }

    public String getContextPath() {
        String string = this._dispatcherContext.getWebApp().getRootURI();
        if (string.equals("/")) {
            return "";
        }
        return string;
    }

    public String getPathTranslated() {
        String string = this.getPathInfo();
        if (string == null) {
            return null;
        }
        return this._dispatcherContext.getWebApp().getRealPath(string);
    }

    public void setCurrentRequest(HttpServletRequest httpServletRequest) {
        this._request = httpServletRequest;
        this._servletPath = httpServletRequest.getServletPath();
        this._pathInfo = httpServletRequest.getPathInfo();
        this._requestURI = httpServletRequest.getRequestURI();
    }

    public HttpServletRequest getCurrentRequest() {
        return this._request;
    }

    public String getProxiedRequestURI() {
        return this._requestURI;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        String string2;
        String string3;
        if (string.startsWith("/")) {
            return this._dispatcherContext.getWebApp().getRequestDispatcher(string, true);
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if ((string3 = (String)this._request.getAttribute("javax.servlet.include.servlet_path")) == null) {
            String string4 = this._request.getPathInfo();
            string2 = this._request.getServletPath();
            if (string4 != null) {
                string2 = string2 + string4;
            }
        } else {
            String string5 = (String)this._request.getAttribute("javax.servlet.include.path_info");
            string2 = string3;
            if (string5 != null) {
                string2 = string2 + string5;
            }
        }
        string2 = string2.substring(0, string2.lastIndexOf("/"));
        string = string2 + '/' + string;
        return this._dispatcherContext.getWebApp().getRequestDispatcher(string, true);
    }

    public String getRequestedSessionId() {
        return this._dispatcherContext.getRequestedSessionId();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        return this._dispatcherContext.getSession(bl);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._dispatcherContext.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._dispatcherContext.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdValid() {
        this.getSession(false);
        return this._dispatcherContext.isRequestedSessionIdValid();
    }

    public Object clone() throws CloneNotSupportedException {
        SRTServletRequestContext sRTServletRequestContext = new SRTServletRequestContext();
        sRTServletRequestContext._pathInfo = this._pathInfo;
        sRTServletRequestContext._requestURI = this._requestURI;
        sRTServletRequestContext._servletPath = this._servletPath;
        sRTServletRequestContext._dispatcherContext = this._dispatcherContext;
        sRTServletRequestContext._request = this._request;
        sRTServletRequestContext._securityCollaborator = this._securityCollaborator;
        return sRTServletRequestContext;
    }
}

