/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.srp.ISRPConnection;
import com.ibm.ws.webcontainer.srp.SRPConnection;
import com.ibm.ws.webcontainer.srt.BufferedServletOutputStream;
import com.ibm.ws.webcontainer.srt.BufferedWriter;
import com.ibm.ws.webcontainer.srt.CookieHandler;
import com.ibm.ws.webcontainer.srt.IExtendedResponse;
import com.ibm.ws.webcontainer.srt.IOutputStreamObserver;
import com.ibm.ws.webcontainer.srt.IResponseOutput;
import com.ibm.ws.webcontainer.srt.ResponseBuffer;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.srt.SRTRequestUtils;
import com.ibm.ws.webcontainer.srt.SRTServletResponseContext;
import com.ibm.ws.webcontainer.srt.http.HttpHeader;
import com.ibm.ws.webcontainer.srt.http.IProtocolHeader;
import com.ibm.ws.webcontainer.srt.http.MimeHeaders;
import com.ibm.wsspi.webcontainer.servlet.IServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class SRTServletResponse
implements HttpServletResponse,
IOutputStreamObserver,
IResponseOutput,
IExtendedResponse,
IServletResponse {
    private static String CONTENT_LANGUAGE_HEADER = "Content-Language";
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    private static String REASON_OK = "ok";
    private static final String _defaultEncoding = "ISO-8859-1";
    private static String HEADER_CONTENT_TYPE = "Content-Type";
    private static String HEADER_CONTENT_LENGTH = "Content-Length";
    private static String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static InheritableThreadLocal _responseContext = new InheritableThreadLocal();
    private Object _createOutSynch = new Object();
    private Object _createWriterSynch = new Object();
    private IProtocolHeader _header = new HttpHeader();
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$srt$SRTServletResponse == null ? (class$com$ibm$ws$webcontainer$srt$SRTServletResponse = SRTServletResponse.class$("com.ibm.ws.webcontainer.srt.SRTServletResponse")) : class$com$ibm$ws$webcontainer$srt$SRTServletResponse).getName(), (String)"Servlet_Engine");
    private Locale _locale;
    private Locale _defaultLocale;
    private String _encoding;
    private int _contentLength = -1;
    private SRTOutputStream _rawOut = new SRTOutputStream();
    private ResponseBuffer _responseBuffer = null;
    private BufferedServletOutputStream _bufferedOut = new BufferedServletOutputStream();
    private BufferedWriter _bufferedWriter = new BufferedWriter();
    private OutputStreamWriter _outWriter = null;
    private String _outWriterEncoding;
    private boolean writerClosed = false;
    private boolean writerException = false;
    private String _reason = REASON_OK;
    private int _status = 200;
    private PrintWriter _pwriter;
    private boolean _firstWrite;
    private static int DEFAULT_BUFFER_SIZE = 4096;
    private int _bufferSize = DEFAULT_BUFFER_SIZE;
    private boolean _gotWriter = false;
    private boolean _gotOutputStream = false;
    SRTConnectionContext _connContext;
    private boolean _autoEncoding = false;
    private boolean _ignoreStateErrors;
    private boolean _headersWritten = false;
    private boolean _isInclude = false;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$srt$SRTServletResponse;

    public static SRTServletResponseContext getResponseContext() {
        return (SRTServletResponseContext)_responseContext.get();
    }

    public static void setResponseContext(SRTServletResponseContext sRTServletResponseContext) {
        _responseContext.set(sRTServletResponseContext);
    }

    public SRTServletResponse(SRTConnectionContext sRTConnectionContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor");
        }
        this._bufferedWriter.setObserver(this);
        this._bufferedOut.setObserver(this);
        this._connContext = sRTConnectionContext;
        this._firstWrite = false;
        this._defaultLocale = Locale.getDefault();
        this._contentLength = -1;
        this._autoEncoding = sRTConnectionContext.getWebGroup().getWebApp().autoResponseEncoding;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    public void setIsInclude(boolean bl) {
        this._isInclude = bl;
    }

    public Vector[] getHeaderTable() {
        int n = ((HttpHeader)this._header).getSize();
        Vector[] vectorArray = new Vector[]{new Vector(n), new Vector(n)};
        for (int i = 0; i < n; ++i) {
            vectorArray[0].add(((HttpHeader)this._header).getHeaderName(i));
            vectorArray[1].add(((HttpHeader)this._header).getHeader(i));
        }
        return vectorArray;
    }

    public void addCookie(Cookie cookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addCookie", (Object)cookie);
        }
        if (SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addCookie");
            }
        } else {
            CookieHandler.addCookie(cookie, this._header);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCookie");
        }
    }

    public void alertClose() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alertClose");
        }
        this.writerClosed = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alertClose");
        }
    }

    public void alertFirstWrite() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alertFirstWrite");
        }
        this._firstWrite = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alertFirstWrite");
        }
    }

    public void alertFirstFlush() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alertFirstFlush");
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alertFirstFlush");
        }
    }

    public void alertException() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alertException");
        }
        this.writerException = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alertException");
        }
    }

    public boolean writerObtained() {
        return this._gotWriter;
    }

    public boolean outputStreamObtained() {
        return this._gotOutputStream;
    }

    private synchronized void commit() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit");
        }
        if (!this._headersWritten && !this.isCommitted()) {
            this.addLocaleHeader();
            if (this.containsHeader(HEADER_CONTENT_ENCODING) && this.containsHeader(HEADER_CONTENT_LENGTH)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Content-Length header disallowed w/presence of Content-Encoding header");
                }
                MimeHeaders mimeHeaders = (MimeHeaders)((Object)this._header);
                mimeHeaders.removeHeader(HEADER_CONTENT_LENGTH);
                this._header = (IProtocolHeader)((Object)mimeHeaders);
            }
            int n = this._header.getSize();
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this._header.getFieldName(i);
                stringArray2[i] = this._header.getFieldValue(i);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Commit header [" + stringArray[i] + ":" + stringArray2[i] + "]"));
            }
            this.getSRPConnection().prepareForWrite(this._status, this._reason, stringArray, stringArray2, n);
            this._headersWritten = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    private void addLocaleHeader() {
        this.setHeader(CONTENT_LANGUAGE_HEADER, this._locale.toString().replace('_', '-'));
    }

    public boolean containsHeader(String string) {
        return this._header.containsField(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeRedirectURL(String string) {
        return this.encodeURL(string);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeURL(String string) {
        return SRTServletResponse.getResponseContext().encodeURL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finish");
        }
        if (!this.isCommitted()) {
            this.commit();
        }
        try {
            try {
                this.flushBuffer();
                this._rawOut.close();
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Servlet.Exception:.Error.while.finishing.response", (Object)iOException);
                }
                Object var3_2 = null;
                this._rawOut.reset();
                this._bufferedOut.reset();
                this._bufferedWriter.reset();
                this._responseBuffer = null;
                this._pwriter = null;
                this._gotOutputStream = false;
                this._gotWriter = false;
            }
            Object var3_1 = null;
            this._rawOut.reset();
            this._bufferedOut.reset();
            this._bufferedWriter.reset();
            this._responseBuffer = null;
            this._pwriter = null;
            this._gotOutputStream = false;
            this._gotWriter = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._rawOut.reset();
            this._bufferedOut.reset();
            this._bufferedWriter.reset();
            this._responseBuffer = null;
            this._pwriter = null;
            this._gotOutputStream = false;
            this._gotWriter = false;
            throw throwable;
        }
        this.resetState();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finish");
        }
    }

    private void setDefaultResponseEncoding() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDefaultResponseEncoding");
        }
        if (this._autoEncoding) {
            this._locale = this._connContext.getRequest().getLocale();
            if (this._locale == null) {
                this._locale = this._defaultLocale;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_locale is null: default to " + this._locale.toString()));
                }
            }
            this._encoding = SRTRequestUtils.getEncodingFromLocale(this._locale);
            if (this._encoding == null) {
                this._encoding = _defaultEncoding;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_encoding is null: default to " + this._encoding));
                }
            }
        } else {
            this._locale = this._defaultLocale;
            this._encoding = _defaultEncoding;
        }
        this.setContentType("text/html; charset=" + this._encoding);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_locale: " + this._locale.toString()));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_encoding: " + this._encoding));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDefaultResponseEncoding");
        }
    }

    protected void resetState() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetState");
        }
        this._header.clear();
        this._headersWritten = false;
        this._reason = REASON_OK;
        this._status = 200;
        this._ignoreStateErrors = false;
        this._firstWrite = false;
        this._contentLength = -1;
        this._isInclude = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetState");
        }
    }

    public String getCharacterEncoding() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCharacterEncoding");
        }
        if (this._encoding == null) {
            this.setDefaultResponseEncoding();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCharacterEncoding", (Object)this._encoding);
        }
        return this._encoding;
    }

    public void setCharacterEncoding(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCharacterEncoding", (Object)string);
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setCharacterEncoding");
            }
            return;
        }
        if (string == null) {
            this.setDefaultResponseEncoding();
        } else {
            this._encoding = string;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set response character encoding: " + this.getCharacterEncoding()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCharacterEncoding");
        }
    }

    public Cookie[] getCookies() {
        return CookieHandler.getSetCookies(this._header);
    }

    public ServletOutputStream getOutputStream() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutputStream");
        }
        if (!this._ignoreStateErrors && this._gotWriter) {
            throw new IllegalStateException(nls.getString("Writer.already.obtained", "Writer already obtained"));
        }
        this._gotOutputStream = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutputStream");
        }
        this._bufferedOut.init((OutputStream)((Object)this._rawOut), this.getBufferSize());
        this._bufferedOut.setLimit(this._contentLength);
        this._bufferedOut.setConnection(this.getSRPConnection());
        this._responseBuffer = this._bufferedOut;
        return this._bufferedOut;
    }

    public PrintWriter getWriter() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWriter");
        }
        if (!this._ignoreStateErrors && this._gotOutputStream) {
            throw new IllegalStateException(nls.getString("OutputStream.already.obtained", "OutputStream already obtained"));
        }
        if (!this._gotWriter) {
            try {
                String string = this.getCharacterEncoding();
                if (this._outWriter == null || this.writerException || !string.equals(this._outWriterEncoding)) {
                    this._outWriter = new OutputStreamWriter((OutputStream)((Object)this._rawOut), SRTRequestUtils.getJvmConverter(string));
                    this._outWriterEncoding = string;
                    this.writerException = false;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Tr.warning((TraceComponent)tc, (String)"Failed to create a writer with encoding: {0}. The default encoding will be used.", (Object)this.getCharacterEncoding());
                this.setCharacterEncoding(_defaultEncoding);
                this._outWriterEncoding = SRTRequestUtils.getJvmConverter(this.getCharacterEncoding());
                this._outWriter = new OutputStreamWriter((OutputStream)((Object)this._rawOut), this._outWriterEncoding);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("created writer with encoding: " + this._outWriter.getEncoding()));
            }
            this._bufferedWriter.init(this._outWriter, this.getBufferSize());
            this._bufferedWriter.setLimit(this._contentLength);
            this._bufferedWriter.setConnection(this.getSRPConnection());
            this._pwriter = new PrintWriter((Writer)this._bufferedWriter, false);
            this._responseBuffer = this._bufferedWriter;
            this._gotWriter = true;
            this.writerClosed = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWriter");
        }
        return this._pwriter;
    }

    public void initForNextResponse() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initForNextResponse");
        }
        _responseContext.set(new SRTServletResponseContext());
        this._rawOut.init(this.getSRPConnection());
        this._bufferedOut.reset();
        this._bufferedWriter.reset();
        this.resetState();
        this.setDefaultResponseEncoding();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initForNextResponse");
        }
    }

    public void sendError(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendError", (Object)String.valueOf(n));
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        this.sendError(n, MessageFormat.format(nls.getString("Error.reported", "Error reported: {0}"), objectArray));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendError");
        }
    }

    public void sendError(int n, String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendError", (Object)(n + " " + string));
        }
        SRTServletResponse.getResponseContext().sendError(n, string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendError");
        }
    }

    public void setReason(String string) {
        if (this.getSRPConnection() instanceof SRPConnection) {
            ((SRPConnection)this.getSRPConnection()).setReason(string);
        }
    }

    public void sendRedirect(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRedirect", (Object)string);
        }
        if (SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"sendRedirect");
            }
        } else {
            SRTServletResponse.getResponseContext().sendRedirect(string);
            this.commit();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRedirect");
        }
    }

    public void setContentLength(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setContentLength", (Object)String.valueOf(n));
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setContentLength");
            }
        } else {
            this._contentLength = n;
            this._bufferedOut.setLimit(this._contentLength);
            this._bufferedWriter.setLimit(this._contentLength);
            this.setIntHeader(HEADER_CONTENT_LENGTH, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setContentLength");
        }
    }

    public void setContentType(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setContentType", (Object)string);
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setContentType");
            }
        } else {
            this.setHeader(HEADER_CONTENT_TYPE, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setContentType");
        }
    }

    public void setDateHeader(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDateHeader", (Object)string);
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setDateHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._header.setDateField(string, System.currentTimeMillis());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDateHeader");
        }
    }

    public void setDateHeader(String string, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDateHeader", (Object)string);
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setDateHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._header.setDateField(string, l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDateHeader");
        }
    }

    public void setHeader(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setHeader", (Object)string);
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setHeader");
            }
        } else {
            if (string == null) {
                return;
            }
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            if (string2 == null) {
                ((MimeHeaders)((Object)this._header)).removeHeader(string);
            } else {
                if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                    String string3 = string2.toLowerCase();
                    int n = string3.indexOf("charset=");
                    if (n != -1) {
                        this.setCharacterEncoding(string2.substring(n + 8));
                        string2 = string2.substring(0, n) + "charset=" + this.getCharacterEncoding();
                    } else if (this._autoEncoding) {
                        string2 = string2.endsWith(";") ? string2 + "charset=" + this.getCharacterEncoding() : string2 + ";charset=" + this.getCharacterEncoding();
                    }
                }
                this._header.setField(string, string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setHeader");
        }
    }

    public void setIntHeader(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setIntHeader", (Object)string);
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setIntHeader");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
                return;
            }
            this._header.setIntField(string, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setIntHeader");
        }
    }

    public void setStatus(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setStatus", (Object)String.valueOf(n));
        }
        if (SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setStatus");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                throw new IllegalStateException("ERROR: Cannot set header. Response already committed.");
            }
            this._status = n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setStatus");
        }
    }

    public void setStatus(int n, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setStatus", (Object)String.valueOf(n));
        }
        if (SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setStatus");
            }
        } else {
            if (!this._ignoreStateErrors && this.isCommitted()) {
                throw new IllegalStateException("ERROR: Cannot set header. Response already committed.");
            }
            this._status = n;
            this._reason = string;
            if (this.getSRPConnection() instanceof SRPConnection) {
                ((SRPConnection)this.getSRPConnection()).setReason(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setStatus");
        }
    }

    private ISRPConnection getSRPConnection() {
        return this._connContext.getSRPConnection();
    }

    void setIgnoreStateErrors(boolean bl) {
        this._ignoreStateErrors = bl;
    }

    public void setBufferSize(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setBufferSize - {0}", (Object)String.valueOf(n));
        }
        this._bufferSize = n;
        if (this._responseBuffer != null) {
            if (!this._firstWrite) {
                this._responseBuffer.setBufferSize(n);
            } else {
                Tr.error((TraceComponent)tc, (String)"setbuffer.size.called.after.write");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"setBufferSize");
                }
                throw new IllegalStateException("setBufferSize() called after first write to Output Stream/Writer");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setBufferSize");
        }
    }

    public int getBufferSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBufferSize");
        }
        if (this._responseBuffer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getBufferSize");
            }
            return this._bufferSize;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBufferSize");
        }
        return this._responseBuffer.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.flushBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer(boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushBuffer");
        }
        if (!bl) {
            this.setFlushMode(false);
        }
        try {
            if (this._pwriter != null && !this.writerClosed) {
                this._pwriter.flush();
            }
            if (this._gotOutputStream) {
                this._responseBuffer.flushBuffer();
            }
        }
        finally {
            if (!bl) {
                this.setFlushMode(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushBuffer");
        }
    }

    public boolean isCommitted() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCommitted");
        }
        if (this._responseBuffer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isCommitted - false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCommitted - {0}", (Object)String.valueOf(this._responseBuffer.isCommitted()));
        }
        return this._responseBuffer.isCommitted();
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset");
        }
        if (this._responseBuffer != null) {
            this._responseBuffer.clearBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        this.resetState();
        this.setDefaultResponseEncoding();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public void setLocale(Locale locale) {
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"setLocale");
            }
            return;
        }
        this._locale = locale;
        String string = SRTRequestUtils.getEncodingFromLocale(this._locale);
        if (string == null) {
            string = _defaultEncoding;
        }
        this.setCharacterEncoding(string);
        if (this.containsHeader(HEADER_CONTENT_TYPE)) {
            String string2 = this._header.getField(HEADER_CONTENT_TYPE);
            int n = string2.indexOf("charset=");
            string2 = n != -1 ? string2.substring(0, n) + "charset=" + this.getCharacterEncoding() : string2 + "; charset=" + this.getCharacterEncoding();
            this._header.setField(HEADER_CONTENT_TYPE, string2);
        }
    }

    public Locale getLocale() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocale");
        }
        if (this._locale == null) {
            this.setDefaultResponseEncoding();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocale", (Object)this._locale.toString());
        }
        return this._locale;
    }

    public void addDateHeader(String string, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addDateHeader", (Object)string);
        }
        if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
            return;
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addDateHeader");
            }
            return;
        }
        if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
            throw new IllegalArgumentException("Cannot Set Content-Type to a Date value");
        }
        this._header.appendDateField(string, l);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addDateHeader");
        }
    }

    public void addHeader(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addHeader", (Object)string);
        }
        if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
            return;
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addHeader");
            }
            return;
        }
        if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
            this.setHeader(HEADER_CONTENT_TYPE, string2);
        } else {
            this._header.appendField(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addHeader");
        }
    }

    public void addIntHeader(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addIntHeader", (Object)string);
        }
        if (!this._ignoreStateErrors && this.isCommitted()) {
            Tr.warning((TraceComponent)tc, (String)"WARNING: Cannot set header. Response already committed.");
            return;
        }
        if (SRTServletResponse.getResponseContext() != null && SRTServletResponse.getResponseContext().isInclude()) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), (Object)"addIntHeader");
            }
            return;
        }
        if (string.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
            throw new IllegalArgumentException("Cannot Set Content-Type to an Int value");
        }
        this._header.appendIntField(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addIntHeader");
        }
    }

    public void resetBuffer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetBuffer");
        }
        if (this._responseBuffer != null) {
            this._responseBuffer.clearBuffer();
        }
        if (this._bufferedWriter != null) {
            this._bufferedWriter.clearBuffer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetBuffer");
        }
    }

    public void closeResponseOutput() {
        if (!this.writerClosed) {
            try {
                if (this._gotOutputStream) {
                    this._bufferedOut.close();
                    this._rawOut.close();
                } else if (this._gotWriter) {
                    this._pwriter.close();
                    this._rawOut.close();
                }
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"IO.Error", (Object)throwable);
            }
        }
    }

    public void addSessionCookie(Cookie cookie) {
        this.addCookie(cookie);
    }

    private void setFlushMode(boolean bl) {
        if (this.getSRPConnection() instanceof SRPConnection) {
            ((SRPConnection)this.getSRPConnection()).setFlushMode(bl);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

