/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.ServletReference;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class SRTServletResponseContext
implements Cloneable {
    private HttpServletResponse _response;
    private WebAppDispatcherContext _dispatcherContext;
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");

    SRTServletResponseContext() {
    }

    public WebAppDispatcherContext setDispatcherContext(WebAppDispatcherContext webAppDispatcherContext) {
        WebAppDispatcherContext webAppDispatcherContext2 = this._dispatcherContext;
        this._dispatcherContext = webAppDispatcherContext;
        this._response = webAppDispatcherContext.getResponse();
        return webAppDispatcherContext2;
    }

    public boolean isInclude() {
        if (this._dispatcherContext != null) {
            return this._dispatcherContext.getIsInclude();
        }
        return false;
    }

    WebApp getWebApp() {
        return this._dispatcherContext.getWebApp();
    }

    ServletReference getCurrentServletReference() {
        return this._dispatcherContext.getCurrentServletReference();
    }

    WebAppDispatcherContext getDispatcherContext() {
        return this._dispatcherContext;
    }

    public void sendRedirect(String string) throws IOException {
        if (!this._response.isCommitted()) {
            if (string == null) {
                throw new IllegalArgumentException("Location cannot be null in javax.servlet.http.HttpServletResponse.sendRedirect(location)");
            }
        } else {
            throw new IllegalStateException();
        }
        string = this.convertRelativeURIToURL(string);
        this._response.setHeader("Location", string);
        this._response.setStatus(302);
        this._response.flushBuffer();
    }

    public String encodeRedirectURL(String string) {
        return this.encodeRedirectUrl(string);
    }

    public void sendError(int n) throws IOException {
        ServletReference servletReference = this.getCurrentServletReference();
        if (servletReference != null) {
            this.sendError(n, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), servletReference.getServletName()));
        } else {
            this.sendError(n, MessageFormat.format(nls.getString("[{0}].reported.an.error", "[{0}] reported an error"), this.getWebApp().getWebAppName()));
        }
    }

    public void sendError(int n, String string) throws IOException {
        if (this._response.isCommitted()) {
            throw new IllegalStateException("Response already committed.");
        }
        this._response.resetBuffer();
        int n2 = n;
        try {
            if (!this._response.isCommitted()) {
                this._response.setStatus(n2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.sendError", (String)"112", (Object)this);
        }
        WebApp webApp = this.getWebApp();
        WebAppErrorReport webAppErrorReport = null;
        webAppErrorReport = new WebAppErrorReport(string);
        webAppErrorReport.setErrorCode(n2);
        ServletReference servletReference = this.getCurrentServletReference();
        if (servletReference != null) {
            webAppErrorReport.setTargetServletName(servletReference.getServletName());
        }
        webApp.sendError(this.getDispatcherContext().getRequest(), this._response, (Throwable)((Object)webAppErrorReport));
        this._response.flushBuffer();
    }

    void setCurrentResponse(HttpServletResponse httpServletResponse) {
        this._response = httpServletResponse;
    }

    public HttpServletResponse getCurrentResponse() {
        return this._response;
    }

    private String convertRelativeURIToURL(String string) {
        block18: {
            int n;
            if (string == null) {
                throw new IllegalStateException();
            }
            String string2 = string;
            int n2 = (string = string.trim()).indexOf("://");
            if (n2 != -1 && ((n = string.indexOf(63)) == -1 || n2 < n)) {
                return string;
            }
            String string3 = null;
            boolean bl = false;
            try {
                string3 = this.getWebApp().getRootURI().trim();
                if (!string3.startsWith("/")) {
                    string3 = "/" + string3;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", (String)"184", (Object)this);
                string3 = "/";
            }
            try {
                bl = string.startsWith("/");
                if (string.startsWith("./")) {
                    string = string.substring(2);
                }
                HttpServletRequest httpServletRequest = this.getDispatcherContext().getRequest();
                String string4 = httpServletRequest.getScheme();
                int n3 = httpServletRequest.getServerPort();
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append("://");
                stringBuffer.append(httpServletRequest.getServerName());
                if (string4.equals("http") && n3 != 80 || string4.equals("https") && n3 != 443) {
                    stringBuffer.append(":");
                    stringBuffer.append(n3);
                }
                String string5 = null;
                if (bl) {
                    if (WebContainerSystemProps.getSendRedirectCompatibilty()) {
                        stringBuffer.append(string3);
                        stringBuffer.append(string);
                    } else {
                        stringBuffer.append(string);
                    }
                    string5 = stringBuffer.toString();
                } else {
                    String string6 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
                    String string7 = httpServletRequest.getPathInfo();
                    if (string7 != null && string7.length() > 0) {
                        if (!string7.startsWith("/")) {
                            string7 = "/" + string7;
                        }
                        string6 = string6.substring(0, string6.lastIndexOf(string7));
                        string5 = string6 + "/" + string;
                    } else {
                        string5 = string6.substring(0, string6.lastIndexOf(47) + 1) + string;
                    }
                }
                if (string5.indexOf("..") > -1) {
                    int n4 = new String(string4 + "://").length();
                    int n5 = string5.indexOf("/", n4);
                    String string8 = string5.substring(0, n5);
                    String string9 = string5.substring(n5);
                    string9 = this.getWebApp().normalize(string9);
                    if (string9 != null) {
                        return string8 + string9;
                    }
                    break block18;
                }
                return string5;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.webapp.WebAppDispatcherResponse.convertRelativeURIToURL", (String)"256", (Object)this);
            }
        }
        return string;
    }

    public void callPage(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        ServletContext servletContext = this.getWebApp().getContext(string);
        WebApp webApp = (WebApp)servletContext;
        String string2 = string.substring(webApp.getRootURI().length());
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(string2);
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)this._response);
    }

    public void _include(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(string);
        requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)this._response);
    }

    public void _forward(String string, HttpServletRequest httpServletRequest) throws IOException, ServletException {
        WebApp webApp = this.getWebApp();
        RequestDispatcher requestDispatcher = webApp.getRequestDispatcher(string);
        requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)this._response);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeURL(String string) {
        return this._dispatcherContext.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeURL(string);
    }

    public Object clone() throws CloneNotSupportedException {
        SRTServletResponseContext sRTServletResponseContext = new SRTServletResponseContext();
        sRTServletResponseContext._dispatcherContext = this._dispatcherContext;
        sRTServletResponseContext._response = this._response;
        return sRTServletResponseContext;
    }
}

