/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ws.webcontainer.webapp.WebAppContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TldListenerParser
extends DefaultHandler {
    public static final String TAGLIB_DTD_PUBLIC_ID_11 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
    public static final String TAGLIB_DTD_RESOURCE_PATH_11 = "/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd";
    public static final String TAGLIB_DTD_PUBLIC_ID_12 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    public static final String TAGLIB_DTD_RESOURCE_PATH_12 = "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd";
    public static final String TAGLIB_DTD_PUBLIC_ID_20 = "http://java.sun.com/xml/ns/j2ee web-jsptaglibrary_2_0.xsd";
    public static final String TAGLIB_DTD_RESOURCE_PATH_20 = "/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd";
    private static final int TAGLIB_ELEMENT = 1;
    private static final int TAG_ELEMENT = 2;
    private static final int TAGFILE_ELEMENT = 3;
    private static final int FUNCTION_ELEMENT = 4;
    private static final int ATTRIBUTE_ELEMENT = 5;
    protected WebAppContext ctxt = null;
    protected SAXParser saxParser = null;
    protected StringBuffer chars = null;
    protected List eventListenerList = new ArrayList();

    public TldListenerParser(WebAppContext webAppContext) throws Exception {
        this.ctxt = webAppContext;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            this.saxParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Exception(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new Exception(sAXException);
        }
    }

    private void reset() {
        this.eventListenerList.clear();
    }

    public List parseTLDFromLocation(String string) throws Exception {
        InputStream inputStream = this.ctxt.getResourceAsStream(string);
        if (inputStream != null) {
            File file = new File(this.ctxt.getRealPath(string));
            this.parseTld(inputStream);
        }
        return this.eventListenerList;
    }

    public List parseTLDFromStream(InputStream inputStream) throws Exception {
        this.parseTld(inputStream);
        return this.eventListenerList;
    }

    private void parseTld(InputStream inputStream) throws Exception {
        this.reset();
        try {
            this.saxParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            if (sAXException.getCause() != null) {
                throw new Exception(sAXException.getCause());
            }
            throw new Exception(sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public List getEventListenerList() {
        return this.eventListenerList;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals("listener-class")) {
            this.chars = new StringBuffer();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        for (int i = 0; i < n2; ++i) {
            if (this.chars == null) continue;
            this.chars.append(cArray[n + i]);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("listener-class")) {
            this.eventListenerList.add(this.chars.toString().trim());
        }
        this.chars = null;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputSource inputSource = null;
        String string3 = null;
        if (string.equals(TAGLIB_DTD_PUBLIC_ID_11)) {
            string3 = TAGLIB_DTD_RESOURCE_PATH_11;
        } else if (string.equals(TAGLIB_DTD_PUBLIC_ID_12)) {
            string3 = TAGLIB_DTD_RESOURCE_PATH_12;
        } else if (string.equals(TAGLIB_DTD_PUBLIC_ID_20)) {
            string3 = TAGLIB_DTD_RESOURCE_PATH_20;
        }
        if (string3 != null) {
            InputStream inputStream = this.getClass().getResourceAsStream(string3);
            if (inputStream == null) {
                throw new SAXException("jsp.error.internal.dtd.not.found");
            }
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }
}

