/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class HttpInputStream
extends ServletInputStream {
    protected InputStream in;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int total;
    protected int limit;
    protected int length;
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$srt$http$HttpInputStream == null ? (class$com$ibm$ws$webcontainer$srt$http$HttpInputStream = HttpInputStream.class$("com.ibm.ws.webcontainer.srt.http.HttpInputStream")) : class$com$ibm$ws$webcontainer$srt$http$HttpInputStream).getName(), (String)"Servlet_Engine");
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$srt$http$HttpInputStream;

    public HttpInputStream(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor", (Object)String.valueOf(n));
        }
        this.buf = new byte[n];
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    public HttpInputStream() {
        this(512);
    }

    public void init(InputStream inputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.in = inputStream;
        this.next();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void next() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"next");
        }
        this.length = -1;
        this.limit = Integer.MAX_VALUE;
        this.total = 0;
        this.count = 0;
        this.pos = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"next");
        }
    }

    public void finish() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finish");
        }
        if (this.length != -1) {
            int n;
            for (int i = this.limit - this.total; i > 0; i -= n) {
                n = (int)this.skip(i);
                if (n != 0) continue;
                Tr.error((TraceComponent)tc, (String)"Invalid Content Length");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"finish");
                }
                throw new IOException(nls.getString("Invalid.Content.Length", "Invalid content length"));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finish");
        }
    }

    public void resets() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resets");
        }
        this.in = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resets");
        }
    }

    public int getTotal() {
        return this.total;
    }

    public void setContentLength(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setContentLength", (Object)String.valueOf(n));
        }
        if (n < 0) {
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Invalid Content Length");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setContentLength");
            }
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.Content.Length", "Illegal Argument: Invalid Content Length"));
        }
        this.length = n;
        if (Integer.MAX_VALUE - this.total > n) {
            this.limit = this.total + n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setContentLength");
        }
    }

    public int getContentLength() {
        return this.length;
    }

    public int read() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read");
        }
        if (this.total >= this.limit) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"read -1");
            }
            return -1;
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"read -1");
                }
                return -1;
            }
        }
        ++this.total;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read");
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.pos;
        if (n3 > 0) {
            if (n3 > n2) {
                System.arraycopy(this.buf, this.pos, byArray, n, n2);
                this.pos += n2;
                return n2;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            this.pos = 0;
            this.count = 0;
            n += n3;
            n2 -= n3;
        }
        int n4 = n3;
        int n5 = this.in.read(byArray, n, n2);
        if (n5 > 0) {
            n4 += n5;
        }
        return n4 == 0 ? -1 : n4;
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readLine");
        }
        if (this.total >= this.limit) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readLine -1");
            }
            return -1;
        }
        int n3 = 0;
        n3 = n2;
        int n4 = this.count - this.pos;
        if (n4 <= 0) {
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"readLine -1");
                }
                return -1;
            }
        }
        int n5 = n4 < n2 ? n4 : n2;
        int n6 = HttpInputStream.copyLine(this.buf, this.pos, byArray, n, n5);
        this.pos += n6;
        this.total += n6;
        n3 -= n6;
        int n7 = n6;
        if (n7 == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readLine -1");
            }
            return -1;
        }
        while (n3 > 0 && byArray[n + n7 - 1] != 10) {
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"readLine", (Object)String.valueOf(n7));
                }
                return n7;
            }
            n5 = n4 < n3 ? n4 : n3;
            n6 = HttpInputStream.copyLine(this.buf, this.pos, byArray, n + n7, n5);
            this.pos += n6;
            this.total += n6;
            n3 -= n6;
            n7 += n6;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readLine", (Object)String.valueOf(n7));
        }
        return n7;
    }

    private static int copyLine(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"copyLine");
        }
        int n4 = n;
        while (n3-- > 0 && byArray[n4++] != 10) {
        }
        System.arraycopy(byArray, n, byArray2, n2, n4 - n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyLine");
        }
        return n4 - n;
    }

    public long skip(long l) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"skip");
        }
        if (this.total >= this.limit) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"skip", (Object)"0");
            }
            return 0L;
        }
        long l2 = l;
        while (l2 > 0L) {
            int n = this.count - this.pos;
            if (n <= 0) {
                this.fill();
                n = this.count - this.pos;
                if (n <= 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"skip", (Object)String.valueOf(l - l2));
                    }
                    return l - l2;
                }
            }
            if (l2 < (long)n) {
                n = (int)l2;
            }
            l2 -= (long)n;
            this.pos += n;
            this.total += n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"skip", (Object)String.valueOf(l));
        }
        return l;
    }

    public int available() throws IOException {
        return Math.min(this.count - this.pos + this.in.available(), this.limit - this.total);
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        this.finish();
        this.in.close();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    protected void fill() throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"fill");
        }
        if ((n = Math.min(this.buf.length, this.limit - this.total)) > 0 && (n = this.in.read(this.buf, 0, n)) > 0) {
            this.pos = 0;
            this.count = n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"fill");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

