/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Observer;
import javax.servlet.ServletOutputStream;

public class HttpOutputStream
extends ServletOutputStream {
    protected OutputStream out;
    protected byte[] buf;
    protected int count;
    protected int total;
    protected int limit;
    protected int length = -1;
    protected Observer obs;
    protected IOException except;
    protected boolean committed;
    protected int countedLength = 0;
    private int bufferSize;
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$srt$http$HttpOutputStream == null ? (class$com$ibm$ws$webcontainer$srt$http$HttpOutputStream = HttpOutputStream.class$("com.ibm.ws.webcontainer.srt.http.HttpOutputStream")) : class$com$ibm$ws$webcontainer$srt$http$HttpOutputStream).getName(), (String)"Servlet_Engine");
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    private boolean closeOnClose = false;
    private boolean doContentLengthCheck = false;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$srt$http$HttpOutputStream;

    public HttpOutputStream(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor", (Object)String.valueOf(n));
        }
        this.buf = new byte[n];
        this.bufferSize = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    public HttpOutputStream() {
        this(4096);
    }

    public void init(OutputStream outputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.next();
        this.initNewBuffer(outputStream, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void initNewBuffer(OutputStream outputStream, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initNewBuffer");
        }
        this.out = outputStream;
        if (bl) {
            this.buf = new byte[this.bufferSize];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initNewBuffer");
        }
    }

    public void init(OutputStream outputStream, boolean bl) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.next();
        this.initNewBuffer(outputStream, false);
        this.closeOnClose = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public void next() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"next");
        }
        this.count = 0;
        this.total = 0;
        this.limit = -1;
        this.length = -1;
        this.obs = null;
        this.committed = false;
        this.countedLength = 0;
        this.closeOnClose = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"next");
        }
    }

    public void finish() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finish");
        }
        if (this.length == -1 && this.countedLength != 0) {
            this.length = this.countedLength;
        }
        this.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finish");
        }
    }

    public void resets() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resets");
        }
        this.out = null;
        this.obs = null;
        this.doContentLengthCheck = false;
        this.closeOnClose = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resets");
        }
    }

    public int getTotal() {
        return this.total;
    }

    public void setContentLength(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setContentLength", (Object)String.valueOf(n));
        }
        if (n < 0) {
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Invalid Content Length");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setContentLength");
            }
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.Content.Length", "Illegal Argument: Invalid Content Length"));
        }
        this.length = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setContentLength");
        }
    }

    public void unsetContentLength() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetContentLength");
        }
        this.doContentLengthCheck = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetContentLength");
        }
    }

    public int getContentLength() {
        return this.length;
    }

    public void setObserver(Observer observer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setObserver", (Object)observer);
        }
        this.obs = observer;
        this.limit = -1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setObserver");
        }
    }

    public void setIOException(IOException iOException) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setIOException", (Object)iOException);
        }
        this.except = iOException;
        this.limit = -1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setIOException");
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    protected void check(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"check", (Object)String.valueOf(n));
        }
        if (this.except != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"check");
            }
            throw this.except;
        }
        if (n == 0) {
            return;
        }
        if (this.limit < 0) {
            if (this.total > 0) {
                Tr.error((TraceComponent)tc, (String)"Internal Error");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"check");
                }
                throw new InternalError();
            }
            this.limit = Integer.MAX_VALUE;
            if (this.length != -1 && this.length < Integer.MAX_VALUE - this.total) {
                this.limit = this.total + this.length;
            }
        }
        if (this.doContentLengthCheck && this.total + n > this.limit) {
            this.limit = -1;
            Tr.error((TraceComponent)tc, (String)"IO.Exception:.Tried.to.write.more.than.the.content.length");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"check");
            }
            this.except = new IOException("tried to write more than content length");
            throw this.except;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"check");
        }
    }

    public void write(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write");
        }
        if (this.total >= this.limit) {
            this.check(1);
        }
        if (this.count == this.buf.length) {
            this.flushBytes();
        }
        this.buf[this.count++] = (byte)n;
        ++this.total;
        ++this.countedLength;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write");
        }
        if (n2 < 0) {
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Trying to write < 0 bytes");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            throw new IllegalArgumentException();
        }
        if (this.total + n2 > this.limit) {
            this.check(n2);
        }
        if (n2 >= this.buf.length) {
            this.flushBytes();
            this.total += n2;
            this.writeOut(byArray, n, n2);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"write");
            }
            return;
        }
        int n3 = this.buf.length - this.count;
        if (n2 > n3) {
            this.flushBytes();
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
        this.total += n2;
        this.countedLength += n2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flush");
        }
        if (this.limit < 0) {
            this.check(0);
        }
        this.flushBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flush");
        }
    }

    protected void flushBytes() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushBytes");
        }
        if (!this.committed && this.obs != null) {
            this.obs.update(null, (Object)this);
        }
        this.committed = true;
        if (this.count > 0) {
            this.writeOut(this.buf, 0, this.count);
            this.out.flush();
            this.count = 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushBytes");
        }
    }

    public void print(String string) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"print", (Object)string);
        }
        if (this.total + (n = string.length()) > this.limit) {
            this.check(n);
        }
        int n2 = 0;
        while (n > 0) {
            int n3 = this.buf.length - this.count;
            if (n3 == 0) {
                this.flushBytes();
                n3 = this.buf.length - this.count;
            }
            if (n3 > n) {
                n3 = n;
            }
            string.getBytes(n2, n2 + n3, this.buf, this.count);
            this.count += n3;
            this.total += n3;
            n2 += n3;
            n -= n3;
            this.countedLength += n3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"print");
        }
    }

    public void print(HttpDate httpDate) throws IOException {
        int n;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"print", (Object)httpDate);
        }
        if (this.total + (n2 = HttpDate.DATELEN) > this.limit) {
            this.check(n2);
        }
        if ((n = this.buf.length - this.count) < n2) {
            this.flushBytes();
            n = this.buf.length - this.count;
        }
        n2 = httpDate.getBytes(this.buf, this.count, n);
        this.count += n2;
        this.total += n2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"print");
        }
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        this.finish();
        if (this.closeOnClose) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.srt.http.HttpOutputStream.close", (String)"532", (Object)((Object)this));
            }
            this.closeOnClose = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public void setHeader(byte[] byArray) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setHeader");
        }
        this.writeOut(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setHeader");
        }
    }

    public void setHeader(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setHeader");
        }
        this.writeOut(byArray, n, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setHeader");
        }
    }

    public OutputStream getRawOutputStream() {
        return this.out;
    }

    public void writeRaw(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeRaw");
        }
        if (!this.committed && this.obs != null) {
            this.obs.update(null, (Object)this);
        }
        this.committed = true;
        this.out.write(byArray, n, n2);
        this.total += n2;
        this.countedLength += n2;
        if (this.limit < 0 && (this.limit = this.length) < 0) {
            this.limit = Integer.MAX_VALUE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeRaw");
        }
    }

    protected void writeOut(byte[] byArray, int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeOut");
        }
        this.out.write(byArray, n, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeOut");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

