/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.ws.webcontainer.srt.http.MessageString;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class MimeHeaderField {
    protected final MessageString name = new MessageString();
    protected final MessageString value = new MessageString();
    protected int intValue;
    protected HttpDate dateValue;
    protected int type = 0;
    protected static final int T_NULL = 0;
    protected static final int T_STR = 1;
    protected static final int T_INT = 2;
    protected static final int T_DATE = 3;
    private static final byte[] charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$srt$http$MimeHeaderField == null ? (class$com$ibm$ws$webcontainer$srt$http$MimeHeaderField = MimeHeaderField.class$("com.ibm.ws.webcontainer.srt.http.MimeHeaderField")) : class$com$ibm$ws$webcontainer$srt$http$MimeHeaderField).getName(), (String)"Servlet_Engine");
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$srt$http$MimeHeaderField;

    public int getBytes(byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBytes");
        }
        int n2 = n;
        n += this.name.getBytes(byArray, n);
        byArray[n++] = 58;
        byArray[n++] = 32;
        switch (this.type) {
            case 1: {
                n += this.value.getBytes(byArray, n);
                break;
            }
            case 2: {
                n += this.intGetBytes(this.intValue, byArray, n);
                break;
            }
            case 3: {
                n += this.dateValue.getBytes(byArray, n, HttpDate.DATELEN);
            }
        }
        byArray[n++] = 13;
        byArray[n++] = 10;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getBytes");
        }
        return n - n2;
    }

    public long getDateValue() throws IllegalArgumentException {
        switch (this.type) {
            case 3: {
                return this.dateValue.getTime();
            }
            case 1: {
                if (this.dateValue == null) {
                    this.dateValue = new HttpDate();
                }
                return this.value.toDate(this.dateValue);
            }
        }
        Tr.error((TraceComponent)tc, (String)"Illegal Argument: Invalid Date Format");
        throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.Date.Format", "Illegal Argument: Invalid Date Format"));
    }

    public int getIntValue() throws NumberFormatException {
        switch (this.type) {
            case 2: {
                return this.intValue;
            }
            case 1: {
                return this.value.toInteger();
            }
        }
        Tr.error((TraceComponent)tc, (String)"Number Format Exception: Invalid Integer Format");
        throw new NumberFormatException(nls.getString("Number.Format.Exception", "Number Format Exception: Invalid Integer Format"));
    }

    public String getName() {
        return this.name.toString();
    }

    public String getValue() {
        switch (this.type) {
            case 1: {
                return this.value.toString();
            }
            case 2: {
                return String.valueOf(this.intValue);
            }
            case 3: {
                return this.dateValue.toString();
            }
        }
        return null;
    }

    private int intGetBytes(int n, byte[] byArray, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"intGetBytes");
        }
        int n3 = 0;
        if (n == 0) {
            byArray[n2] = charval[0];
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"intGetBytes - 1");
            }
            return 1;
        }
        for (int i = 1000000000; i > 0; i /= 10) {
            int n4 = n / i;
            if (n4 != 0 || n3 > 0) {
                byArray[n2 + n3++] = charval[n4];
            }
            n %= i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"intGetBytes");
        }
        return n3;
    }

    public boolean nameEquals(byte[] byArray, int n, int n2) {
        return this.name.equalsIgnoreCase(byArray, n, n2);
    }

    public boolean nameEquals(String string) {
        return this.name.equalsIgnoreCase(string);
    }

    public void parse(byte[] byArray, int n, int n2) throws IllegalArgumentException {
        byte by;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parse");
        }
        int n3 = n;
        while ((by = byArray[n++]) != 58 && by != 32) {
            if (by != 10) continue;
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Invalid Header Format");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parse");
            }
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.Header.Format", "Illegal Argument: Invalid Header Format"));
        }
        this.setName(byArray, n3, n - n3 - 1);
        while (by == 32) {
            by = byArray[n++];
        }
        if (by != 58) {
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Invalid Header Format");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parse");
            }
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.Header.Format", "Illegal Argument: Invalid Header Format"));
        }
        while ((by = byArray[n++]) == 32) {
        }
        this.setValue(byArray, n - 1, n2 - (n - n3 - 1));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parse");
        }
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset");
        }
        this.name.reset();
        this.value.reset();
        this.type = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public void setDateValue() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDateValue");
        }
        if (this.dateValue == null) {
            this.dateValue = new HttpDate();
        }
        this.dateValue.setTime();
        this.type = 3;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDateValue");
        }
    }

    public void setDateValue(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDateValue");
        }
        if (this.dateValue == null) {
            this.dateValue = new HttpDate();
        }
        this.dateValue.setTime(l);
        this.type = 3;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDateValue");
        }
    }

    public void setIntValue(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setIntValue");
        }
        this.intValue = n;
        this.type = 2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setIntValue");
        }
    }

    public void setName(byte[] byArray, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setName");
        }
        this.name.setBytes(byArray, n, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setName");
        }
    }

    public void setName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setName", (Object)string);
        }
        this.name.setString(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setName");
        }
    }

    public void setValue(byte[] byArray, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setValue");
        }
        this.value.setBytes(byArray, n, n2);
        this.type = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setValue");
        }
    }

    public void setValue(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setValue", (Object)string);
        }
        this.value.setString(string);
        this.type = 1;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setValue");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name.toString());
        stringBuffer.append(": ");
        switch (this.type) {
            case 1: {
                stringBuffer.append(this.value.toString());
                break;
            }
            case 2: {
                stringBuffer.append(this.intValue);
                break;
            }
            case 3: {
                stringBuffer.append(this.dateValue.toString());
            }
        }
        return stringBuffer.toString();
    }

    public void write(ServletOutputStream servletOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"write");
        }
        this.name.write(servletOutputStream);
        servletOutputStream.print(": ");
        switch (this.type) {
            case 1: {
                this.value.write(servletOutputStream);
                servletOutputStream.println();
                break;
            }
            case 2: {
                servletOutputStream.println(this.intValue);
                break;
            }
            case 3: {
                this.dateValue.write((OutputStream)servletOutputStream);
                servletOutputStream.println();
                break;
            }
            default: {
                servletOutputStream.println();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"write");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

