/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.util.Cacheable;
import com.ibm.ws.webcontainer.util.List;
import com.ibm.ws.webcontainer.util.ListEntry;
import com.ibm.ws.webcontainer.util.LocalStringManagerImpl;
import java.util.Hashtable;

public class LRUCache
extends Hashtable {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$ibm$ws$webcontainer$util$LRUCache == null ? (class$com$ibm$ws$webcontainer$util$LRUCache = LRUCache.class$("com.ibm.ws.webcontainer.util.LRUCache")) : class$com$ibm$ws$webcontainer$util$LRUCache);
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$util$LRUCache == null ? (class$com$ibm$ws$webcontainer$util$LRUCache = LRUCache.class$("com.ibm.ws.webcontainer.util.LRUCache")) : class$com$ibm$ws$webcontainer$util$LRUCache).getName(), (String)"Servlet_Utils");
    private int maxSize;
    private int currentSize = 0;
    private List lruList = null;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$util$LRUCache;

    public LRUCache(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor");
        }
        this.init(n, 100);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    public LRUCache(int n, float f, int n2) {
        super(n, f);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor");
        }
        this.init(n2, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    public LRUCache(int n, int n2) {
        super(n, 0.75f);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor");
        }
        this.init(n2, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    public synchronized Object get(Object object) {
        Cacheable cacheable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get", (Object)object);
        }
        if ((cacheable = (Cacheable)super.get(object)) != null) {
            this.lruList.makeLast((ListEntry)cacheable.getContext());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get");
        }
        return cacheable;
    }

    public int getAvailableSize() {
        return this.maxSize - this.currentSize;
    }

    public int getTotalSize() {
        return this.maxSize;
    }

    private void init(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.maxSize = n;
        this.currentSize = 0;
        this.lruList = new List(n2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public synchronized Object put(Object object, Cacheable cacheable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put", (Object)object);
        }
        int n = this.lruList.size();
        if (cacheable.size() > this.maxSize) {
            Tr.error((TraceComponent)tc, (String)"Out Of Memory: Object too big for cache.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"put");
            }
            throw new OutOfMemoryError("Object too big for cache.");
        }
        if (this.containsKey(object)) {
            this.remove(object);
        }
        while (this.getAvailableSize() < cacheable.size()) {
            Object object2 = this.lruList.firstElement();
            Cacheable cacheable2 = (Cacheable)super.get(object2);
            if (cacheable2.replaceNotify()) {
                this.remove(object2);
            } else {
                this.lruList.makeLast((ListEntry)cacheable2.getContext());
            }
            if (--n != 0) continue;
            Tr.error((TraceComponent)tc, (String)"Out Of Memory: Cannot make space for new object.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"put");
            }
            throw new OutOfMemoryError(localStrings.getLocalString("utils.no_memory2", "Cannot make space for new object."));
        }
        this.currentSize += cacheable.size();
        cacheable.setContext(this.lruList.insertTail(object));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put");
        }
        return super.put(object, cacheable);
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 instanceof Cacheable) {
            return this.put(object, (Cacheable)object2);
        }
        throw new IllegalArgumentException();
    }

    public synchronized Object remove(Object object) {
        Cacheable cacheable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)object);
        }
        if ((cacheable = (Cacheable)super.remove(object)) != null) {
            this.lruList.deleteListEntry((ListEntry)cacheable.getContext());
            this.currentSize -= cacheable.size();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
        return cacheable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

