/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.util.ListEntry;
import com.ibm.ws.webcontainer.util.Pool;
import java.util.Enumeration;
import java.util.Vector;

public class List {
    private ListEntry head = null;
    private ListEntry tail = null;
    private int count = 0;
    private Pool listEntry = null;

    public List() {
        this(20);
    }

    public List(int n) {
        this.count = n;
        try {
            this.listEntry = new Pool("com.ibm.ws.webcontainer.util.ListEntry", n);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.util.List.List", (String)"47", (Object)this);
            System.out.println(exception.getMessage());
        }
    }

    public synchronized Object firstElement() {
        if (this.head == null) {
            return null;
        }
        return this.head.element;
    }

    public synchronized Object lastElement() {
        if (this.tail == null) {
            return null;
        }
        return this.tail.element;
    }

    public synchronized ListEntry insertHead(Object object) {
        ListEntry listEntry = this.getNewListEntry();
        listEntry.element = object;
        this.insertEntryAtHead(listEntry);
        return listEntry;
    }

    public synchronized ListEntry insertTail(Object object) {
        ListEntry listEntry = this.getNewListEntry();
        listEntry.element = object;
        this.insertEntryAtTail(listEntry);
        return listEntry;
    }

    public synchronized Object delete(Object object) {
        ListEntry listEntry = this.findEntry(object);
        return this.deleteListEntry(listEntry);
    }

    public synchronized Object deleteListEntry(ListEntry listEntry) {
        if (listEntry == null || listEntry.deleted) {
            return null;
        }
        if (listEntry.previous != null) {
            listEntry.previous.next = listEntry.next;
        }
        if (listEntry.next != null) {
            listEntry.next.previous = listEntry.previous;
        }
        if (this.head.equals(listEntry)) {
            this.head = listEntry.next;
        }
        if (this.tail.equals(listEntry)) {
            this.tail = listEntry.previous;
        }
        listEntry.deleted = true;
        listEntry.previous = null;
        listEntry.next = null;
        --this.count;
        return listEntry.element;
    }

    public synchronized Object deleteHead() {
        ListEntry listEntry = this.head;
        return this.deleteListEntry(listEntry);
    }

    public synchronized Object deleteTail() {
        ListEntry listEntry = this.tail;
        return this.deleteListEntry(listEntry);
    }

    public synchronized void deleteAll() {
        this.tail = null;
        this.head = null;
    }

    public synchronized void makeFirst(ListEntry listEntry) {
        Object object = this.deleteListEntry(listEntry);
        if (object != null) {
            this.insertEntryAtHead(listEntry);
        }
    }

    public synchronized void makeLast(ListEntry listEntry) {
        Object object = this.deleteListEntry(listEntry);
        if (object != null) {
            this.insertEntryAtTail(listEntry);
        }
    }

    public synchronized Enumeration elements() {
        Vector<Object> vector = new Vector<Object>(this.count);
        ListEntry listEntry = this.head;
        while (listEntry != null) {
            vector.addElement(listEntry.element);
            listEntry = listEntry.next;
        }
        return vector.elements();
    }

    public synchronized int size() {
        return this.count;
    }

    private void insertEntryAtHead(ListEntry listEntry) {
        if (this.head == null) {
            this.head = this.tail = listEntry;
            listEntry.previous = null;
            listEntry.next = null;
        } else {
            listEntry.next = this.head;
            this.head.previous = listEntry;
            listEntry.previous = null;
            this.head = listEntry;
        }
        ++this.count;
        listEntry.deleted = false;
    }

    private void insertEntryAtTail(ListEntry listEntry) {
        if (this.tail == null) {
            this.head = this.tail = listEntry;
            listEntry.previous = null;
            listEntry.next = null;
        } else {
            listEntry.next = null;
            listEntry.previous = this.tail;
            this.tail.next = listEntry;
            this.tail = listEntry;
        }
        ++this.count;
        listEntry.deleted = false;
    }

    private ListEntry findEntry(Object object) {
        ListEntry listEntry = this.head;
        while (listEntry != null) {
            if (listEntry.element.equals(object)) {
                return listEntry;
            }
            listEntry = listEntry.next;
        }
        return null;
    }

    private void p(String string) {
        System.out.println(string);
    }

    private ListEntry getNewListEntry() {
        ListEntry listEntry = (ListEntry)this.listEntry.alloc();
        listEntry.next = null;
        listEntry.previous = null;
        listEntry.deleted = false;
        listEntry.element = null;
        return listEntry;
    }

    private void returnListEntry(ListEntry listEntry) {
        this.listEntry.free(listEntry);
    }
}

