/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;

public class Pool {
    protected Class cl;
    protected Object[] free = null;
    protected int count;
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");

    public Pool(String string, int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException(nls.getString("invalid.count", "invalid count"));
        }
        this.count = n;
        try {
            this.init(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.webcontainer.util.Pool.Pool", (String)"67", (Object)this);
            throw new IllegalArgumentException(nls.getString("class.not.found", "class not found"));
        }
    }

    public Pool(String string) throws IllegalArgumentException {
        this(string, 1);
    }

    public Pool(Class clazz, int n) throws IllegalArgumentException {
        this.count = n;
        this.init(clazz);
    }

    public Pool(Class clazz) throws IllegalArgumentException {
        this(clazz, 1);
    }

    protected void init(Class clazz) throws IllegalArgumentException {
        this.free = new Object[this.count];
        try {
            for (int i = 0; i < this.count; ++i) {
                this.free[i] = clazz.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.webcontainer.util.Pool.init", (String)"117", (Object)this);
            throw new IllegalArgumentException(nls.getString("class.could.not.be.instantiated", "class could not be instantiated"));
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.webcontainer.util.Pool.init", (String)"120", (Object)this);
            throw new IllegalArgumentException(nls.getString("class.not.accessible", "class not accessible"));
        }
        this.cl = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object alloc() {
        Pool pool = this;
        synchronized (pool) {
            if (this.count > 0) {
                return this.free[--this.count];
            }
        }
        try {
            return this.cl.newInstance();
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.webcontainer.util.Pool.alloc", (String)"140", (Object)this);
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.webcontainer.util.Pool.alloc", (String)"143", (Object)this);
            throw new InternalError();
        }
    }

    public synchronized void free(Object object) {
        if (this.count >= this.free.length) {
            Object[] objectArray = new Object[this.free.length * 2];
            System.arraycopy(this.free, 0, objectArray, 0, this.free.length);
            this.free = objectArray;
        }
        this.free[this.count++] = object;
    }
}

