/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.util.ExProperties;
import com.ibm.ws.webcontainer.util.REException;
import com.ibm.ws.webcontainer.util.RegexpPool;
import com.ibm.ws.webcontainer.util.StringMatchNode;
import com.ibm.ws.webcontainer.util.StringMatchResult;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class StringMatcher {
    private Hashtable table = new Hashtable();
    private RegexpPool basicRules = new RegexpPool();
    private HashMap exactMap = new HashMap();

    public StringMatcher() {
    }

    public StringMatcher(Reader reader) throws IOException {
        this.load(reader);
    }

    public StringMatcher(String string) throws IOException {
        this.load(string);
    }

    public synchronized void load(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.load(bufferedReader);
        ((Reader)bufferedReader).close();
    }

    public synchronized void load(Reader reader) throws IOException {
        ExProperties exProperties = new ExProperties();
        exProperties.load(reader);
        this.load(exProperties);
    }

    public synchronized void load(ExProperties exProperties) {
        this.clear();
        Enumeration<Object> enumeration = exProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)exProperties.get(string);
            if (string2 == null) continue;
            try {
                this.put(string, string2.trim());
            }
            catch (REException rEException) {
                FFDCFilter.processException((Throwable)rEException, (String)"com.ibm.ws.webcontainer.util.StringMatcher.load", (String)"125", (Object)this);
            }
        }
    }

    public synchronized String put(String string, String string2) throws REException {
        string = StringMatcher.normalize(string);
        Object object = this.target(string2);
        if (string.equals("/")) {
            try {
                this.basicRules.add(string + "*", new StringMatchNode(string, object));
            }
            catch (REException rEException) {}
        } else if (string.startsWith("/") && string.endsWith("/*")) {
            try {
                this.basicRules.add(string, new StringMatchNode(string, object));
                String string3 = string.substring(0, string.lastIndexOf("/*"));
                this.exactMap.put(string3, new StringMatchResult(string3, null, object));
            }
            catch (REException rEException) {}
        } else if (string.startsWith("*.")) {
            try {
                this.basicRules.add(string, new StringMatchNode(string, object));
            }
            catch (REException rEException) {}
        } else {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            this.exactMap.put(string, new StringMatchResult(string, null, object));
        }
        return this.table.put(string, string2);
    }

    public synchronized String get(String string) {
        return (String)this.table.get(StringMatcher.normalize(string));
    }

    public synchronized String remove(String string) {
        if ((string = StringMatcher.normalize(string)).startsWith("/") && string.endsWith("/*") || string.startsWith("*.") || string.equals("/")) {
            this.basicRules.delete(string);
            if (string.endsWith("/*")) {
                this.exactMap.remove(string.substring(0, string.lastIndexOf("/*")));
            }
        } else {
            this.exactMap.remove(string);
        }
        return (String)this.table.remove(string);
    }

    public synchronized StringMatchResult match(String string) {
        int n;
        if (!string.startsWith("/~")) {
            return this.matchPath(string);
        }
        this.basicRules.reset();
        String string2 = null;
        String string3 = null;
        StringMatchResult stringMatchResult = (StringMatchResult)this.basicRules.matchNext(string);
        if (stringMatchResult == null) {
            return null;
        }
        int n2 = string.indexOf("~");
        string3 = string.substring(n2 + 1, n = string.length());
        int n3 = string3.indexOf("/");
        if (n3 != -1) {
            string2 = string3.substring(0, n3);
            string3 = string3.substring(n3, string3.length());
        } else {
            string2 = string3.substring(0, string3.length());
            string3 = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = (String)stringMatchResult.getTarget();
        int n4 = string4.indexOf("$");
        if (n4 != -1) {
            String string5 = string4.substring(0, n4);
            String string6 = string4.substring(n4 + 5, string4.length());
            stringBuffer.append(string5);
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string6);
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            stringMatchResult.target = stringBuffer.toString();
            stringMatchResult.rest = null;
        }
        return stringMatchResult;
    }

    public synchronized Enumeration paths() {
        return this.table.keys();
    }

    public synchronized void clear() {
        this.basicRules = new RegexpPool();
        this.exactMap.clear();
        this.table.clear();
    }

    private static String normalize(String string) {
        if (string.startsWith("/~")) {
            return "/~";
        }
        if (StringMatcher.isProxy(string)) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        char c = cArray[0];
        int n2 = 1;
        int n3 = 1;
        while (n2 < n) {
            if (c == '/') {
                if ((c = cArray[n2++]) == '/') continue;
                cArray[n3++] = c;
                continue;
            }
            cArray[n3++] = c = cArray[n2++];
        }
        if (n3 > 1 && cArray[n3 - 1] == '/') {
            --n3;
        }
        return new String(cArray, 0, n3);
    }

    public String toString() {
        return this.basicRules.toString();
    }

    Object target(String string) {
        return string;
    }

    private synchronized StringMatchResult matchPath(String string) {
        StringMatchResult stringMatchResult = null;
        stringMatchResult = (StringMatchResult)this.exactMap.get(string);
        if (stringMatchResult != null) {
            return stringMatchResult;
        }
        this.basicRules.reset();
        stringMatchResult = (StringMatchResult)this.basicRules.matchNext(string);
        if (stringMatchResult != null) {
            if (stringMatchResult.getMatchedPath().endsWith("/*")) {
                stringMatchResult.setMatchedPath(stringMatchResult.getMatchedPath().substring(0, stringMatchResult.getMatchedPath().lastIndexOf("/*")));
            }
            if (!stringMatchResult.getRest().startsWith("/") && stringMatchResult.getRest().length() != 0) {
                stringMatchResult.setRest("/" + stringMatchResult.getRest());
            }
            return stringMatchResult;
        }
        return null;
    }

    private static boolean isProxy(String string) {
        return string.endsWith("://");
    }

    public void debug() {
        Enumeration enumeration = this.table.keys();
        System.out.println("String Matcher Table:");
        System.out.println("====================================");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.table.get(string);
            System.out.println(string + " --> " + string2);
        }
        System.out.println("");
    }

    public void addToExactMap(String string, String string2) {
        Object object = this.target(string2);
        this.exactMap.put(string, new StringMatchResult(string, null, object));
    }

    public static void main(String[] stringArray) {
        try {
            StringMatcher stringMatcher = new StringMatcher(stringArray[0]);
            stringMatcher.debug();
            StringMatchResult stringMatchResult = stringMatcher.match(stringArray[1]);
            if (stringMatchResult == null) {
                System.out.println("No Match Found!");
            } else {
                System.out.println("Returned Match: [" + stringMatchResult.getMatchedPath() + ", " + stringMatchResult.getRest() + ", " + stringMatchResult.getTarget() + "]");
                System.out.println("Target: " + stringMatchResult.getTarget());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.util.StringMatcher.main", (String)"473");
            exception.printStackTrace();
        }
    }
}

