/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util.objectpool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.util.SimpleHashtable;
import com.ibm.ws.webcontainer.util.objectpool.IPoolSession;
import com.ibm.ws.webcontainer.util.objectpool.ObjectPool;
import com.ibm.ws.webcontainer.util.objectpool.ObjectPoolException;
import com.ibm.ws.webcontainer.util.objectpool.PoolSession;
import com.ibm.ws.webcontainer.util.objectpool.PoolSessionException;

public class ObjectPoolManager {
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");
    private static ObjectPoolManager m_ObjectPoolManager = new ObjectPoolManager();
    private static SimpleHashtable m_objectPoolTable = new SimpleHashtable();
    private static ObjectPool m_poolSessionPool = new ObjectPool(class$com$ibm$ws$webcontainer$util$objectpool$PoolSession == null ? (class$com$ibm$ws$webcontainer$util$objectpool$PoolSession = ObjectPoolManager.class$("com.ibm.ws.webcontainer.util.objectpool.PoolSession")) : class$com$ibm$ws$webcontainer$util$objectpool$PoolSession);
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$util$objectpool$ObjectPoolManager == null ? (class$com$ibm$ws$webcontainer$util$objectpool$ObjectPoolManager = ObjectPoolManager.class$("com.ibm.ws.webcontainer.util.objectpool.ObjectPoolManager")) : class$com$ibm$ws$webcontainer$util$objectpool$ObjectPoolManager).getName(), (String)"Servlet_Engine");
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$util$objectpool$PoolSession;
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$util$objectpool$ObjectPoolManager;

    private ObjectPoolManager() {
    }

    public static PoolSession getPoolSession() throws PoolSessionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPoolSession");
        }
        PoolSession poolSession = null;
        try {
            poolSession = (PoolSession)m_poolSessionPool.getObjectFromPool();
            poolSession.initPoolSession(m_ObjectPoolManager);
        }
        catch (ObjectPoolException objectPoolException) {
            FFDCFilter.processException((Throwable)objectPoolException, (String)"com.ibm.ws.webcontainer.util.objectpool.ObjectPoolManager.getPoolSession", (String)"64");
            Tr.error((TraceComponent)tc, (String)"Error creating an instance of the input class!", (Object)objectPoolException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPoolSession");
            }
            throw new PoolSessionException(nls.getString("Error.creating.instance.of.input.class", "Error creating an instance of the input class!"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPoolSession");
        }
        return poolSession;
    }

    protected Object getObject(Class clazz) throws ObjectPoolException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObject", (Object)clazz);
        }
        ObjectPool objectPool = this.getObjectPoolTableEntry(clazz);
        Object object = objectPool.getObjectFromPool();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObject");
        }
        return object;
    }

    protected void returnObject(Class clazz, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"returnObject", (Object)object);
        }
        ObjectPool objectPool = this.getObjectPoolTableEntry(clazz);
        objectPool.returnObjectToPool(object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"returnObject");
        }
    }

    protected void returnPoolSession(IPoolSession iPoolSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"returnPoolSession", (Object)iPoolSession);
        }
        m_poolSessionPool.returnObjectToPool(iPoolSession);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"returnPoolSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectPool getObjectPoolTableEntry(Class clazz) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjectPoolTableEntry", (Object)clazz);
        }
        ObjectPoolManager objectPoolManager = this;
        synchronized (objectPoolManager) {
            ObjectPool objectPool = null;
            if (m_objectPoolTable.containsKey(clazz)) {
                objectPool = (ObjectPool)m_objectPoolTable.get(clazz);
            } else {
                objectPool = new ObjectPool(clazz);
                m_objectPoolTable.put(clazz, objectPool);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectPoolTableEntry");
            }
            return objectPool;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

