/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.webapp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.servlet.LoadTargetServletFailure;
import com.ibm.ws.webcontainer.servlet.ServletReference;
import com.ibm.ws.webcontainer.servlet.ServletReferenceEvent;
import com.ibm.ws.webcontainer.servlet.ServletReferenceListener;
import com.ibm.ws.webcontainer.servlet.exception.NoTargetForURIException;
import com.ibm.ws.webcontainer.util.StringMatchResult;
import com.ibm.ws.webcontainer.util.StringMatcher;
import com.ibm.ws.webcontainer.webapp.WebApp;
import javax.servlet.ServletException;

public class WebAppRequestDispatcherInfo
implements ServletReferenceListener {
    private static TraceComponent tc = Tr.register((String)(class$com$ibm$ws$webcontainer$webapp$WebAppRequestDispatcherInfo == null ? (class$com$ibm$ws$webcontainer$webapp$WebAppRequestDispatcherInfo = WebAppRequestDispatcherInfo.class$("com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcherInfo")) : class$com$ibm$ws$webcontainer$webapp$WebAppRequestDispatcherInfo).getName(), (String)"WEBAPP");
    private WebApp _webapp;
    private String _relativeURI;
    private String _fullURI;
    private String _requestURI;
    private String _pathInfo;
    private String _contextPath;
    private String _servletPath;
    private String _matchedPath;
    private String _additionalQueryString = null;
    private ServletReference _targetServlet;
    private ServletException _error;
    private static String sessUrlRewritePrefix = ";jsessionid=";
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$webapp$WebAppRequestDispatcherInfo;

    WebAppRequestDispatcherInfo(WebApp webApp, String string) {
        this._webapp = webApp;
        this._relativeURI = string;
        this._contextPath = this._webapp.getRootURI();
        this._fullURI = !this._contextPath.equals("/") ? this._contextPath + string : string;
        this._servletPath = this._fullURI;
        this._requestURI = this._fullURI;
        int n = this._requestURI.indexOf("?");
        if (n != -1) {
            this._requestURI = this._requestURI.substring(0, n);
        }
        this.calculateInfo();
    }

    public String getRelativeURI() {
        return this._relativeURI;
    }

    public String getFullURI() {
        return this._fullURI;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    String getPathInfo() {
        return this._pathInfo;
    }

    String getMatchedPath() {
        return this._matchedPath;
    }

    String getAdditionalQueryString() {
        return this._additionalQueryString;
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    ServletReference getTargetServlet() throws ServletException {
        if (this._error != null) {
            throw this._error;
        }
        if (this._targetServlet != null) {
            return this._targetServlet;
        }
        WebAppRequestDispatcherInfo webAppRequestDispatcherInfo = this;
        synchronized (webAppRequestDispatcherInfo) {
            if (this._targetServlet != null) {
                return this._targetServlet;
            }
            throw new NoTargetForURIException(this.getFullURI());
        }
    }

    void calculateInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WebAppRequestDispatcherInfo.calculateInfo()");
        }
        String string = this.getFullURI();
        StringMatcher stringMatcher = this._webapp.getURIToServletNameTable();
        String string2 = this.getRelativeURI();
        String string3 = null;
        if (string2.endsWith("j_security_check")) {
            try {
                this._targetServlet = this._webapp.getServletReference("FormLoginServlet", this);
                this._servletPath = this.decodeURL(string2);
                this._pathInfo = null;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcherInfo.calculateInfo", (String)"139", (Object)this);
                this._error = new LoadTargetServletFailure("FormLoginServlet", throwable);
            }
        } else if (string2.endsWith("ibm_security_logout")) {
            try {
                this._targetServlet = this._webapp.getServletReference("FormLogoutServlet", this);
                this._servletPath = this.decodeURL(string2);
                this._pathInfo = null;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcherInfo.calculateInfo", (String)"153", (Object)this);
                this._error = new LoadTargetServletFailure("FormLogoutServlet", throwable);
            }
        } else {
            StringMatchResult stringMatchResult = stringMatcher.match(this.decodeURL(string2));
            if (stringMatchResult != null) {
                string3 = (String)stringMatchResult.getTarget();
            }
            if (string3 != null) {
                try {
                    this._targetServlet = this._webapp.getServletReference(string3, this);
                    this._matchedPath = stringMatchResult.getMatchedPath();
                    if (this._matchedPath.startsWith("*")) {
                        this._servletPath = stringMatchResult.getRest() + this._matchedPath.substring(1);
                        this._pathInfo = null;
                    } else {
                        this._servletPath = this._matchedPath;
                        this._pathInfo = stringMatchResult.getRest();
                        if (this._pathInfo != null) {
                            if (this._pathInfo.equals("")) {
                                this._pathInfo = null;
                                if (string2 != null && string2.length() > 1 && string2.endsWith("/")) {
                                    this._pathInfo = "/";
                                }
                            } else if (this._servletPath.equals("/") && this._pathInfo.charAt(0) == '/') {
                                this._servletPath = "";
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcherInfo.calculateInfo", (String)"214", (Object)this);
                    this._error = new LoadTargetServletFailure(string3, throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WebAppRequestDispatcherInfo.calculateInfo()");
        }
    }

    String decodeURL(String string) {
        int n = string.indexOf(sessUrlRewritePrefix);
        int n2 = string.indexOf("?");
        if (n2 != -1) {
            if (n > n2) {
                throw new IllegalArgumentException("'jsessionid' Must occur before '?' in URL.");
            }
            this._additionalQueryString = string.substring(n2 + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"_additionalQueryString = ", (Object)this._additionalQueryString);
            }
            string = string.substring(0, n2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"url now = ", (Object)string);
            }
        }
        if (n != -1) {
            string = string.substring(0, n);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"url now = ", (Object)string);
            }
        }
        string = this.decodeUriEscape(string);
        return string;
    }

    private String decodeUriEscape(String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decodeUriEscape");
        }
        if ((n = string.indexOf("%")) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        int n2 = 0;
        int n3 = 0;
        char c = ' ';
        int n4 = 0;
        int n5 = string.length();
        while (n >= 0) {
            if (n5 >= n + 3) {
                n2 = this.toHex(string.charAt(n + 1));
                n3 = this.toHex(string.charAt(n + 2));
                c = (char)((n2 << 4) + n3);
                stringBuffer.append(c);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"decodeUriEscape", (Object)(string.substring(n, n + 3) + " -> " + c));
                }
                n += 3;
                n4 = n;
                if (n4 >= (n = string.indexOf("%", n))) continue;
                stringBuffer.append(string.substring(n4, n));
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"decodeUriEscape", (Object)("Wrong escape sequence: " + string.substring(n)));
            }
            n4 = n;
            break;
        }
        if (n4 < n5) {
            stringBuffer.append(string.substring(n4));
        }
        string = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decodeUriEscape", (Object)string);
        }
        return string;
    }

    private int toHex(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    public void servletReferenceInvalidated(ServletReferenceEvent servletReferenceEvent) {
        this._targetServlet = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (WebContainer.getWebContainerProperties().get("SessionRewriteIdentifier") != null) {
            sessUrlRewritePrefix = ";" + WebContainer.getWebContainerProperties().get("SessionRewriteIdentifier") + "=";
        }
    }
}

