/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.Beans;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.jasper.JasperException;

public class BeanRepository {
    Vector sessionBeans = new Vector(11);
    Vector pageBeans = new Vector(11);
    Vector appBeans = new Vector(11);
    Vector requestBeans = new Vector(11);
    Hashtable beanTypes = new Hashtable();
    ClassLoader loader;

    public BeanRepository(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public boolean checkSessionBean(String string) {
        return this.sessionBeans.contains(string);
    }

    public void addSessionBean(String string, String string2) throws JasperException {
        this.sessionBeans.addElement(string);
        this.putBeanType(string, string2);
    }

    public boolean hasSessionBeans() {
        return !this.sessionBeans.isEmpty();
    }

    public Enumeration getSessionBeans() {
        return this.sessionBeans.elements();
    }

    public boolean checkApplicationBean(String string) {
        return this.appBeans.contains(string);
    }

    public void addApplicationBean(String string, String string2) throws JasperException {
        this.appBeans.addElement(string);
        this.putBeanType(string, string2);
    }

    public boolean hasApplicationBeans() {
        return !this.appBeans.isEmpty();
    }

    public Enumeration getApplicationBeans() {
        return this.appBeans.elements();
    }

    public boolean checkRequestBean(String string) {
        return this.requestBeans.contains(string);
    }

    public void addRequestBean(String string, String string2) throws JasperException {
        this.requestBeans.addElement(string);
        this.putBeanType(string, string2);
    }

    public boolean hasRequestBeans() {
        return !this.requestBeans.isEmpty();
    }

    public Enumeration getRequestBeans() {
        return this.requestBeans.elements();
    }

    public boolean checkPageBean(String string) {
        return this.pageBeans.contains(string);
    }

    public void addPageBean(String string, String string2) throws JasperException {
        this.pageBeans.addElement(string);
        this.putBeanType(string, string2);
    }

    public boolean hasPageBeans() {
        return !this.pageBeans.isEmpty();
    }

    public Enumeration getPageBeans() {
        return this.pageBeans.elements();
    }

    public boolean ClassFound(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.loader.loadClass(string);
        return clazz != null;
    }

    public Class getBeanType(String string) throws JasperException {
        Class<?> clazz = null;
        try {
            clazz = this.loader.loadClass((String)this.beanTypes.get(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JasperException(classNotFoundException.toString(), classNotFoundException);
        }
        return clazz;
    }

    public void putBeanType(String string, String string2) throws JasperException {
        try {
            this.beanTypes.put(string, string2);
        }
        catch (Exception exception) {
            throw new JasperException(exception.toString(), exception);
        }
    }

    public void removeBeanType(String string) {
        this.beanTypes.remove(string);
    }

    public boolean checkVariable(String string) {
        return this.checkPageBean(string) || this.checkSessionBean(string) || this.checkRequestBean(string) || this.checkApplicationBean(string);
    }

    public Class getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (string != null) {
            clazz = this.loader.loadClass(string);
        }
        return clazz;
    }

    public boolean beanFound(String string) throws ClassNotFoundException {
        try {
            Beans.instantiate(Thread.currentThread().getContextClassLoader(), string);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

