/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.jasper.CommandLineContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;

public class CommandLineCompiler
extends Compiler
implements Mangler {
    String javaFileName;
    String classFileName;
    String packageName;
    String pkgName;
    String className;
    File jsp;
    String outputDir;
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public CommandLineCompiler(CommandLineContext commandLineContext) {
        super(commandLineContext);
        this.jsp = new File(commandLineContext.getJspFile());
        this.outputDir = commandLineContext.getOptions().getScratchDir().getAbsolutePath();
        this.pkgName = this.packageName = commandLineContext.getServletPackageName();
        this.setMangler(this);
        this.className = this.getBaseClassName();
        if (commandLineContext.isOutputInDirs()) {
            String string = this.outputDir + File.separatorChar + this.pkgName.replace('.', File.separatorChar);
            File file = new File(string);
            if (!file.exists()) {
                if (file.mkdirs()) {
                    this.outputDir = string;
                }
            } else {
                this.outputDir = string;
            }
        }
        this.computeClassFileName();
        this.computeJavaFileName();
    }

    public boolean isOutDated() {
        return true;
    }

    public final void computeJavaFileName() {
        this.javaFileName = this.ctxt.getServletClassName() + ".java";
        if ("null.java".equals(this.javaFileName)) {
            this.javaFileName = this.getBaseClassName() + ".java";
        }
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = this.outputDir + File.separatorChar + this.javaFileName;
        }
    }

    void computeClassFileName() {
        this.classFileName = this.getBaseClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = this.outputDir + File.separatorChar + this.classFileName;
        }
    }

    private final String getInitialClassName() {
        return this.getBaseClassName();
    }

    private final String getBaseClassName() {
        String string = this.ctxt.getServletClassName();
        if (string == null) {
            string = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        }
        return CommandLineCompiler.mangleName(string);
    }

    private static final String mangleName(String string) {
        for (int i = 0; i < keywords.length; ++i) {
            if (!string.equals(keywords[i])) continue;
            string = string + "%";
            break;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuffer.append(string.charAt(0));
        } else {
            stringBuffer.append(CommandLineCompiler.mangleChar(string.charAt(0)));
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            stringBuffer.append(CommandLineCompiler.mangleChar(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    private static final String mangleChar(char c) {
        int n;
        if (c == File.separatorChar) {
            c = (char)47;
        }
        String string = Integer.toHexString(c);
        int n2 = 5 - string.length();
        char[] cArray = new char[6];
        cArray[0] = 95;
        for (n = 1; n <= n2; ++n) {
            cArray[n] = 48;
        }
        n = n2 + 1;
        int n3 = 0;
        while (n < 6) {
            cArray[n] = string.charAt(n3);
            ++n;
            ++n3;
        }
        return new String(cArray);
    }

    public static String manglePackage(String string) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(CommandLineCompiler.mangleName(string2));
        }
        return stringBuffer.toString();
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getJavaFileName() {
        return this.javaFileName;
    }

    public final String getClassFileName() {
        return this.classFileName;
    }
}

