/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.ibm.ws.util.ExtendedDocumentRootUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspLineMap;
import org.apache.jasper.compiler.JspLineMapItem;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ServletWriter;
import org.xml.sax.Attributes;

public class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspCompilationContext ctxt;
    protected boolean jspFileExists = true;
    public ExtendedDocumentRootUtils extDocRootUtils = null;

    public Compiler(JspCompilationContext jspCompilationContext) {
        this.ctxt = jspCompilationContext;
        this.extDocRootUtils = jspCompilationContext.getExtendedDocumentRootUtils();
    }

    public ExtendedDocumentRootUtils getExtendedDocumentRootUtils() {
        return this.extDocRootUtils;
    }

    public boolean compile() throws FileNotFoundException, JasperException, Exception {
        return this.compile(false);
    }

    public boolean compile(boolean bl) throws FileNotFoundException, JasperException, Exception {
        OutputStreamWriter outputStreamWriter;
        String string = this.mangler.getClassFileName();
        String string2 = this.mangler.getClassName();
        this.ctxt.setServletClassName(string2);
        Constants.message("jsp.message.class_name_is", new Object[]{string2}, 4);
        if (!this.isOutDated() && !bl) {
            return false;
        }
        String string3 = this.mangler.getJavaFileName();
        this.ctxt.setServletJavaFileName(string3);
        Constants.message("jsp.message.java_file_name_is", new Object[]{string3}, 4);
        String string4 = this.ctxt.getOptions().getJavaEncoding();
        if (string4 == null) {
            string4 = "UTF8";
        }
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string3), string4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JasperException(Constants.getString("jsp.error.invalid.javaEncoding", new Object[]{"UTF8", string4}));
        }
        ServletWriter servletWriter = new ServletWriter(new PrintWriter(outputStreamWriter));
        this.ctxt.setWriter(servletWriter);
        ParserController parserController = new ParserController(this.ctxt);
        parserController.parse(this.ctxt.getJspFile(), this.extDocRootUtils);
        ParseEventListener parseEventListener = parserController.getParseEventListener();
        parseEventListener.beginPageProcessing();
        parseEventListener.endPageProcessing();
        servletWriter.close();
        ((JspParseEventListener)parseEventListener).validate();
        String string5 = this.ctxt.getClassPath();
        String string6 = System.getProperty("path.separator");
        String[] stringArray = new String[]{"-encoding", string4, "-classpath", System.getProperty("java.class.path") + string6 + string5, "-d", this.ctxt.getOutputDir(), string3};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        Constants.message("jsp.message.compiling_with", new Object[]{stringBuffer.toString()}, 4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        if (this.javac == null) {
            return true;
        }
        this.javac.setEncoding(string4);
        this.javac.setClasspath(System.getProperty("java.class.path") + string6 + string5);
        this.javac.setOutputDir(this.ctxt.getJavacOutputDir());
        this.javac.setMsgOutput(byteArrayOutputStream);
        this.javac.setClassDebugInfo(this.ctxt.getOptions().getClassDebugInfo());
        this.javac.setVerbose(this.ctxt.getOptions().getVerbose());
        this.javac.setDeprecation(this.ctxt.getOptions().getDeprecation());
        boolean bl2 = this.javac.compile(string3);
        File file = new File(string3);
        if (!this.ctxt.keepGenerated() && file != null) {
            file.delete();
        }
        if (bl2) {
            String string7;
            File file2;
            File file3;
            String string8 = string.substring(0, string.lastIndexOf("."));
            string8 = string8 + ".dat";
            String string9 = this.ctxt.getJspFile();
            File file4 = new File(this.ctxt.getRealPath(string9));
            long l = 0L;
            if (file4.exists()) {
                l = file4.lastModified();
            } else {
                try {
                    l = this.extDocRootUtils.getLastModifiedMatchedFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (file != null && file.exists()) {
                file.setLastModified(l);
            }
            if ((file3 = new File(string8)).exists()) {
                file3.setLastModified(l);
            }
            if ((file2 = new File(string)).exists()) {
                file2.setLastModified(l);
            }
            if ((string7 = byteArrayOutputStream.toString()) != null && string7.trim().length() > 0) {
                System.out.println(string7);
            }
        } else {
            String string10 = byteArrayOutputStream.toString();
            string10 = this.getJspLineErrors(string10, servletWriter.getLineMap());
            throw new JasperException(Constants.getString("jsp.error.unable.compile") + string10);
        }
        return true;
    }

    private String getJspLineErrors(String string, JspLineMap jspLineMap) throws IOException {
        String string2;
        if (jspLineMap == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n;
            int n2 = string2.indexOf(58, 2);
            int n3 = string2.indexOf(58, n2 + 1);
            if (!(n2 < 0 || n3 < 0 || string2.startsWith("Note: ") || string2.startsWith("[loaded ") || string2.startsWith("[parsed "))) {
                try {
                    String string3 = string2.substring(n2 + 1, n3);
                    n = Integer.parseInt(string3);
                    String string4 = this.findMapping(jspLineMap, n);
                    if (string4 == null) {
                        stringBuffer.append('\n');
                    } else {
                        stringBuffer.append(string4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            for (int i = 0; i < string2.length(); ++i) {
                n = string2.charAt(i);
                if (n == 60) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (n == 62) {
                    stringBuffer.append("&gt;");
                    continue;
                }
                stringBuffer.append((char)n);
            }
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        jspLineMap.clear();
        return stringBuffer.toString();
    }

    private String findMapping(JspLineMap jspLineMap, int n) {
        for (int i = jspLineMap.size() - 1; i >= 0; --i) {
            JspLineMapItem jspLineMapItem = jspLineMap.get(i);
            if (jspLineMapItem == null || jspLineMapItem.getBeginServletLnr() > n || jspLineMapItem.getEndServletLnr() < n) continue;
            return this.createErrorMsg(jspLineMap, jspLineMapItem);
        }
        return null;
    }

    private String createErrorMsg(JspLineMap jspLineMap, JspLineMapItem jspLineMapItem) {
        StringBuffer stringBuffer = new StringBuffer();
        if (jspLineMapItem.getBeginJspLnr() == jspLineMapItem.getEndJspLnr()) {
            stringBuffer.append(Constants.getString("jsp.error.single.line.number", new Object[]{new Integer(jspLineMapItem.getBeginJspLnr()), jspLineMap.getFileName(jspLineMapItem.getStartJspFileNr())}));
        } else {
            stringBuffer.append(Constants.getString("jsp.error.multiple.line.number", new Object[]{new Integer(jspLineMapItem.getBeginJspLnr()), new Integer(jspLineMapItem.getEndJspLnr()), jspLineMap.getFileName(jspLineMapItem.getStartJspFileNr())}));
        }
        stringBuffer.append(Constants.getString("jsp.error.corresponding.servlet"));
        return stringBuffer.toString();
    }

    public boolean isOutDated() {
        return true;
    }

    public boolean isOutDated(long l) {
        return this.isOutDated();
    }

    public boolean getJspFileExists() {
        return this.jspFileExists;
    }

    public void setJavaCompiler(JavaCompiler javaCompiler) {
        this.javac = javaCompiler;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
    }

    public String changeEncodingIfNecessary(JspReader jspReader) throws ParseException {
        while (jspReader.skipUntil("<%@") != null) {
            jspReader.skipSpaces();
            if (!jspReader.matches("page")) continue;
            jspReader.advance(4);
            jspReader.skipSpaces();
            try {
                int n;
                Attributes attributes = jspReader.parseTagAttributes();
                String string = attributes.getValue("contentType");
                if (string == null || (n = string.indexOf("charset=")) <= 0) continue;
                String string2 = string.substring(n + 8);
                return string2;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public void removeGeneratedFiles() {
        try {
            String string = this.mangler.getClassFileName();
            if (string != null) {
                File file = new File(string);
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

