/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.logging.Logger;

public class JspCompiler
extends Compiler
implements Mangler {
    String javaFileName;
    String classFileName;
    String realClassName;
    protected String jsp;
    String outputDir;
    protected boolean outDated;
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "JspCompiler");

    public JspCompiler(JspCompilationContext jspCompilationContext) throws JasperException {
        super(jspCompilationContext);
        this.jsp = jspCompilationContext.getJspFile();
        this.outputDir = jspCompilationContext.getOutputDir();
        this.outDated = false;
        this.setMangler(this);
    }

    public final String getClassName() {
        if (this.realClassName == null) {
            this.realClassName = this.getBaseClassName();
        }
        return this.realClassName;
    }

    public final String getJavaFileName() {
        if (this.javaFileName != null) {
            return this.javaFileName;
        }
        this.javaFileName = this.getClassName() + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = !this.outputDir.endsWith(File.separator) ? this.outputDir + File.separatorChar + this.javaFileName : this.outputDir + this.javaFileName;
        }
        return this.javaFileName;
    }

    public final String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        this.classFileName = this.getClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = !this.outputDir.endsWith(File.separator) ? this.outputDir + File.separatorChar + this.classFileName : this.outputDir + this.classFileName;
        }
        return this.classFileName;
    }

    private final String getBaseClassName() {
        int n = this.jsp.lastIndexOf(47) + 1;
        int n2 = this.jsp.length();
        String string = this.jsp.substring(n, n2);
        if (this.jsp.endsWith(".jsp")) {
            string = string.substring(0, string.length() - 4);
        } else if (this.jsp.indexOf(".") > -1) {
            string = string.replace('.', '_');
        }
        StringBuffer stringBuffer = JspCompiler.mangleString(string);
        return "_" + stringBuffer.toString();
    }

    private static final String mangleChar(char c) {
        if (c == File.separatorChar) {
            c = (char)47;
        }
        if (Character.isLetterOrDigit(c)) {
            return "" + c;
        }
        return "_" + Integer.toHexString(c).toUpperCase() + "_";
    }

    public static StringBuffer mangleString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '/') {
                stringBuffer.append(string.substring(i, i + 1));
                continue;
            }
            stringBuffer.append(JspCompiler.mangleChar(string.charAt(i)));
        }
        return stringBuffer;
    }

    public boolean isOutDated() {
        Serializable serializable;
        long l = 0L;
        try {
            serializable = this.ctxt.getResource(this.jsp);
            this.jspFileExists = true;
            if (serializable == null) {
                this.jspFileExists = false;
                return true;
            }
            l = ((URL)serializable).openConnection().getLastModified();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
        serializable = new File(this.getClassFileName());
        this.outDated = ((File)serializable).exists() ? ((File)serializable).lastModified() < l : true;
        return this.outDated;
    }
}

