/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class JspReader {
    protected Mark current = null;
    String master = null;
    Vector sourceFiles = new Vector();
    int currFileId = 0;
    int size = 0;
    private JspCompilationContext context;
    boolean singleFile = false;
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "JspReader");

    public String getFile(int n) {
        return (String)this.sourceFiles.elementAt(n);
    }

    protected int registerSourceFile(String string) {
        if (this.sourceFiles.contains(string)) {
            return -1;
        }
        this.sourceFiles.addElement(string);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    protected int unregisterSourceFile(String string) {
        if (!this.sourceFiles.contains(string)) {
            return -1;
        }
        this.sourceFiles.removeElement(string);
        --this.size;
        return this.sourceFiles.size() - 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushFile2(String string, String string2, InputStreamReader inputStreamReader) throws ParseException, FileNotFoundException {
        String string3 = string;
        int n = this.registerSourceFile(string3);
        if (n == -1) {
            throw new ParseException(Constants.getString("jsp.error.file.already.registered", new Object[]{string}));
        }
        this.currFileId = n;
        try {
            try {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                char[] cArray = new char[1024];
                int n2 = 0;
                while ((n2 = inputStreamReader.read(cArray)) != -1) {
                    charArrayWriter.write(cArray, 0, n2);
                }
                charArrayWriter.close();
                if (this.current == null) {
                    this.current = new Mark(this, charArrayWriter.toCharArray(), n, this.getFile(n), this.master, string2);
                } else {
                    this.current.pushStream(charArrayWriter.toCharArray(), n, this.getFile(n), string3, string2);
                }
            }
            catch (Throwable throwable) {
                this.loghelper.log("Exception parsing file ", throwable);
                this.popFile();
                throw new ParseException(Constants.getString("jsp.error.file.cannot.read", new Object[]{string3 + "  " + throwable.toString()}));
            }
            Object var10_10 = null;
            if (inputStreamReader == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        inputStreamReader.close();
        return;
    }

    public boolean popFile() throws ParseException {
        if (this.current == null) {
            return false;
        }
        if (this.currFileId < 0) {
            throw new ParseException(Constants.getString("jsp.error.no.more.content"));
        }
        String string = this.getFile(this.currFileId);
        this.currFileId = this.unregisterSourceFile(string);
        if (this.currFileId < -1) {
            throw new ParseException(Constants.getString("jsp.error.file.not.registered", new Object[]{string}));
        }
        boolean bl = this.current.popStream();
        if (bl) {
            this.master = this.current.baseDir;
        }
        return bl;
    }

    protected JspReader(JspCompilationContext jspCompilationContext, String string, String string2, InputStreamReader inputStreamReader) throws ParseException, FileNotFoundException {
        this.context = jspCompilationContext;
        this.pushFile2(string, string2, inputStreamReader);
    }

    public boolean hasMoreInput() throws ParseException {
        if (this.current.cursor >= this.current.stream.length) {
            if (this.singleFile) {
                return false;
            }
            while (this.popFile()) {
                if (this.current.cursor >= this.current.stream.length) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public int nextChar() throws ParseException {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char c = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (c == '\n' || c == '\r' && this.hasMoreInput() && this.peekChar() != 10) {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return c;
    }

    String nextContent() throws ParseException {
        char c;
        int n = this.current.cursor;
        int n2 = this.current.stream.length;
        if (this.peekChar() == 10 || this.hasMoreInput() && this.peekChar() == 13 && this.peekNextChar() != 10) {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        while (++this.current.cursor < n2 && (c = this.current.stream[this.current.cursor]) != '<') {
            if (c == '\n' || this.hasMoreInput() && c == '\r' && this.peekNextChar() != 10) {
                ++this.current.line;
                this.current.col = 0;
                continue;
            }
            ++this.current.col;
        }
        return new String(this.current.stream, n, this.current.cursor - n);
    }

    char[] getChars(Mark mark, Mark mark2) throws ParseException {
        Mark mark3 = this.mark();
        this.reset(mark);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        while (!mark2.equals(this.mark())) {
            charArrayWriter.write(this.nextChar());
        }
        charArrayWriter.close();
        this.reset(mark3);
        return charArrayWriter.toCharArray();
    }

    public int peekChar() {
        return this.current.stream[this.current.cursor];
    }

    public int peekNextChar() {
        try {
            return this.current.stream[this.current.cursor + 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 10;
        }
    }

    public Mark mark() {
        return new Mark(this.current);
    }

    public void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    public boolean matchesIgnoreCase(String string) throws ParseException {
        Mark mark = this.mark();
        int n = 0;
        int n2 = 0;
        do {
            if (Character.toLowerCase((char)(n = this.nextChar())) == string.charAt(n2++)) continue;
            this.reset(mark);
            return false;
        } while (n2 < string.length());
        this.reset(mark);
        return true;
    }

    public boolean matches(String string) throws ParseException {
        Mark mark = this.mark();
        int n = 0;
        int n2 = 0;
        do {
            if ((char)(n = this.nextChar()) == string.charAt(n2++)) continue;
            this.reset(mark);
            return false;
        } while (n2 < string.length());
        this.reset(mark);
        return true;
    }

    public void advance(int n) throws ParseException {
        while (--n >= 0) {
            this.nextChar();
        }
    }

    public int skipSpaces() throws ParseException {
        int n = 0;
        while (this.isSpace()) {
            ++n;
            this.nextChar();
        }
        return n;
    }

    public Mark skipUntil(String string) throws ParseException {
        Mark mark = null;
        int n = string.length();
        mark = this.mark();
        int n2 = this.nextChar();
        while (n2 != -1) {
            block4: {
                if (n2 == string.charAt(0)) {
                    Mark mark2 = this.mark();
                    for (int i = 1; i < n; ++i) {
                        if (Character.toLowerCase((char)this.peekChar()) != string.charAt(i)) {
                            this.reset(mark2);
                            break block4;
                        }
                        this.nextChar();
                    }
                    return mark;
                }
            }
            mark = this.mark();
            n2 = this.nextChar();
        }
        return null;
    }

    final boolean isSpace() {
        return this.peekChar() <= 32;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseToken(boolean bl) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        stringBuffer.setLength(0);
        int n = this.peekChar();
        if (bl) {
            if (n != 34 && n != 39) throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.quoted"));
            int n2 = n == 34 ? 34 : 39;
            n = this.nextChar();
            n = this.nextChar();
            while (n != -1 && n != n2) {
                if (n == 92) {
                    n = this.nextChar();
                }
                stringBuffer.append((char)n);
                n = this.nextChar();
            }
            if (n != -1) return stringBuffer.toString();
            throw new ParseException(this.mark(), Constants.getString("jsp.error.quotes.unterminated"));
        }
        if (this.isDelimiter()) return stringBuffer.toString();
        do {
            if ((n = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                n = this.nextChar();
            }
            stringBuffer.append((char)n);
        } while (!this.isDelimiter());
        return stringBuffer.toString();
    }

    private void parseAttributeValue(AttributesImpl attributesImpl) throws ParseException {
        this.skipSpaces();
        String string = this.parseToken(false);
        this.skipSpaces();
        if (this.peekChar() != 61) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.novalue", new Object[]{string}));
        }
        char c = (char)this.nextChar();
        this.skipSpaces();
        String string2 = this.parseToken(true);
        this.skipSpaces();
        attributesImpl.addAttribute("", string, string, "CDATA", string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes parseTagAttributesBean() throws ParseException {
        AttributesImpl attributesImpl = new AttributesImpl();
        while (true) {
            this.skipSpaces();
            int n = this.peekChar();
            if (n == 62) {
                return attributesImpl;
            }
            if (n == 47) {
                Mark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        AttributesImpl attributesImpl2 = attributesImpl;
                        return attributesImpl2;
                    }
                }
                finally {
                    this.reset(mark);
                }
            }
            if (n == -1) break;
            this.parseAttributeValue(attributesImpl);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attributes parseTagAttributes() throws ParseException {
        AttributesImpl attributesImpl = new AttributesImpl();
        while (true) {
            int n;
            block17: {
                Mark mark;
                this.skipSpaces();
                n = this.peekChar();
                if (n == 62) {
                    return attributesImpl;
                }
                if (n == 45) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 45 && this.nextChar() == 62) {
                            AttributesImpl attributesImpl2 = attributesImpl;
                            return attributesImpl2;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (n == 37) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 62) {
                            AttributesImpl attributesImpl3 = attributesImpl;
                            return attributesImpl3;
                        }
                        break block17;
                    }
                    finally {
                        this.reset(mark);
                    }
                }
                if (n == 47) {
                    mark = this.mark();
                    this.nextChar();
                    try {
                        if (this.nextChar() == 62) {
                            AttributesImpl attributesImpl4 = attributesImpl;
                            return attributesImpl4;
                        }
                    }
                    finally {
                        this.reset(mark);
                    }
                }
            }
            if (n == -1) break;
            this.parseAttributeValue(attributesImpl);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    public void parseParamTag(Hashtable hashtable) throws ParseException {
        if (this.matches("param")) {
            this.advance(6);
            this.parseParams(hashtable);
        }
    }

    public void parsePluginParamTag(Hashtable hashtable) throws ParseException {
        if (this.matches("<jsp:param")) {
            this.advance(11);
            this.parseParams(hashtable);
        }
    }

    private void parseParams(Hashtable hashtable) throws ParseException {
        Attributes attributes = this.parseTagAttributes();
        String string = attributes.getValue("name");
        String string2 = attributes.getValue("value");
        if (string == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.noname"));
        }
        if (string2 == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.novalue"));
        }
        String[] stringArray = (String[])hashtable.get(string);
        if (stringArray == null) {
            String[] stringArray2 = new String[]{string2};
            hashtable.put(string, stringArray2);
        } else {
            String[] stringArray3 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            stringArray3[stringArray.length] = string2;
            hashtable.put(string, stringArray3);
        }
    }

    private boolean isDelimiter() throws ParseException {
        if (!this.isSpace()) {
            int n = this.peekChar();
            if (n == 61 || n == 62 || n == 34 || n == 39 || n == 47) {
                return true;
            }
            if (n == 45) {
                Mark mark = this.mark();
                n = this.nextChar();
                if (n == 62 || n == 45 && this.nextChar() == 62) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    public void setSingleFile(boolean bl) {
        this.singleFile = bl;
    }
}

