/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.CoreElement;
import org.apache.jasper.compiler.DelegatingListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.TagLibraries;
import org.xml.sax.Attributes;

public class Parser {
    private JspReader reader;
    private ParseEventListener listener;
    CharArrayWriter caw;
    Mark tmplStart;
    Mark tmplStop;
    String currentFile;
    static final Vector coreElements = new Vector();

    public Parser(JspReader jspReader, ParseEventListener parseEventListener) {
        this.reader = jspReader;
        this.listener = new DelegatingListener(parseEventListener, new Action(){

            public void execute(Mark mark, Mark mark2) throws JasperException {
                Parser.this.flushCharData(mark, mark2);
            }
        });
        this.caw = new CharArrayWriter();
        this.currentFile = jspReader.mark().getFile();
    }

    public Parser(JspCompilationContext jspCompilationContext, String string, String string2, InputStreamReader inputStreamReader, ParseEventListener parseEventListener) throws ParseException, FileNotFoundException {
        this.reader = new JspReader(jspCompilationContext, string, string2, inputStreamReader);
        parseEventListener.setReader(this.reader);
        this.listener = new DelegatingListener(parseEventListener, new Action(){

            public void execute(Mark mark, Mark mark2) throws JasperException {
                Parser.this.flushCharData(mark, mark2);
            }
        });
        this.caw = new CharArrayWriter();
        this.currentFile = this.reader.mark().getFile();
    }

    void flushCharData(Mark mark, Mark mark2) throws JasperException {
        char[] cArray = this.caw.toCharArray();
        if (cArray.length != 0) {
            this.listener.handleJspCdata(mark, mark2, this.caw.toCharArray());
        }
        this.caw = new CharArrayWriter();
    }

    public void parse() throws JasperException {
        this.parse(null);
    }

    public void parse(String string) throws JasperException {
        this.parse(string, null);
    }

    public void parse(String string, Class[] classArray) throws JasperException {
        boolean bl = false;
        while (this.reader.hasMoreInput()) {
            Object object;
            if (this.tmplStart == null) {
                this.tmplStart = this.reader.mark();
            }
            if (this.tmplStop == null) {
                this.tmplStop = this.reader.mark();
            }
            if (string != null && this.reader.matches(string)) {
                return;
            }
            if (!this.reader.mark().getFile().equals(this.currentFile)) {
                this.flushCharData(this.tmplStart, this.tmplStop);
                this.currentFile = this.reader.mark().getFile();
                this.tmplStart = this.reader.mark();
            }
            Enumeration enumeration = coreElements.elements();
            if (classArray != null) {
                Vector<Object> vector = new Vector<Object>();
                while (enumeration.hasMoreElements()) {
                    object = (CoreElement)enumeration.nextElement();
                    for (int i = 0; i < classArray.length; ++i) {
                        if (!object.getClass().equals(classArray[i])) continue;
                        vector.addElement(object);
                    }
                }
                enumeration = vector.elements();
            }
            boolean bl2 = false;
            while (enumeration.hasMoreElements()) {
                object = (CoreElement)enumeration.nextElement();
                Mark mark = this.reader.mark();
                if (!object.accept(this.listener, this.reader, this)) continue;
                Constants.message("jsp.message.accepted", new Object[]{object.getClass().getName(), mark}, 4);
                bl2 = true;
                bl = false;
                break;
            }
            if (bl2) continue;
            if (!bl) {
                this.tmplStart = this.reader.mark();
                bl = true;
            }
            object = this.reader.nextContent();
            this.tmplStop = this.reader.mark();
            this.caw.write((String)object, 0, ((String)object).length());
        }
        this.flushCharData(this.tmplStart, this.tmplStop);
    }

    static {
        coreElements.addElement(new Directive());
        coreElements.addElement(new Include());
        coreElements.addElement(new Forward());
        coreElements.addElement(new Comment());
        coreElements.addElement(new Declaration());
        coreElements.addElement(new Expression());
        coreElements.addElement(new Scriptlet());
        coreElements.addElement(new Bean());
        coreElements.addElement(new GetProperty());
        coreElements.addElement(new SetProperty());
        coreElements.addElement(new Tag());
        coreElements.addElement(new Plugin());
        coreElements.addElement(new QuoteEscape());
    }

    static final class QuoteEscape
    implements CoreElement {
        private static String QUOTED_START_TAG = "<\\%";
        private static String QUOTED_END_TAG = "%\\>";
        private static String START_TAG = "<%";
        private static String END_TAG = "%>";
        private static final String APOS = "&apos;";
        private static final String QUOTE = "&quote;";

        QuoteEscape() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            try {
                Mark mark = jspReader.mark();
                if (jspReader.matches(QUOTED_START_TAG)) {
                    jspReader.advance(QUOTED_START_TAG.length());
                    Mark mark2 = jspReader.mark();
                    parser.caw.write(START_TAG);
                    parser.flushCharData(mark, mark2);
                    return true;
                }
                if (jspReader.matches(APOS)) {
                    jspReader.advance(APOS.length());
                    Mark mark3 = jspReader.mark();
                    parser.caw.write("'");
                    parser.flushCharData(mark, mark3);
                    return true;
                }
                if (jspReader.matches(QUOTE)) {
                    jspReader.advance(QUOTE.length());
                    Mark mark4 = jspReader.mark();
                    parser.caw.write("\"");
                    parser.flushCharData(mark, mark4);
                    return true;
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            return false;
        }
    }

    static final class Plugin
    implements CoreElement {
        private static final String OPEN_PLUGIN = "<jsp:plugin";
        private static final String END_OPEN_PLUGIN = ">";
        private static final String CLOSE_PLUGIN = "</jsp:plugin>";
        private static final String OPEN_PARAMS = "<jsp:params>";
        private static final String CLOSE_PARAMS = "</jsp:params>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param ";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final String OPEN_FALLBACK = "<jsp:fallback>";
        private static final String CLOSE_FALLBACK = "</jsp:fallback>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height"), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width"), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};

        Plugin() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_PLUGIN)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_PLUGIN.length());
                Attributes attributes = jspReader.parseTagAttributes();
                jspReader.skipSpaces();
                if (!jspReader.matches(END_OPEN_PLUGIN)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.plugin.notclosed"));
                }
                jspReader.advance(END_OPEN_PLUGIN.length());
                jspReader.skipSpaces();
                Hashtable hashtable = null;
                String string = null;
                JspUtil.checkAttributes("plugin", attributes, validAttributes, mark);
                if (jspReader.matches(OPEN_PARAMS)) {
                    hashtable = new Hashtable();
                    boolean bl = false;
                    jspReader.advance(OPEN_PARAMS.length());
                    while (jspReader.hasMoreInput()) {
                        jspReader.skipSpaces();
                        if (jspReader.matches(CLOSE_PARAMS)) {
                            bl = true;
                            jspReader.advance(CLOSE_PARAMS.length());
                            break;
                        }
                        if (!jspReader.matches(OPEN_INDIVIDUAL_PARAM)) {
                            throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.paramexpected"));
                        }
                        jspReader.parsePluginParamTag(hashtable);
                        jspReader.skipSpaces();
                        if (!jspReader.matches(CLOSE_INDIVIDUAL_PARAM)) {
                            throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.closeindividualparam"));
                        }
                        jspReader.advance(CLOSE_INDIVIDUAL_PARAM.length());
                    }
                    if (!bl) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.closeparams"));
                    }
                    jspReader.skipSpaces();
                }
                if (jspReader.matches(OPEN_FALLBACK)) {
                    jspReader.advance(OPEN_FALLBACK.length());
                    jspReader.skipSpaces();
                    Mark mark2 = jspReader.mark();
                    Mark mark3 = jspReader.skipUntil(CLOSE_FALLBACK);
                    string = new String(jspReader.getChars(mark2, mark3));
                    jspReader.skipSpaces();
                }
                if (!jspReader.matches(CLOSE_PLUGIN)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_PLUGIN}));
                }
                jspReader.advance(CLOSE_PLUGIN.length());
                Mark mark4 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handlePlugin(mark, mark4, attributes, hashtable, string);
                return true;
            }
            return false;
        }
    }

    static final class Tag
    implements CoreElement {
        private static final String CLOSE_1 = "/>";
        private static final String CLOSE = ">";

        Tag() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            TagLibraries tagLibraries;
            if (jspReader.peekChar() != 60) {
                return false;
            }
            Mark mark = jspReader.mark();
            jspReader.nextChar();
            String string = jspReader.parseToken(false);
            int n = string.indexOf(58);
            if (n == -1) {
                jspReader.reset(mark);
                return false;
            }
            String string2 = string.substring(0, n);
            String string3 = "";
            if (++n < string.length()) {
                string3 = string.substring(n);
            }
            if (!(tagLibraries = parseEventListener.getTagLibraries()).isUserDefinedTag(string2, string3, mark)) {
                jspReader.reset(mark);
                return false;
            }
            if (string3 == null) {
                throw new ParseException(mark, "Nothing after the :");
            }
            TagLibraryInfo tagLibraryInfo = tagLibraries.getTagLibInfo(string2);
            TagInfo tagInfo = tagLibraryInfo.getTag(string3);
            if (tagInfo == null) {
                throw new ParseException(mark, "Unable to locate TagInfo for " + string);
            }
            String string4 = tagInfo.getBodyContent();
            Attributes attributes = jspReader.parseTagAttributes();
            jspReader.skipSpaces();
            Mark mark2 = null;
            Mark mark3 = null;
            boolean bl = false;
            if (jspReader.matches(CLOSE_1)) {
                jspReader.advance(CLOSE_1.length());
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleTagBegin(mark, jspReader.mark(), attributes, string2, string3, tagLibraryInfo, tagInfo, false);
                parseEventListener.handleTagEnd(mark, jspReader.mark(), string2, string3, attributes, tagLibraryInfo, tagInfo, false);
                return true;
            }
            if (!jspReader.matches(CLOSE)) throw new ParseException(mark, "Unterminated user-defined tag");
            jspReader.advance(CLOSE.length());
            mark2 = jspReader.mark();
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            String string5 = "</" + string + CLOSE;
            mark3 = jspReader.skipUntil(string5.toLowerCase());
            if (mark3 != null) {
                String string6 = new String(jspReader.getChars(mark2, mark3));
                boolean bl2 = bl = string6.length() > 0;
                if (bl && string4.equalsIgnoreCase("EMPTY")) {
                    throw new ParseException(mark, "Body is supposed to be empty for " + string);
                }
            }
            jspReader.reset(mark2);
            parseEventListener.handleTagBegin(mark, mark2, attributes, string2, string3, tagLibraryInfo, tagInfo, bl);
            if (!string4.equalsIgnoreCase("TAGDEPENDENT") && !string4.equalsIgnoreCase("EMPTY") && !string4.equalsIgnoreCase("JSP")) throw new ParseException(mark, "Internal Error: Invalid BODY_CONTENT type");
            if (string4.equalsIgnoreCase("TAGDEPENDENT")) {
                parser.parse(string5, new Class[0]);
            } else {
                parser.parse(string5);
            }
            try {
                jspReader.advance(string5.length());
            }
            catch (ParseException parseException) {
                throw new ParseException(mark, Constants.getString("jsp.error.unterminated.user.tag", new Object[]{JspUtil.escapeXml(string5)}));
            }
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleTagEnd(parser.tmplStop, jspReader.mark(), string2, string3, attributes, tagLibraryInfo, tagInfo, bl);
            return true;
        }
    }

    static final class SetProperty
    implements CoreElement {
        private static final String OPEN_SETPROPERTY = "<jsp:setProperty";
        private static final String CLOSE_SETPROPERTY = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value"), new JspUtil.ValidAttribute("param")};

        SetProperty() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_SETPROPERTY)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_SETPROPERTY.length());
                Attributes attributes = jspReader.parseTagAttributes();
                JspUtil.checkAttributes("setProperty", attributes, validAttributes, mark);
                jspReader.skipSpaces();
                if (!jspReader.matches(CLOSE_SETPROPERTY)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_SETPROPERTY}));
                }
                jspReader.advance(CLOSE_SETPROPERTY.length());
                Mark mark2 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleSetProperty(mark, mark2, attributes);
                return true;
            }
            return false;
        }
    }

    static final class GetProperty
    implements CoreElement {
        private static final String OPEN_GETPROPERTY = "<jsp:getProperty";
        private static final String CLOSE_GETPROPERTY = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};

        GetProperty() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_GETPROPERTY)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_GETPROPERTY.length());
                Attributes attributes = jspReader.parseTagAttributes();
                JspUtil.checkAttributes("getProperty", attributes, validAttributes, mark);
                jspReader.skipSpaces();
                if (!jspReader.matches(CLOSE_GETPROPERTY)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_GETPROPERTY}));
                }
                jspReader.advance(CLOSE_GETPROPERTY.length());
                Mark mark2 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleGetProperty(mark, mark2, attributes);
                return true;
            }
            return false;
        }
    }

    static final class Bean
    implements CoreElement {
        private static final String OPEN_BEAN = "<jsp:useBean";
        private static final String CLOSE_BEAN = "/>";
        private static final String CLOSE_BEAN_2 = "</jsp:useBean>";
        private static final String CLOSE_BEAN_3 = ">";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id"), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName")};

        Bean() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_BEAN)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_BEAN.length());
                Attributes attributes = jspReader.parseTagAttributesBean();
                JspUtil.checkAttributes("useBean", attributes, validAttributes, mark);
                jspReader.skipSpaces();
                if (!jspReader.matches(CLOSE_BEAN)) {
                    if (!jspReader.matches(CLOSE_BEAN_3)) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{"useBean"}));
                    }
                    jspReader.advance(CLOSE_BEAN_3.length());
                    Mark mark2 = jspReader.mark();
                    parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                    parseEventListener.handleBean(mark, mark2, attributes);
                    int n = jspReader.size;
                    parser.parse(CLOSE_BEAN_2);
                    if (n != jspReader.size) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.usebean.notinsamefile"));
                    }
                    if (!jspReader.matches(CLOSE_BEAN_2)) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_BEAN}));
                    }
                    jspReader.advance(CLOSE_BEAN_2.length());
                    parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                    parseEventListener.handleBeanEnd(mark, mark2, attributes);
                    return true;
                }
                jspReader.advance(CLOSE_BEAN.length());
                Mark mark3 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleBean(mark, mark3, attributes);
                parseEventListener.handleBeanEnd(mark, mark3, attributes);
                return true;
            }
            return false;
        }
    }

    static final class Scriptlet
    implements CoreElement {
        private static final String OPEN_SCRIPTLET = "<%";
        private static final String CLOSE_SCRIPTLET = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Scriptlet() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            Mark mark;
            String string = null;
            Attributes attributes = null;
            if (!jspReader.matches(OPEN_SCRIPTLET)) {
                return false;
            }
            String string2 = OPEN_SCRIPTLET;
            String string3 = CLOSE_SCRIPTLET;
            jspReader.advance(string2.length());
            Mark mark2 = jspReader.mark();
            if (string != null) {
                attributes = jspReader.parseTagAttributes();
                jspReader.skipSpaces();
                if (!jspReader.matches(string)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                jspReader.advance(string.length());
                jspReader.skipSpaces();
                JspUtil.checkAttributes("Scriptlet", attributes, validAttributes, mark2);
            }
            if ((mark = jspReader.skipUntil(string3)) == null) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{string2}));
            }
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleScriptlet(mark2, mark, attributes, jspReader.getChars(mark2, mark));
            return true;
        }
    }

    static final class Expression
    implements CoreElement {
        private static final String OPEN_EXPR = "<%=";
        private static final String CLOSE_EXPR = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Expression() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            Mark mark;
            String string = null;
            Attributes attributes = null;
            if (!jspReader.matches(OPEN_EXPR)) {
                return false;
            }
            String string2 = OPEN_EXPR;
            String string3 = CLOSE_EXPR;
            jspReader.advance(string2.length());
            Mark mark2 = jspReader.mark();
            if (string != null) {
                attributes = jspReader.parseTagAttributes();
                jspReader.skipSpaces();
                if (!jspReader.matches(string)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                jspReader.advance(string.length());
                jspReader.skipSpaces();
                JspUtil.checkAttributes("Expression", attributes, validAttributes, mark2);
            }
            if ((mark = jspReader.skipUntil(string3)) == null) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{string2}));
            }
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleExpression(mark2, mark, attributes, jspReader.getChars(mark2, mark));
            return true;
        }
    }

    static final class Declaration
    implements CoreElement {
        private static final String OPEN_DECL = "<%!";
        private static final String CLOSE_DECL = "%>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[0];

        Declaration() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            Mark mark;
            String string = null;
            Attributes attributes = null;
            if (!jspReader.matches(OPEN_DECL)) {
                return false;
            }
            String string2 = OPEN_DECL;
            String string3 = CLOSE_DECL;
            jspReader.advance(string2.length());
            Mark mark2 = jspReader.mark();
            if (string != null) {
                attributes = jspReader.parseTagAttributes();
                jspReader.skipSpaces();
                if (!jspReader.matches(string)) {
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated"));
                }
                jspReader.advance(string.length());
                jspReader.skipSpaces();
                JspUtil.checkAttributes("Declaration", attributes, validAttributes, mark2);
            }
            if ((mark = jspReader.skipUntil(string3)) == null) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{string2}));
            }
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleDeclaration(mark2, mark, attributes, jspReader.getChars(mark2, mark));
            return true;
        }
    }

    static final class Comment
    implements CoreElement {
        private static final String OPEN_COMMENT = "<%--";
        private static final String CLOSE_COMMENT = "--%>";

        Comment() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_COMMENT)) {
                jspReader.advance(OPEN_COMMENT.length());
                Mark mark = jspReader.mark();
                Mark mark2 = jspReader.skipUntil(CLOSE_COMMENT);
                if (mark2 == null) {
                    throw new ParseException(Constants.getString("jsp.error.unterminated", new Object[]{OPEN_COMMENT}));
                }
                parser.flushCharData(parser.tmplStart, parser.tmplStop);
                return true;
            }
            return false;
        }
    }

    static final class Forward
    implements CoreElement {
        private static final String OPEN_FORWARD = "<jsp:forward";
        private static final String CLOSE_FORWARD_NO_BODY = "/>";
        private static final String CLOSE_FORWARD_BODY = ">";
        private static final String CLOSE_FORWARD = "</jsp:forward>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param ";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true)};

        Forward() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_FORWARD)) {
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_FORWARD.length());
                Attributes attributes = jspReader.parseTagAttributes();
                Hashtable hashtable = new Hashtable();
                JspUtil.checkAttributes("Forward", attributes, validAttributes, mark);
                jspReader.skipSpaces();
                if (!jspReader.matches("/>")) {
                    if (!jspReader.matches(CLOSE_FORWARD_BODY)) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_FORWARD}));
                    }
                    jspReader.advance(CLOSE_FORWARD_BODY.length());
                    jspReader.skipSpaces();
                    if (!jspReader.matches(CLOSE_FORWARD)) {
                        jspReader.skipSpaces();
                        if (!jspReader.matches(OPEN_INDIVIDUAL_PARAM)) {
                            throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.paramexpectedonly"));
                        }
                        while (jspReader.matches(OPEN_INDIVIDUAL_PARAM)) {
                            jspReader.parsePluginParamTag(hashtable);
                            jspReader.skipSpaces();
                            if (!jspReader.matches("/>")) {
                                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_INDIVIDUAL_PARAM}));
                            }
                            jspReader.advance("/>".length());
                            jspReader.skipSpaces();
                        }
                    }
                    if (!jspReader.matches(CLOSE_FORWARD)) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_FORWARD}));
                    }
                    jspReader.advance(CLOSE_FORWARD.length());
                } else {
                    jspReader.advance("/>".length());
                }
                Mark mark2 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleForward(mark, mark2, attributes, hashtable);
                return true;
            }
            return false;
        }
    }

    static final class Include
    implements CoreElement {
        private static final String OPEN_INCLUDE = "<jsp:include";
        private static final String CLOSE_INCLUDE_NO_BODY = "/>";
        private static final String CLOSE_INCLUDE_BODY = ">";
        private static final String CLOSE_INCLUDE = "</jsp:include>";
        private static final String OPEN_INDIVIDUAL_PARAM = "<jsp:param ";
        private static final String CLOSE_INDIVIDUAL_PARAM = "/>";
        private static final JspUtil.ValidAttribute[] validAttributes = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true), new JspUtil.ValidAttribute("flush")};

        Include() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            if (jspReader.matches(OPEN_INCLUDE)) {
                Hashtable hashtable = new Hashtable();
                Mark mark = jspReader.mark();
                jspReader.advance(OPEN_INCLUDE.length());
                Attributes attributes = jspReader.parseTagAttributes();
                JspUtil.checkAttributes("Include", attributes, validAttributes, mark);
                jspReader.skipSpaces();
                if (!jspReader.matches("/>")) {
                    if (!jspReader.matches(CLOSE_INCLUDE_BODY)) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_INCLUDE}));
                    }
                    jspReader.advance(CLOSE_INCLUDE_BODY.length());
                    jspReader.skipSpaces();
                    if (!jspReader.matches(CLOSE_INCLUDE)) {
                        jspReader.skipSpaces();
                        if (!jspReader.matches(OPEN_INDIVIDUAL_PARAM)) {
                            throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.paramexpectedonly"));
                        }
                        while (jspReader.matches(OPEN_INDIVIDUAL_PARAM)) {
                            jspReader.parsePluginParamTag(hashtable);
                            jspReader.skipSpaces();
                            if (!jspReader.matches("/>")) {
                                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_INDIVIDUAL_PARAM}));
                            }
                            jspReader.advance("/>".length());
                            jspReader.skipSpaces();
                        }
                    }
                    if (!jspReader.matches(CLOSE_INCLUDE)) {
                        throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{OPEN_INCLUDE}));
                    }
                    jspReader.advance(CLOSE_INCLUDE.length());
                } else {
                    jspReader.advance("/>".length());
                }
                Mark mark2 = jspReader.mark();
                parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
                parseEventListener.handleInclude(mark, mark2, attributes, hashtable);
                return true;
            }
            return false;
        }
    }

    static final class Directive
    implements CoreElement {
        private static final String OPEN_DIRECTIVE = "<%@";
        private static final String CLOSE_DIRECTIVE = "%>";
        static final String[] directives = new String[]{"page", "include", "taglib"};
        private static final JspUtil.ValidAttribute[] pageDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType"), new JspUtil.ValidAttribute("pageEncoding")};
        private static final JspUtil.ValidAttribute[] includeDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] tagDvalidAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri", true), new JspUtil.ValidAttribute("prefix", true)};
        private static final String[] reservedPrefixes = new String[]{"jsp", "jspx", "java", "javax", "servlet", "sun", "sunw"};

        Directive() {
        }

        public boolean accept(ParseEventListener parseEventListener, JspReader jspReader, Parser parser) throws JasperException {
            Object object;
            if (!jspReader.matches(OPEN_DIRECTIVE)) {
                return false;
            }
            String string = OPEN_DIRECTIVE;
            String string2 = CLOSE_DIRECTIVE;
            Mark mark = jspReader.mark();
            jspReader.advance(string.length());
            jspReader.skipSpaces();
            String string3 = null;
            for (int i = 0; i < directives.length; ++i) {
                if (!jspReader.matches(directives[i])) continue;
                string3 = directives[i];
                break;
            }
            if (string3 == null) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.invalid.directive"));
            }
            jspReader.advance(string3.length());
            Attributes attributes = jspReader.parseTagAttributes();
            if (string3.equals("page")) {
                JspUtil.checkAttributes("Page directive", attributes, pageDvalidAttrs, mark);
            } else if (string3.equals("include")) {
                JspUtil.checkAttributes("Include directive", attributes, includeDvalidAttrs, mark);
            } else if (string3.equals("taglib")) {
                JspUtil.checkAttributes("Taglib directive", attributes, tagDvalidAttrs, mark);
                object = attributes.getValue("prefix");
                for (int i = 0; i < reservedPrefixes.length; ++i) {
                    if (!((String)object).equals(reservedPrefixes[i])) continue;
                    throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.taglib.reserved.prefix", new Object[]{object}));
                }
            }
            jspReader.skipSpaces();
            if (!jspReader.matches(string2)) {
                throw new ParseException(jspReader.mark(), Constants.getString("jsp.error.unterminated", new Object[]{string}));
            }
            jspReader.advance(string2.length());
            object = jspReader.mark();
            parseEventListener.setTemplateInfo(parser.tmplStart, parser.tmplStop);
            parseEventListener.handleDirective(string3, mark, (Mark)object, attributes);
            return true;
        }
    }

    public static interface Action {
        public void execute(Mark var1, Mark var2) throws JasperException;
    }
}

