/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.ibm.ws.util.ExtendedDocumentRootUtils;
import com.ibm.ws.webcontainer.srt.SRTRequestUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ConfigurableParseEventListener;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.ParserXJspSax;
import org.xml.sax.Attributes;

public class ParserController {
    private JspCompilationContext ctxt;
    private Stack baseDirStack = new Stack();
    private ParseEventListener jspHandler = null;
    private boolean isXml;
    private static final String JSP_ROOT_TAG = "<jsp:root";
    private boolean isTopFile = true;
    private String topFileEncoding = "ISO-8859-1";
    private String newEncoding;

    public ParserController(JspCompilationContext jspCompilationContext) {
        this.ctxt = jspCompilationContext;
        this.jspHandler = jspCompilationContext.getOptions().getUseConfigurableGenerators() ? new ConfigurableParseEventListener(jspCompilationContext, this) : new JspParseEventListener(jspCompilationContext, this);
    }

    public ParseEventListener getParseEventListener() {
        return this.jspHandler;
    }

    public void parse(String string) throws FileNotFoundException, JasperException {
        this.parse(string, this.ctxt.getExtendedDocumentRootUtils());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String string, ExtendedDocumentRootUtils extendedDocumentRootUtils) throws FileNotFoundException, JasperException {
        String string2 = this.resolveFileName(string);
        String string3 = this.topFileEncoding;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = this.getReader(string2, string3, extendedDocumentRootUtils);
            this.figureOutJspDocument(string2, string3, inputStreamReader);
            if (this.newEncoding != null) {
                string3 = this.newEncoding;
            }
            string3 = SRTRequestUtils.getJvmConverter(string3);
            if (this.isTopFile) {
                this.topFileEncoding = string3;
                this.isTopFile = false;
            }
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inputStreamReader = this.getReader(string2, string3, extendedDocumentRootUtils);
            this.jspHandler.setDefault(this.isXml);
            if (this.isXml) {
                new ParserXJspSax(string2, inputStreamReader, this.jspHandler, string3).parse();
            } else {
                new Parser(this.ctxt, string2, string3, inputStreamReader, this.jspHandler).parse();
            }
            this.baseDirStack.pop();
            Object var8_7 = null;
            if (inputStreamReader == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStreamReader.close();
            return;
        }
        catch (Exception exception) {}
    }

    private void figureOutJspDocument(String string, String string2, InputStreamReader inputStreamReader) throws JasperException {
        JspReader jspReader;
        try {
            jspReader = new JspReader(this.ctxt, string, string2, inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JasperException(fileNotFoundException.toString(), fileNotFoundException);
        }
        jspReader.setSingleFile(true);
        Mark mark = jspReader.mark();
        jspReader.reset(mark);
        Mark mark2 = jspReader.skipUntil(JSP_ROOT_TAG);
        this.isXml = mark2 != null;
        this.newEncoding = null;
        if (!this.isXml) {
            jspReader.reset(mark);
            while (jspReader.skipUntil("<%@") != null) {
                jspReader.skipSpaces();
                if (!jspReader.matches("page")) continue;
                jspReader.advance(4);
                jspReader.skipSpaces();
                Attributes attributes = jspReader.parseTagAttributes();
                String string3 = "pageEncoding";
                this.newEncoding = attributes.getValue("pageEncoding");
                if (this.newEncoding == null) {
                    int n;
                    String string4 = attributes.getValue("contentType");
                    if (string4 == null || (n = string4.indexOf("charset=")) == -1) continue;
                    this.newEncoding = string4.substring(n + 8);
                    return;
                }
                return;
            }
        } else {
            jspReader.reset(mark);
            while (jspReader.skipUntil("<jsp:") != null) {
                jspReader.skipSpaces();
                if (!jspReader.matches("directive.page")) continue;
                jspReader.advance(new String("directive.page").length());
                jspReader.skipSpaces();
                Attributes attributes = jspReader.parseTagAttributes();
                String string5 = "pageEncoding";
                this.newEncoding = attributes.getValue("pageEncoding");
                if (this.newEncoding == null) {
                    int n;
                    String string6 = attributes.getValue("contentType");
                    if (string6 == null || (n = string6.indexOf("charset=")) == -1) continue;
                    this.newEncoding = string6.substring(n + 8);
                    return;
                }
                return;
            }
        }
    }

    private String resolveFileName(String string) {
        String string2 = string.replace('\\', '/');
        boolean bl = string2.startsWith("/");
        string2 = bl ? string2 : (String)this.baseDirStack.peek() + string2;
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
        this.baseDirStack.push(string3);
        return string2;
    }

    private InputStreamReader getReader(String string, String string2) throws FileNotFoundException, JasperException {
        return this.getReader(string, string2, null);
    }

    private InputStreamReader getReader(String string, String string2, ExtendedDocumentRootUtils extendedDocumentRootUtils) throws FileNotFoundException, JasperException {
        try {
            InputStream inputStream = this.ctxt.getResourceAsStream(string);
            if (inputStream == null) {
                if (extendedDocumentRootUtils != null) {
                    try {
                        extendedDocumentRootUtils.handleExtendedDocumentRoots(string.toString());
                        inputStream = extendedDocumentRootUtils.getInputStream();
                    }
                    catch (IOException iOException) {
                        throw new JasperException("Unable to read file [" + string.toString() + "]", iOException);
                    }
                } else {
                    throw new FileNotFoundException(string);
                }
            }
            return new InputStreamReader(inputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JasperException(Constants.getString("jsp.error.unsupported.encoding", new Object[]{string2}));
        }
    }

    private void p(String string) {
        System.out.println("[ParserController] " + string);
    }

    private void p(String string, Throwable throwable) {
        this.p(string);
        this.p(throwable.getMessage());
        throwable.printStackTrace();
    }
}

