/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.TagLibraries;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class ParserXJspSaxHandler
extends DefaultHandler
implements LexicalHandler {
    private ParseEventListener jspHandler;
    private boolean inDtd;
    private boolean inCdata;
    private boolean inEntity;
    private Stack stack;
    private Locator locator;
    private String filePath;
    static final String JSP_PUBLIC_ID1 = "-//Sun Microsystems Inc.//DTD JavaServer Pages Version 1.1//EN";
    static final String JSP_PUBLIC_ID2 = "-//Sun Microsystems Inc.//DTD JavaServer Pages Version 1.2//EN";
    static final String JSP_SYSTEM_ID = "http://java.sun.com/products/jsp/dtd/jspcore_1_2.dtd";
    static final String JSP_SYSTEM_ID_INTERNAL = "/org/apache/jasper/resources/jsp12.dtd";

    public ParserXJspSaxHandler(String string, ParseEventListener parseEventListener) throws JasperException {
        this.filePath = string;
        this.jspHandler = parseEventListener;
        this.stack = new Stack();
        this.inEntity = false;
        this.inDtd = false;
        this.inCdata = false;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Node node = (Node)this.stack.peek();
        node.addText(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3;
        Mark mark = new Mark(this.filePath, this.locator.getLineNumber() - 1, this.locator.getColumnNumber() - 1);
        Node node = new Node(string3, new AttributesImpl(attributes), mark);
        if (string4.equals("jsp:params")) {
            return;
        }
        Node node2 = null;
        if (!this.stack.empty() && (node2 = (Node)this.stack.peek()) instanceof NodeTag) {
            try {
                this.processCustomTagBeginDoIt((NodeTag)node2, true);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        this.stack.push(node);
        try {
            if (node2 != null && node2.isUninterpretedTag() && node2.getText() != null) {
                this.jspHandler.handleCharData(node2.start, mark, node2.getText());
                node2.clearText();
            }
            if (string4.equals("jsp:root")) {
                this.jspHandler.handleRootBegin(node.attrs);
            } else if (string4.equals("jsp:useBean")) {
                this.jspHandler.handleBean(node.start, node.start, node.attrs, true);
            } else if (string4.length() < 4 || !string4.substring(0, 4).equals("jsp:")) {
                int n = string4.indexOf(58);
                boolean bl = false;
                if (n != -1) {
                    String string5 = string4.substring(0, n);
                    String string6 = string4.substring(n + 1);
                    TagLibraries tagLibraries = this.jspHandler.getTagLibraries();
                    if (tagLibraries.isUserDefinedTag(string5, string6, mark)) {
                        bl = true;
                        this.processCustomTagBegin(string5, string6);
                    }
                }
                if (!bl) {
                    node.setUninterpreted(true);
                    this.jspHandler.handleUninterpretedTagBegin(node.start, node.start, node.rawName, node.attrs);
                }
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Mark mark = new Mark(this.filePath, this.locator.getLineNumber() - 1, this.locator.getColumnNumber() - 1);
        String string4 = string3;
        Node node = (Node)this.stack.pop();
        try {
            if (string4.equals("jsp:root")) {
                node.validate(true, false);
                this.jspHandler.handleRootEnd();
            } else if (string4.equals("jsp:text")) {
                node.validate(false, true);
                this.jspHandler.handleJspCdata(node.start, mark, node.getText());
            } else if (string4.equals("jsp:directive.include")) {
                node.validate(true, false);
                this.jspHandler.handleDirective("include", node.start, mark, node.attrs);
            } else if (string4.equals("jsp:directive.page")) {
                node.validate(true, false);
                this.jspHandler.handleDirective("page", node.start, mark, node.attrs);
            } else if (string4.equals("jsp:declaration")) {
                node.validate(false, true);
                this.jspHandler.handleDeclaration(node.start, mark, null, node.getText());
            } else if (string4.equals("jsp:expression")) {
                node.validate(false, true);
                this.jspHandler.handleExpression(node.start, mark, null, node.getText());
            } else if (string4.equals("jsp:scriptlet")) {
                node.validate(false, true);
                this.jspHandler.handleScriptlet(node.start, mark, null, node.getText());
            } else if (string4.equals("jsp:param")) {
                node.validate(true, false);
                this.stack.push(node);
            } else if (string4.equals("jsp:params")) {
                this.stack.push(node);
            } else if (string4.equals("jsp:fallback")) {
                node.validate(false, true);
                this.stack.push(node);
            } else if (string4.equals("jsp:include")) {
                Hashtable hashtable = null;
                if (!node.rawName.equals("jsp:include")) {
                    this.stack.push(node);
                    hashtable = this.popParams();
                    node = (Node)this.stack.pop();
                }
                node.validate(true, false);
                this.jspHandler.handleInclude(node.start, mark, node.attrs, hashtable, true);
            } else if (string4.equals("jsp:forward")) {
                Hashtable hashtable = null;
                if (!node.rawName.equals("jsp:forward")) {
                    this.stack.push(node);
                    hashtable = this.popParams();
                    node = (Node)this.stack.pop();
                }
                node.validate(true, false);
                this.jspHandler.handleForward(node.start, mark, node.attrs, hashtable, true);
            } else if (string4.equals("jsp:useBean")) {
                node.validate(true, false);
                this.jspHandler.handleBeanEnd(node.start, mark, node.attrs);
            } else if (string4.equals("jsp:getProperty")) {
                node.validate(true, false);
                this.jspHandler.handleGetProperty(node.start, mark, node.attrs);
            } else if (string4.equals("jsp:setProperty")) {
                node.validate(true, false);
                this.jspHandler.handleSetProperty(node.start, mark, node.attrs, true);
            } else if (string4.equals("jsp:plugin")) {
                Hashtable hashtable = null;
                String string5 = null;
                if (node.rawName.equals("jsp:fallback")) {
                    string5 = String.valueOf(node.getText());
                    node = (Node)this.stack.pop();
                }
                if (!node.rawName.equals("jsp:plugin")) {
                    this.stack.push(node);
                    hashtable = this.popParams();
                    node = (Node)this.stack.pop();
                }
                node.validate(true, false);
                this.jspHandler.handlePlugin(node.start, mark, node.attrs, hashtable, string5, true);
            } else if (node.isUninterpretedTag()) {
                this.jspHandler.handleUninterpretedTagEnd(mark, mark, string3, node.getText());
            } else {
                node.validate(true, false);
                this.processCustomTagEnd((NodeTag)node, mark);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(exception);
        }
    }

    private void processCustomTagBeginDoIt(NodeTag nodeTag, boolean bl) throws JasperException {
        if (!nodeTag.isBeginDone()) {
            this.jspHandler.handleTagBegin(nodeTag.start, nodeTag.start, nodeTag.attrs, nodeTag.prefix, nodeTag.shortTagName, nodeTag.tli, nodeTag.ti, bl, true);
            nodeTag.setBeginDone(true);
        }
    }

    private void processCustomTagBegin(String string, String string2) throws ParseException, JasperException {
        Node node = (Node)this.stack.pop();
        TagLibraries tagLibraries = this.jspHandler.getTagLibraries();
        if (string2 == null) {
            throw new ParseException(node.start, "Nothing after the :");
        }
        TagLibraryInfo tagLibraryInfo = tagLibraries.getTagLibInfo(string);
        TagInfo tagInfo = tagLibraryInfo.getTag(string2);
        if (tagInfo == null) {
            throw new ParseException(node.start, "Unable to locate TagInfo for " + string + ":" + string2);
        }
        node = new NodeTag(node, string, string2, tagLibraryInfo, tagInfo);
        this.stack.push(node);
    }

    private void processCustomTagEnd(NodeTag nodeTag, Mark mark) throws ParseException, JasperException {
        String string = nodeTag.ti.getBodyContent();
        boolean bl = true;
        if (nodeTag.getText() != null) {
            String string2 = nodeTag.getText().toString();
            bl = string2.trim().length() > 0;
        }
        this.processCustomTagBeginDoIt(nodeTag, bl);
        if (nodeTag.getText() != null && string.equalsIgnoreCase("EMPTY")) {
            throw new ParseException(nodeTag.start, "Body is supposed to be empty for " + nodeTag.rawName);
        }
        this.jspHandler.handleTagEnd(nodeTag.start, mark, nodeTag.prefix, nodeTag.shortTagName, nodeTag.attrs, nodeTag.tli, nodeTag.ti, bl);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
        this.inDtd = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.inCdata = true;
    }

    public void endCDATA() throws SAXException {
        this.inCdata = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printException("FATAL", sAXParseException);
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printException("ERROR", sAXParseException);
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printException("WARNING", sAXParseException);
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (string.equals(JSP_PUBLIC_ID1) || string.equals(JSP_PUBLIC_ID2)) {
            InputStream inputStream = this.getClass().getResourceAsStream(JSP_SYSTEM_ID_INTERNAL);
            InputSource inputSource = new InputSource(inputStream);
            return inputSource;
        }
        System.out.println("ERROR: publicID does not match: " + string);
        return null;
    }

    private String rtrim(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        char[] cArray = string.toCharArray();
        for (n = string.length(); n2 < n && cArray[n3 + n - 1] <= ' '; --n) {
        }
        return n2 > 0 || n < string.length() ? string.substring(n2, n) : string;
    }

    private String ltrim(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = string.toCharArray();
        for (n = 0; n < n2 && cArray[n3 + n] <= ' '; ++n) {
        }
        return n > 0 || n2 < string.length() ? string.substring(n, n2) : string;
    }

    private void printException(String string, SAXParseException sAXParseException) {
        this.p("\n*** SAXParseException: " + string);
        this.p("Public ID: " + sAXParseException.getPublicId());
        this.p("System ID: " + sAXParseException.getSystemId());
        this.p("line " + sAXParseException.getLineNumber() + ", col " + sAXParseException.getColumnNumber());
        sAXParseException.printStackTrace(System.out);
    }

    private char[] makeCharArray(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        int n3 = 0;
        int n4 = n;
        while (n3 < n2) {
            cArray2[n3] = cArray[n4];
            ++n3;
            ++n4;
        }
        return cArray2;
    }

    private Hashtable popParams() throws ParseException {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        while (true) {
            String[] stringArray;
            Node node = (Node)this.stack.peek();
            if (!node.rawName.equals("jsp:param")) break;
            node = (Node)this.stack.pop();
            String string = node.attrs.getValue("name");
            String string2 = node.attrs.getValue("value");
            if (string == null) {
                throw new ParseException(node.start, Constants.getString("jsp.error.param.noname"));
            }
            if (string2 == null) {
                throw new ParseException(node.start, Constants.getString("jsp.error.param.novalue"));
            }
            String[] stringArray2 = (String[])hashtable.get(string);
            if (stringArray2 == null) {
                stringArray = new String[]{string2};
                hashtable.put(string, stringArray);
                continue;
            }
            stringArray = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray[stringArray2.length] = string2;
            hashtable.put(string, stringArray);
        }
        return hashtable;
    }

    private void printLocation() {
        this.p("--- (" + this.locator.getSystemId() + ", " + this.locator.getPublicId() + ") (" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + ")");
    }

    void p(String string) {
        System.out.println(string);
    }

    void p(Node node) {
        node.display();
    }

    private class NodeTag
    extends Node {
        String prefix;
        String shortTagName;
        TagLibraryInfo tli;
        TagInfo ti;
        boolean beginDone;

        NodeTag(Node node, String string, String string2, TagLibraryInfo tagLibraryInfo, TagInfo tagInfo) {
            super(node);
            this.prefix = string;
            this.shortTagName = string2;
            this.tli = tagLibraryInfo;
            this.ti = tagInfo;
            this.beginDone = false;
        }

        boolean isBeginDone() {
            return this.beginDone;
        }

        void setBeginDone(boolean bl) {
            this.beginDone = bl;
        }
    }

    private class Node {
        String rawName;
        Attributes attrs;
        Mark start;
        boolean isRoot;
        boolean isUninterpretedTag = false;
        StringBuffer text = null;

        Node(Node node) {
            this(node.rawName, node.attrs, node.start);
        }

        Node(String string, Attributes attributes, Mark mark) {
            this.rawName = string;
            this.attrs = attributes;
            this.start = mark;
            this.isRoot = string.equals("jsp:root");
        }

        void addText(char[] cArray, int n, int n2) {
            if (this.text == null) {
                this.text = new StringBuffer();
            }
            this.text.append(cArray, n, n2);
        }

        char[] getText() {
            return this.text == null ? null : this.text.toString().toCharArray();
        }

        void clearText() {
            this.text = null;
        }

        boolean isRoot() {
            return this.isRoot;
        }

        void setUninterpreted(boolean bl) {
            this.isUninterpretedTag = bl;
        }

        boolean isUninterpretedTag() {
            return this.isUninterpretedTag;
        }

        void validate(boolean bl, boolean bl2) throws SAXException {
            String string;
            if (!bl && this.attrs.getLength() != 0) {
                throw new SAXException("VALIDATE ERROR: " + this.rawName + " cannot have attributes.");
            }
            if (!bl2 && this.text != null && (string = this.text.toString().trim()).length() > 0) {
                throw new SAXException(this.start.toString() + "  " + Constants.getString("jspx.error.templateDataNotInJspCdata", new Object[]{this.rawName, JspUtil.escapeXml(string)}));
            }
        }

        public void display() {
            ParserXJspSaxHandler.this.p("NODE: " + this.rawName);
            for (int i = 0; i < this.attrs.getLength(); ++i) {
                ParserXJspSaxHandler.this.p("attrs[" + i + "] " + this.attrs.getQName(i) + " = " + this.attrs.getValue(i));
            }
        }
    }
}

