/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;

public class TagCache {
    String shortTagName;
    Hashtable methodMaps;
    Hashtable propertyEditorMaps;
    BeanInfo tagClassInfo;
    Class tagHandlerClass;

    public TagCache(String string) {
        this.shortTagName = string;
        this.methodMaps = new Hashtable();
        this.propertyEditorMaps = new Hashtable();
    }

    private void addSetterMethod(String string, Method method) {
        this.methodMaps.put(string, method);
    }

    public Method getSetterMethod(String string) {
        return (Method)this.methodMaps.get(string);
    }

    private void addPropertyEditor(String string, Class clazz) {
        this.propertyEditorMaps.put(string, clazz);
    }

    public Class getPropertyEditorClass(String string) {
        return (Class)this.propertyEditorMaps.get(string);
    }

    public void setTagHandlerClass(Class clazz) throws JasperException {
        try {
            this.tagClassInfo = Introspector.getBeanInfo(clazz);
            this.tagHandlerClass = clazz;
            PropertyDescriptor[] propertyDescriptorArray = this.tagClassInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (propertyDescriptorArray[i].getWriteMethod() != null) {
                    this.addSetterMethod(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i].getWriteMethod());
                }
                if (propertyDescriptorArray[i].getPropertyEditorClass() == null) continue;
                this.addPropertyEditor(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i].getPropertyEditorClass());
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new JasperException(Constants.getString("jsp.error.unable.to_introspect", new Object[]{clazz.getName(), introspectionException.getMessage()}));
        }
    }

    public Class getTagHandlerClass() {
        return this.tagHandlerClass;
    }

    public BeanInfo getTagClassInfo() {
        return this.tagClassInfo;
    }
}

