/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.TagCache;

public class TagLibraries {
    private Hashtable tagLibInfos = new Hashtable();
    private Hashtable tagCaches = new Hashtable();
    private ClassLoader cl;

    public TagLibraries(ClassLoader classLoader) {
        this.cl = classLoader;
    }

    public void addTagLibrary(String string, TagLibraryInfo tagLibraryInfo) {
        this.tagLibInfos.put(string, tagLibraryInfo);
    }

    public boolean isUserDefinedTag(String string, String string2) throws JasperException {
        return this.isUserDefinedTag(string, string2, null);
    }

    public boolean isUserDefinedTag(String string, String string2, Mark mark) throws JasperException {
        TagLibraryInfo tagLibraryInfo = (TagLibraryInfo)this.tagLibInfos.get(string);
        if (tagLibraryInfo == null) {
            return false;
        }
        if (tagLibraryInfo.getTag(string2) != null) {
            return true;
        }
        String string3 = "";
        if (mark != null) {
            string3 = mark.toString() + " ";
            throw new JasperException(string3 + Constants.getString("jsp.error.bad_tag", new Object[]{string2, string}));
        }
        throw new JasperException(Constants.getString("jsp.error.bad_tag", new Object[]{string2, string}));
    }

    public TagLibraryInfo getTagLibInfo(String string) {
        return (TagLibraryInfo)this.tagLibInfos.get(string);
    }

    public TagCache getTagCache(String string, String string2) {
        return (TagCache)this.tagCaches.get(new TagID(string, string2));
    }

    public void putTagCache(String string, String string2, TagCache tagCache) {
        this.tagCaches.put(new TagID(string, string2), tagCache);
    }

    public Enumeration getTagLibInfos() {
        return this.tagLibInfos.elements();
    }

    private static class TagID {
        private String prefix;
        private String shortTagName;

        public TagID(String string, String string2) {
            this.prefix = string;
            this.shortTagName = string2;
        }

        public boolean equals(Object object) {
            return this.prefix.equals(((TagID)object).prefix) && this.shortTagName.equals(((TagID)object).shortTagName);
        }

        public int hashCode() {
            return this.prefix.hashCode() + this.shortTagName.hashCode();
        }
    }
}

