/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.parser;

import com.ibm.ws.xml.ParserFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.parser.MyEntityResolver;
import org.apache.jasper.parser.MyErrorHandler;
import org.apache.jasper.parser.TreeNode;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    protected ClassLoader classLoader = null;
    protected ErrorHandler errorHandler = new MyErrorHandler();
    protected EntityResolver entityResolver = new MyEntityResolver();
    protected Mark mark = null;
    private static HashMap classLoaders = new HashMap();

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("usage: java ParserUtils {filename}");
            System.exit(1);
        }
        try {
            ParserUtils parserUtils = new ParserUtils();
            System.out.println("Opening " + stringArray[0]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            System.out.println("Execute the parse");
            TreeNode treeNode = parserUtils.parseXMLDocument(stringArray[0], fileInputStream);
            System.out.println("Dump results");
            System.out.println(treeNode);
        }
        catch (Throwable throwable) {
            System.out.println("Exception: " + throwable.toString());
            throwable.printStackTrace(System.out);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public TreeNode parseXMLDocument(String string, InputStream inputStream) throws JasperException {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = ParserFactory.newDocumentBuilder((boolean)true, (boolean)true);
            document = ParserFactory.parseDocument((DocumentBuilder)documentBuilder, (EntityResolver)this.entityResolver, (ErrorHandler)this.errorHandler, (InputStream)inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string2 = "";
            if (this.mark != null) {
                string2 = this.mark.toString() + ": ";
            }
            throw new JasperException(string2 + Constants.getString("jsp.error.parse.xml", new Object[]{string, parserConfigurationException.getMessage()}));
        }
        catch (SAXParseException sAXParseException) {
            String string3 = "";
            if (this.mark != null) {
                string3 = this.mark.toString() + ": ";
            }
            throw new JasperException(string3 + Constants.getString("jsp.error.parse.xml.line", new Object[]{string, new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getMessage()}));
        }
        catch (SAXException sAXException) {
            String string4 = "";
            if (this.mark != null) {
                string4 = this.mark.toString() + ": ";
            }
            throw new JasperException(string4 + Constants.getString("jsp.error.parse.xml", new Object[]{string, sAXException.getMessage()}));
        }
        catch (IOException iOException) {
            String string5 = "";
            if (this.mark != null) {
                string5 = this.mark.toString() + ": ";
            }
            throw new JasperException(string5 + Constants.getString("jsp.error.parse.xml", new Object[]{string, iOException.toString()}));
        }
        return this.convert(null, document.getDocumentElement());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected TreeNode convert(TreeNode treeNode, Node node) {
        NodeList nodeList;
        int n;
        TreeNode treeNode2 = new TreeNode(node.getNodeName(), treeNode);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                treeNode2.addAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
        if ((nodeList = node.getChildNodes()) != null) {
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Node node3 = nodeList.item(i);
                if (node3 instanceof Comment) continue;
                if (node3 instanceof Text) {
                    object = ((Text)node3).getData();
                    if (object == null || ((String)(object = ((String)object).trim())).length() <= 0) continue;
                    treeNode2.setBody((String)object);
                    continue;
                }
                object = this.convert(treeNode2, node3);
            }
        }
        return treeNode2;
    }

    public static synchronized ParserUtils createParserUtils(ClassLoader classLoader) {
        ParserUtils parserUtils = null;
        parserUtils = new ParserUtils();
        parserUtils.setClassLoader(classLoader);
        return parserUtils;
    }

    public static synchronized ClassLoader createClassLoader(ClassLoader classLoader) throws MalformedURLException {
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoaders.get(classLoader);
        if (uRLClassLoader != null) {
            return uRLClassLoader;
        }
        URL[] uRLArray = new URL[]{new URL("file:///classes/jaxp.jar"), new URL("file:///classes/crimson.jar")};
        uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
        classLoaders.put(classLoader, uRLClassLoader);
        System.out.println("PUF:  createClassLoader:\r\n" + uRLClassLoader);
        uRLArray = uRLClassLoader.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            System.out.println("PUF:    url=" + uRLArray[i]);
        }
        return uRLClassLoader;
    }

    public Mark getMark() {
        return this.mark;
    }

    public void setMark(Mark mark) {
        this.mark = mark;
    }
}

