/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbededServletOptions;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.JspEngineContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.servlet.JasperLoader;
import org.apache.jasper.servlet.ServletEngine;

public class JspServlet
extends HttpServlet {
    Logger.Helper loghelper;
    protected ServletContext context = null;
    protected Hashtable jsps = new Hashtable();
    protected ServletConfig config;
    protected Options options;
    protected URLClassLoader parentClassLoader;
    protected ServletEngine engine;
    protected String serverInfo;
    private PermissionCollection permissionCollection = null;
    private CodeSource codeSource = null;
    static boolean firstTime = true;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string;
        super.init(servletConfig);
        this.config = servletConfig;
        this.context = servletConfig.getServletContext();
        this.serverInfo = this.context.getServerInfo();
        Constants.jasperLog = new DefaultLogger(this.context);
        Constants.jasperLog.setName("JASPER_LOG");
        Constants.jasperLog.setTimestamp("false");
        Constants.jasperLog.setVerbosityLevel(servletConfig.getInitParameter("logVerbosityLevel"));
        this.loghelper = new Logger.Helper("JASPER_LOG", "JspServlet");
        this.options = new EmbededServletOptions(servletConfig, this.context);
        this.parentClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        if (this.parentClassLoader == null) {
            this.parentClassLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        }
        if (this.parentClassLoader != null) {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{this.parentClassLoader.toString()}, 4);
        } else {
            Constants.message("jsp.message.parent_class_loader_is", new Object[]{"<none>"}, 4);
        }
        Policy policy = Policy.getPolicy();
        if (policy != null) {
            try {
                string = this.context.getRealPath("/");
                if (string == null) {
                    string = this.options.getScratchDir().toString();
                }
                URL uRL = new URL("file:" + string);
                this.codeSource = new CodeSource(uRL, null);
                this.permissionCollection = policy.getPermissions(this.codeSource);
                string = string.endsWith(File.separator) ? string + "-" : string + File.separator + "-";
                this.permissionCollection.add(new FilePermission(string, "read"));
                this.permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] uRLArray = this.parentClassLoader.getURLs();
                    String string2 = null;
                    String string3 = null;
                    for (int i = 0; i < uRLArray.length; ++i) {
                        if (string3 == null && uRLArray[i].toString().startsWith("jndi:")) {
                            string3 = uRLArray[i].toString() + "-";
                        }
                        if (string2 != null || !uRLArray[i].toString().startsWith("jar:jndi:")) continue;
                        string2 = uRLArray[i].toString();
                        string2 = string2.substring(0, string2.length() - 2);
                        string2 = string2.substring(0, string2.lastIndexOf(47)) + "/-";
                    }
                    if (string2 != null) {
                        this.permissionCollection.add(new FilePermission(string2, "read"));
                        this.permissionCollection.add(new FilePermission(string2.substring(4), "read"));
                    }
                    if (string3 != null) {
                        this.permissionCollection.add(new FilePermission(string3, "read"));
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (firstTime) {
            firstTime = false;
            if (System.getSecurityManager() != null) {
                string = "org.apache.jasper.";
                try {
                    this.parentClassLoader.loadClass(string + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                    this.parentClassLoader.loadClass(string + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                    this.parentClassLoader.loadClass(string + "runtime.JspRuntimeLibrary");
                    this.parentClassLoader.loadClass(string + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                    this.parentClassLoader.loadClass(string + "runtime.ServletResponseWrapperInclude");
                    ((Object)((Object)this)).getClass().getClassLoader().loadClass(string + "servlet.JspServlet$JspServletWrapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("Jasper JspServlet preload of class failed: " + classNotFoundException.getMessage());
                }
            }
            Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.getScratchDir().toString()}, 3);
            Constants.message("jsp.message.dont.modify.servlets", 3);
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
    }

    private void serviceJspFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable, boolean bl) throws ServletException, IOException {
        boolean bl2 = throwable != null;
        JspServletWrapper jspServletWrapper = (JspServletWrapper)this.jsps.get(string);
        if (jspServletWrapper == null) {
            jspServletWrapper = new JspServletWrapper(string, bl2);
            this.jsps.put(string, jspServletWrapper);
        }
        jspServletWrapper.service(httpServletRequest, httpServletResponse, bl);
    }

    boolean preCompile(HttpServletRequest httpServletRequest) throws ServletException {
        String string;
        String string2 = httpServletRequest.getQueryString();
        if (string2 == null) {
            return false;
        }
        int n = string2.indexOf("jsp_precompile");
        if (n < 0) {
            return false;
        }
        if ((string2 = string2.substring(n + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (string2.startsWith("&")) {
            return true;
        }
        if (!string2.startsWith("=")) {
            return false;
        }
        int n2 = string2.length();
        int n3 = string2.indexOf("&");
        if (n3 > 0) {
            n2 = n3;
        }
        if ((string = string2.substring(1, n2)).equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + string);
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            String string = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
            String string2 = string == null ? httpServletRequest.getServletPath() : string;
            String string3 = (String)httpServletRequest.getAttribute("org.apache.catalina.jsp_file");
            if (string3 != null) {
                string2 = string3;
            }
            boolean bl = this.preCompile(httpServletRequest);
            Logger logger = Constants.jasperLog;
            if (logger != null && logger.matchVerbosityLevel(3)) {
                logger.log("JspEngine --> " + string2);
                logger.log("\t     ServletPath: " + httpServletRequest.getServletPath());
                logger.log("\t        PathInfo: " + httpServletRequest.getPathInfo());
                logger.log("\t        RealPath: " + this.getServletConfig().getServletContext().getRealPath(string2));
                logger.log("\t      RequestURI: " + httpServletRequest.getRequestURI());
                logger.log("\t     QueryString: " + httpServletRequest.getQueryString());
                logger.log("\t  Request Params: ");
                Enumeration enumeration = httpServletRequest.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    logger.log("\t\t " + string4 + " = " + httpServletRequest.getParameter(string4));
                }
            }
            this.serviceJspFile(httpServletRequest, httpServletResponse, string2, null, bl);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new ServletException(throwable);
        }
    }

    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        Enumeration enumeration = this.jsps.elements();
        while (enumeration.hasMoreElements()) {
            ((JspServletWrapper)enumeration.nextElement()).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean loadJSP(String string, String string2, boolean bl, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws JasperException, FileNotFoundException {
        URL[] uRLArray;
        Object object;
        if (this.context.getResourceAsStream(string) == null) {
            throw new FileNotFoundException(string);
        }
        JspServletWrapper jspServletWrapper = (JspServletWrapper)this.jsps.get(string);
        if (jspServletWrapper == null) {
            throw new JasperException("Can't happen - JspServletWrapper=null");
        }
        File file = null;
        try {
            URL uRL = this.options.getScratchDir().toURL();
            object = uRL.toString();
            object = ((String)object).endsWith("/") ? (String)object + string.substring(1, string.lastIndexOf("/") + 1) : (String)object + string.substring(0, string.lastIndexOf("/") + 1);
            uRL = new URL((String)object);
            file = new File(uRL.getFile());
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception exception) {
            throw new JasperException("No output directory: " + exception.getMessage());
        }
        boolean bl2 = jspServletWrapper.servletClass == null;
        object = new JspEngineContext(this.parentClassLoader, string2, this.context, string, file.toString() + File.separator, bl, this.options, httpServletRequest, httpServletResponse);
        boolean bl3 = false;
        Compiler compiler = object.createCompiler();
        try {
            bl3 = compiler.compile();
            if (jspServletWrapper.servletClass == null || compiler.isOutDated()) {
                uRLArray = this;
                // MONITORENTER : this
                if (jspServletWrapper.servletClass == null || compiler.isOutDated()) {
                    bl3 = compiler.compile();
                }
                // MONITOREXIT : uRLArray
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            compiler.removeGeneratedFiles();
            throw fileNotFoundException;
        }
        catch (JasperException jasperException) {
            throw jasperException;
        }
        catch (Exception exception) {
            throw new JasperException(Constants.getString("jsp.error.unable.compile"), exception);
        }
        if (jspServletWrapper.servletClass != null) {
            if (!bl3) return bl3;
        }
        try {
            uRLArray = new URL[1];
            File file2 = new File(this.normalize(object.getOutputDir()));
            uRLArray[0] = file2.toURL();
            jspServletWrapper.loader = new JasperLoader(uRLArray, object.getServletClassName(), this.parentClassLoader, this.permissionCollection, this.codeSource);
            jspServletWrapper.servletClass = jspServletWrapper.loader.loadClass("org.apache.jsp." + object.getServletClassName());
            return bl3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JasperException(Constants.getString("jsp.error.unable.load"), classNotFoundException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new JasperException(Constants.getString("jsp.error.unable.load"), malformedURLException);
        }
    }

    public boolean isOutDated(File file, JspCompilationContext jspCompilationContext, Mangler mangler) {
        File file2 = null;
        file2 = new File(jspCompilationContext.getRealPath(file.getPath()));
        File file3 = new File(mangler.getClassFileName());
        boolean bl = file3.exists() ? file3.lastModified() < file2.lastModified() : true;
        return bl;
    }

    protected String normalize(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }

    class JspServletWrapper {
        Servlet theServlet;
        String jspUri;
        boolean isErrorPage;
        Class servletClass;
        URLClassLoader loader = null;

        JspServletWrapper(String string, boolean bl) {
            this.jspUri = string;
            this.isErrorPage = bl;
            this.theServlet = null;
        }

        private void load() throws JasperException, ServletException {
            try {
                this.destroy();
                this.theServlet = (Servlet)this.servletClass.newInstance();
            }
            catch (Exception exception) {
                throw new JasperException(exception);
            }
            this.theServlet.init(JspServlet.this.config);
        }

        private void loadIfNecessary(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws JasperException, ServletException, FileNotFoundException {
            String string;
            String string2 = (String)JspServlet.this.context.getAttribute("org.apache.catalina.jsp_classpath");
            if (string2 == null || string2.equals("")) {
                string = "according to the init parameter";
                string2 = JspServlet.this.options.getClassPath();
            } else {
                string = "according to the Servlet Engine";
            }
            Constants.message("jsp.message.cp_is", new Object[]{string, string2 == null ? "" : string2}, 3);
            if (JspServlet.this.loadJSP(this.jspUri, string2, this.isErrorPage, httpServletRequest, httpServletResponse) || this.theServlet == null) {
                this.load();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws ServletException, IOException, FileNotFoundException {
            block10: {
                try {
                    this.loadIfNecessary(httpServletRequest, httpServletResponse);
                    if (bl) {
                        return;
                    }
                    if (this.theServlet instanceof SingleThreadModel) {
                        JspServletWrapper jspServletWrapper = this;
                        synchronized (jspServletWrapper) {
                            this.theServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                            break block10;
                        }
                    }
                    this.theServlet.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
                    if (string != null) {
                        throw new ServletException((Throwable)fileNotFoundException);
                    }
                    try {
                        httpServletResponse.sendError(404, fileNotFoundException.getMessage());
                    }
                    catch (IllegalStateException illegalStateException) {
                        Constants.jasperLog.log(Constants.getString("jsp.error.file.not.found", new Object[]{fileNotFoundException.getMessage()}), fileNotFoundException, 1);
                    }
                    return;
                }
            }
        }

        public void destroy() {
            if (this.theServlet != null) {
                this.theServlet.destroy();
            }
        }
    }
}

