/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.LocalTransaction;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;

public final class LocalTranDeployCheck
implements MetaDataListener {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$LocalTransaction$LocalTranDeployCheck == null ? (class$com$ibm$ws$LocalTransaction$LocalTranDeployCheck = LocalTranDeployCheck.class$("com.ibm.ws.LocalTransaction.LocalTranDeployCheck")) : class$com$ibm$ws$LocalTransaction$LocalTranDeployCheck), (String)"Transaction", (String)"com.ibm.ws.LocalTransaction.resources.LocalTranMsgs");
    private boolean activityServiceInstalled;
    static /* synthetic */ Class class$com$ibm$ws$LocalTransaction$LocalTranDeployCheck;

    public LocalTranDeployCheck() {
        block4: {
            this.activityServiceInstalled = false;
            try {
                Object obj = Class.forName("com.ibm.ws.ActivitySession.ActivitySessionComponentImpl").newInstance();
                if (obj != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ActivitySession service installed - don't check associated LocalTran attributes in MetaDataListener");
                    }
                    this.activityServiceInstalled = true;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"ActivitySession service NOT installed - check associated LocalTran attributes in MetaDataListener");
            }
        }
    }

    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("metaDataCreated: " + metaDataEvent));
        }
        if (metaDataEvent.getMetaData() instanceof EJBComponentMetaData) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"EJBComponentMetaData created - examine local tran policies");
            }
            EJBComponentMetaData eJBComponentMetaData = (EJBComponentMetaData)metaDataEvent.getMetaData();
            LocalTranConfigData localTranConfigData = eJBComponentMetaData.getLocalTran();
            int n = eJBComponentMetaData.getActivationPolicy();
            int n2 = eJBComponentMetaData.getEJBTransactionPolicy();
            if (localTranConfigData == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"localTranData from EJBComponentMetaData is null - cannot perform test");
                }
            } else {
                if (!this.activityServiceInstalled && (n == 1 || n == 0 && localTranConfigData.getValueBoundary() == 1)) {
                    String string;
                    String string2;
                    switch (n) {
                        case 0: {
                            string2 = "ONCE";
                            break;
                        }
                        case 1: {
                            string2 = "ACTIVITY_SESSION";
                            break;
                        }
                        case 2: {
                            string2 = "TRANSACTION";
                            break;
                        }
                        default: {
                            string2 = "UNKNOWN";
                        }
                    }
                    switch (localTranConfigData.getValueBoundary()) {
                        case 1: {
                            string = "ACTIVITY_SESSION";
                            break;
                        }
                        case 0: {
                            string = "BEAN_METHOD";
                            break;
                        }
                        default: {
                            string = "UNKNOWN";
                        }
                    }
                    Object[] objectArray = new Object[]{eJBComponentMetaData.getJndiName(), string2, string};
                    Tr.error((TraceComponent)tc, (String)"ERR_DEPLOY", (Object)objectArray);
                    Tr.debug((TraceComponent)tc, (String)"metaDataCreated", (Object)("Failing application install due to unsafe LocalTransaction attributes:\nactivationPolicy is: " + n + "\nLocalTranBoundary is: " + localTranConfigData.getValueBoundary()));
                    Tr.exit((TraceComponent)tc, (String)"metaDataCreated");
                    throw new RuntimeWarning("Unsafe LocalTransaction attributes set on application");
                }
                if (n2 == 1 && localTranConfigData.getValueResolver() == 1) {
                    Object[] objectArray = new Object[]{eJBComponentMetaData.getJndiName()};
                    Tr.error((TraceComponent)tc, (String)"ERR_DEPLOY_RESOLUTION", (Object)objectArray);
                    Tr.debug((TraceComponent)tc, (String)"Failing application install due to unsupported LocalTransaction attributes:\ntransactions are bean managed but resolution control is ContainerAtBoundry");
                    Tr.exit((TraceComponent)tc, (String)"metaDataCreated");
                    throw new RuntimeWarning("Unsupported LocalTransaction attributes set on bean");
                }
            }
        }
        Tr.exit((TraceComponent)tc, (String)"metaDataCreated");
    }

    public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

