/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import java.util.ArrayList;
import java.util.Iterator;

public class PartnerLogData {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$Transaction$JTA$PartnerLogData == null ? (class$com$ibm$ws$Transaction$JTA$PartnerLogData = PartnerLogData.class$("com.ibm.ws.Transaction.JTA.PartnerLogData")) : class$com$ibm$ws$Transaction$JTA$PartnerLogData), (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected byte[] _serializedLogData;
    protected Object _logData;
    protected long _recoveryId;
    protected boolean _recovered;
    protected boolean _terminating;
    protected boolean _loggedToDisk;
    protected static ArrayList recoveryTable = new ArrayList();
    protected static RecoveryManager _recmgr = null;
    protected static RecoveryLog _partnerLog = null;
    private static long firstFreeId = 1L;
    private static long maxUsedId = 0L;
    static /* synthetic */ Class class$com$ibm$ws$Transaction$JTA$PartnerLogData;

    public PartnerLogData(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("PartnerLogData: id: " + firstFreeId), (Object)object);
        }
        this._serializedLogData = null;
        this._logData = object;
        this._recoveryId = firstFreeId;
        this._recovered = true;
        this._terminating = false;
        this._loggedToDisk = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PartnerLogData");
        }
    }

    public PartnerLogData(byte[] byArray, Object object, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("PartnerLogData: id: " + l), (Object)object);
        }
        this._serializedLogData = byArray;
        this._logData = object;
        this._recoveryId = l;
        this._recovered = false;
        this._terminating = false;
        this._loggedToDisk = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PartnerLogData");
        }
    }

    public static void initialize(RecoveryManager recoveryManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)recoveryManager);
        }
        _recmgr = recoveryManager;
        if (recoveryManager != null) {
            _partnerLog = recoveryManager.getPartnerLog();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public static synchronized PartnerLogData getPartnerEntry(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPartnerEntry: index = " + n));
        }
        PartnerLogData partnerLogData = null;
        try {
            partnerLogData = (PartnerLogData)recoveryTable.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPartnerEntry");
        }
        return partnerLogData;
    }

    public static synchronized int addPartnerEntry(PartnerLogData partnerLogData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addPartnerEntry", (Object)partnerLogData);
        }
        int n = recoveryTable.size();
        recoveryTable.add(partnerLogData);
        if (partnerLogData._recoveryId > maxUsedId) {
            maxUsedId = partnerLogData._recoveryId;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addPartnerEntry: " + n));
        }
        return n;
    }

    public static synchronized Iterator getIterator() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIterator");
        }
        if (maxUsedId > (long)recoveryTable.size()) {
            boolean bl = false;
            while (firstFreeId < maxUsedId) {
                Iterator iterator = recoveryTable.iterator();
                while (iterator.hasNext()) {
                    if (((PartnerLogData)iterator.next())._recoveryId != firstFreeId) continue;
                    ++firstFreeId;
                    bl = true;
                    break;
                }
                if (!bl) break;
                bl = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Table not yet full - firstFreeId->" + firstFreeId + " maxUsedId->" + maxUsedId));
            }
        } else {
            firstFreeId = maxUsedId + 1L;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Table full - firstFreeId->" + firstFreeId));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("numResourcesToIterate: " + recoveryTable.size()));
        }
        Iterator iterator = recoveryTable.iterator();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIterator");
        }
        return iterator;
    }

    public static synchronized PartnerLogData findPartnerEntry(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findPartnerEntry: " + l));
        }
        PartnerLogData partnerLogData = null;
        boolean bl = false;
        Iterator iterator = recoveryTable.iterator();
        while (iterator.hasNext()) {
            partnerLogData = (PartnerLogData)iterator.next();
            if (l != partnerLogData._recoveryId) continue;
            bl = true;
            break;
        }
        if (!bl) {
            partnerLogData = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findPartnerEntry", (Object)partnerLogData);
        }
        return partnerLogData;
    }

    protected static void logData(long l, int n, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("logData: " + l));
        }
        if (_partnerLog != null) {
            RecoverableUnit recoverableUnit = null;
            try {
                recoverableUnit = _partnerLog.createRecoverableUnit(l);
                RecoverableUnitSection recoverableUnitSection = recoverableUnit.createSection(n, true);
                recoverableUnitSection.addData(byArray);
                recoverableUnit.forceSections();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.PartnerLogData.logData", (String)"285");
                try {
                    if (recoverableUnit != null) {
                        _partnerLog.removeRecoverableUnit(recoverableUnit.identity());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (exception instanceof WriteOperationFailedException) {
                    Tr.error((TraceComponent)tc, (String)"WTRN0066_LOG_WRITE_ERROR", (Object)exception);
                } else {
                    Tr.error((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"logData", "com.ibm.ws.Transaction.JTA.PartnerLogData", exception});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"logdata");
                }
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logData");
        }
    }

    public static void preShutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preShutdown");
        }
        PartnerLogData partnerLogData = null;
        Iterator iterator = recoveryTable.iterator();
        while (iterator.hasNext()) {
            partnerLogData = (PartnerLogData)iterator.next();
            partnerLogData.terminate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preShutdown");
        }
    }

    public static int shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown");
        }
        PartnerLogData partnerLogData = null;
        int n = 0;
        byte[] byArray = new byte[]{};
        Iterator iterator = recoveryTable.iterator();
        while (iterator.hasNext()) {
            partnerLogData = (PartnerLogData)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processing: ", (Object)partnerLogData);
            }
            if (partnerLogData._recovered) {
                if (!partnerLogData._loggedToDisk || _partnerLog == null) continue;
                try {
                    _partnerLog.removeRecoverableUnit(partnerLogData._recoveryId);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.PartnerLogData.shutdown", (String)"640");
                    Tr.error((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object)new Object[]{"shutdown", "com.ibm.ws.Transaction.JTA.PartnerLogData", exception});
                    Tr.event((TraceComponent)tc, (String)"XAResources log - removeRecoverableUnit failed: {0}", (Object)exception);
                    ++n;
                }
                continue;
            }
            if (!partnerLogData._loggedToDisk) {
                Tr.warning((TraceComponent)tc, (String)"WTRN0039_SERIALIZE_FAILED");
                continue;
            }
            ++n;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("shutdown: " + n));
        }
        return n;
    }

    public byte[] getSerializedLogData() {
        return this._serializedLogData;
    }

    public void setSerializedLogData(byte[] byArray) {
        this._serializedLogData = byArray;
    }

    public Object getLogData() {
        return this._logData;
    }

    public long getRecoveryId() {
        return this._recoveryId;
    }

    private void setRecoveryId(long l) {
        this._recoveryId = l;
    }

    public void setRecovered(boolean bl) {
        this._recovered = bl;
    }

    public boolean getRecovered() {
        return this._recovered;
    }

    public synchronized void terminate() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"terminating: ", (Object)this);
        }
        this._terminating = true;
    }

    public String toString() {
        String string = this._logData == null ? "<null>" : this._logData.toString();
        return this._recoveryId + ", " + string + ", " + this._recovered + ", " + this._terminating + ", " + this._loggedToDisk;
    }

    public boolean equals(Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"equals", (Object)object);
        }
        if (this == object) {
            return true;
        }
        if (object instanceof PartnerLogData) {
            PartnerLogData partnerLogData = (PartnerLogData)object;
            return this._recoveryId == partnerLogData.getRecoveryId() && this._logData.equals(partnerLogData.getLogData());
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

