/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.Transaction.JTA.EventSemaphore;
import com.ibm.ws.Transaction.JTA.JTAXAResourceImpl;
import com.ibm.ws.Transaction.JTA.LocalTIDTable;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.RegisteredResources;
import com.ibm.ws.Transaction.JTA.ResyncThread;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.WSCRecoveryData;
import com.ibm.ws.Transaction.JTA.XARecoveryData;
import com.ibm.ws.Transaction.JTA.XID;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.TxInterceptorHelper;
import com.ibm.ws.Transaction.JTS.WSCoordinator;
import com.ibm.ws.Transaction.JTS.WSCoordinatorImpl;
import com.ibm.ws.Transaction.JTS.WSCoordinatorWrapper;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.transaction.SystemException;

public final class RecoveryManager {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$Transaction$JTA$RecoveryManager == null ? (class$com$ibm$ws$Transaction$JTA$RecoveryManager = RecoveryManager.class$("com.ibm.ws.Transaction.JTA.RecoveryManager")) : class$com$ibm$ws$Transaction$JTA$RecoveryManager), (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private boolean _initialised = false;
    private ResyncThread _resyncThread = null;
    private EventSemaphore recoveryInProgress = new EventSemaphore();
    private RecoveryLog _tranLog;
    private RecoveryLog _xaLog;
    private WSCoordinatorImpl _globalCoordinator;
    private byte[] _ourApplId;
    private int _ourEpoch;
    private String _fqServerName;
    private byte[] _recoveredApplId = null;
    private int _recoveredEpoch = 0;
    private String _recoveredServerName = null;
    private RecoverableUnit _partnerServiceData = null;
    private RecoverableUnitSection _stateSection = null;
    private RecoverableUnitSection _classpathSection = null;
    private RecoverableUnitSection _partnerServerSection = null;
    private RecoverableUnitSection _partnerApplIdSection = null;
    private RecoverableUnitSection _partnerEpochSection = null;
    private RecoverableUnit _tranlogServiceData = null;
    private RecoverableUnitSection _tranlogServerSection = null;
    private RecoverableUnitSection _tranlogApplIdSection = null;
    private RecoverableUnitSection _tranlogEpochSection = null;
    private String _classPath;
    private String _extraPaths;
    public static final int STARTING = 1;
    public static final int STOPPING = 3;
    static final int TRANSACTION_SERVICE_ITEMS = 3;
    static final int PARTNERLOG_SERVICE_ITEMS = 5;
    static final long[] retryIntervals = new long[]{60000L, 60000L, 60000L};
    static final int[] retryIntervalCounts = new int[]{5, 5, 999999};
    static /* synthetic */ Class class$com$ibm$ws$Transaction$JTA$RecoveryManager;

    public RecoveryManager(RecoveryLog recoveryLog, RecoveryLog recoveryLog2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryManager", (Object)new Object[]{recoveryLog, recoveryLog2});
        }
        this._tranLog = recoveryLog;
        this._xaLog = recoveryLog2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryManager");
        }
    }

    public void initialise(byte[] byArray, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialise", (Object)new Object[]{byArray, new Integer(n)});
        }
        if (this._initialised) {
            return;
        }
        this._fqServerName = ServerName.getFullName();
        this._ourApplId = byArray;
        this._ourEpoch = n;
        boolean bl = byArray != null;
        this._classPath = Configuration.getClassLoader().getClassPath();
        if (tc.isDebugEnabled()) {
            RecoveryManager.traceDebugClassPath("Classloader classpath:", this._classPath);
        }
        int n2 = 0;
        TransactionImpl[] transactionImplArray = new TransactionImpl[]{};
        this._globalCoordinator = new WSCoordinatorImpl(this);
        if (bl) {
            TxInterceptorHelper.setWSCoordinator((WSCoordinator)this._globalCoordinator);
        }
        if (this._tranLog != null && this._xaLog != null) {
            try {
                this._tranLog.openLog();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.initialise", (String)"171", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception caught opening transaction recovery log!", (Object)exception);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initialise");
                }
                throw exception;
            }
            try {
                this._xaLog.openLog();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.initialise", (String)"240", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception caught opening XA resources recovery log!", (Object)exception);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"initialise");
                }
                throw exception;
            }
            n2 = this.replayPartnerLog();
            transactionImplArray = this.replayTranLog(bl);
            if (this._recoveredApplId != null) {
                this._ourApplId = this._recoveredApplId;
            }
            if (this._recoveredEpoch >= this._ourEpoch) {
                this._ourEpoch = this._recoveredEpoch + 1;
            }
            if (bl) {
                Configuration.setApplId((byte[])this._ourApplId);
                Configuration.setCurrentEpoch((int)this._ourEpoch);
            }
        }
        if (this._ourApplId != null) {
            this._globalCoordinator.setKey(this._ourApplId);
        }
        if (this._tranLog != null && this._xaLog != null) {
            try {
                this.updateTranLogServiceData();
                this.updatePartnerServiceData();
                this._tranLog.recoveryComplete();
                this._xaLog.recoveryComplete();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.initialise", (String)"287", (Object)this);
                Tr.error((TraceComponent)tc, (String)"WTRN0026_KEYPOINT_EXC_IN_RECOVERY", (Object)exception);
                throw exception;
            }
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"recovery completed");
        }
        this.recoveryInProgress.post();
        if (bl) {
            TranManagerSet.instance().activate();
        }
        if (transactionImplArray.length == 1) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0027_RECOVERING_TXN");
        } else if (transactionImplArray.length > 1) {
            Tr.audit((TraceComponent)tc, (String)"WTRN0028_RECOVERING_TXNS", (Object)new Integer(transactionImplArray.length));
        } else if (n2 == 0) {
            transactionImplArray = null;
        }
        if (transactionImplArray != null) {
            this._resyncThread = new ResyncThread(transactionImplArray, this);
            this._resyncThread.start();
        }
        this._initialised = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    public RecoveryLog getTransactionLog() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTransactionLog");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTransactionLog", (Object)this._tranLog);
        }
        return this._tranLog;
    }

    public RecoveryLog getPartnerLog() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPartnerLog");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPartnerLog", (Object)this._xaLog);
        }
        return this._xaLog;
    }

    private TransactionImpl[] replayTranLog(boolean bl) throws Exception {
        TransactionImpl[] transactionImplArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"replayTranLog");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LogCursor logCursor = this._tranLog.recoverableUnits();
        LogCursor logCursor2 = null;
        int n = 0;
        int n2 = 0;
        try {
            while (logCursor.hasNext()) {
                Object object;
                transactionImplArray = (TransactionImpl[])logCursor.next();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Replaying record " + transactionImplArray.identity() + " from the transaction log"));
                }
                logCursor2 = transactionImplArray.sections();
                boolean bl2 = false;
                block11: while (!bl2 && logCursor2.hasNext()) {
                    object = (RecoverableUnitSection)logCursor2.next();
                    int n3 = object.identity();
                    byte[] byArray = object.lastData();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Replaying section " + n3), (Object)Util.toHexString((byte[])byArray));
                    }
                    switch (n3) {
                        case 255: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Server name data record");
                            }
                            if (this._tranlogServerSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log SERVER_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = transactionImplArray;
                            } else if (this._tranlogServiceData != transactionImplArray) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogServerSection = object;
                            ++n;
                            if (byArray == null || byArray.length == 0) continue block11;
                            String string = Util.toString((byte[])byArray);
                            if (this._recoveredServerName == null) {
                                this._recoveredServerName = string;
                                if (this._fqServerName.equals(this._recoveredServerName)) continue block11;
                                Tr.warning((TraceComponent)tc, (String)"WTRN0020_RECOVERING_TRANSACTIONS", (Object)this._recoveredServerName);
                                continue block11;
                            }
                            if (this._recoveredServerName.equals(string)) continue block11;
                            Tr.error((TraceComponent)tc, (String)"WTRN0024_INCONSISTENT_LOGS");
                            throw new IOException("Inconsistent Transaction and XA Resource recovery logs");
                        }
                        case 253: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Applid data record");
                            }
                            if (this._tranlogApplIdSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log APPLID_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = transactionImplArray;
                            } else if (this._tranlogServiceData != transactionImplArray) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogApplIdSection = object;
                            ++n;
                            if (byArray == null) continue block11;
                            if (this._recoveredApplId == null) {
                                this._recoveredApplId = byArray;
                                continue block11;
                            }
                            if (Util.equal((byte[])this._recoveredApplId, (byte[])byArray)) continue block11;
                            Tr.error((TraceComponent)tc, (String)"WTRN0024_INCONSISTENT_LOGS");
                            throw new IOException("Inconsistent Transaction and XA Resource recovery logs");
                        }
                        case 254: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Epoch data record");
                            }
                            if (this._tranlogEpochSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log EPOCH_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            if (this._tranlogServiceData == null) {
                                this._tranlogServiceData = transactionImplArray;
                            } else if (this._tranlogServiceData != transactionImplArray) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                            }
                            this._tranlogEpochSection = object;
                            ++n;
                            if (byArray == null || byArray.length <= 3) continue block11;
                            int n4 = XID.bytesToInt(byArray);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Recovered epoch: " + n4));
                            }
                            if (n4 <= this._recoveredEpoch) continue block11;
                            this._recoveredEpoch = n4;
                            continue block11;
                        }
                    }
                    bl2 = true;
                }
                logCursor2.close();
                logCursor2 = null;
                if (!bl2) continue;
                object = new TransactionImpl();
                if (((TransactionImpl)object).reconstruct((RecoverableUnit)transactionImplArray, this._tranLog, bl)) {
                    arrayList.add(object);
                    ++n2;
                    continue;
                }
                logCursor.remove();
            }
            if (n2 > 0) {
                if (n != 3) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Recoverable log records found without service data records");
                    }
                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                    throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
                }
            } else if (n != 0 && n != 3) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Only a subset of service data records recovered");
                }
                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._tranLog.logProperties().logName());
                throw new IOException(this._tranLog.logProperties().logName() + " corrupted");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.replayTranLog", (String)"512", (Object)this);
            if (logCursor2 != null) {
                logCursor2.close();
            }
            Tr.error((TraceComponent)tc, (String)"WTRN0025_TRAN_RECOVERY_FAILED", (Object)throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"replayTranLog");
            }
            throw new SystemException(throwable.toString());
        }
        finally {
            logCursor.close();
        }
        transactionImplArray = arrayList.toArray(new TransactionImpl[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"replayTranLog", (Object)transactionImplArray);
        }
        return transactionImplArray;
    }

    public void shutdown(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object)new Boolean(bl));
        }
        if (!this._initialised) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"shutdown");
            }
            return;
        }
        if (!bl && Configuration.isRecoverable()) {
            PartnerLogData.preShutdown();
            TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
            if (transactionImplArray == null || transactionImplArray.length == 0) {
                try {
                    this._tranLog.removeRecoverableUnit(this._tranlogServiceData.identity());
                    this._tranLog.closeLog();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", (String)"359", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                }
            } else {
                try {
                    this._tranlogEpochSection.addData(XID.intToBytes(this._ourEpoch));
                    this._tranlogServiceData.forceSections();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", (String)"608", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception raised forcing tranlog at shutdown", (Object)exception);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"shutdown");
                    }
                    return;
                }
                for (int i = 0; i < transactionImplArray.length; ++i) {
                    TransactionImpl transactionImpl = transactionImplArray[i];
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Transaction " + transactionImpl + " is still active"));
                    }
                    if (transactionImpl.getStatus() == 1) continue;
                    WSCoordinator wSCoordinator = transactionImpl.getSuperiorCoordinator();
                    if (wSCoordinator != null) {
                        int n = WSCRecoveryData.findRecoveryEntry(wSCoordinator);
                        WSCRecoveryData.getRecoveryEntry(n).setRecovered(false);
                    }
                    RegisteredResources registeredResources = transactionImpl.getResources();
                    if (!transactionImpl.isSubordinate() && registeredResources.numRegistered() < 2) continue;
                    ArrayList arrayList = registeredResources.getResourceObjects();
                    for (int j = 0; j < arrayList.size(); ++j) {
                        Object e = arrayList.get(j);
                        if (e instanceof JTAXAResourceImpl) {
                            long l = ((JTAXAResourceImpl)e).getRecoveryId();
                            XARecoveryData.findRecoveryEntry(l).setRecovered(false);
                            continue;
                        }
                        if (!(e instanceof WSCoordinatorWrapper)) continue;
                        wSCoordinator = ((WSCoordinatorWrapper)e).getWSCoordinator();
                        int n = WSCRecoveryData.findRecoveryEntry(wSCoordinator);
                        WSCRecoveryData.getRecoveryEntry(n).setRecovered(false);
                    }
                }
            }
            if (XARecoveryData.shutdown() > 0) {
                block28: {
                    try {
                        this.updateClassPath(3);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", (String)"779", (Object)this);
                        if (!tc.isEventEnabled()) break block28;
                        Tr.event((TraceComponent)tc, (String)"updateClassPath failed at shutdown on XAResources log: ", (Object)exception);
                    }
                }
                try {
                    this._xaLog.closeLog();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", (String)"800", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                }
            } else {
                block29: {
                    try {
                        this._xaLog.removeRecoverableUnit(this._partnerServiceData.identity());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", (String)"793", (Object)this);
                        if (!tc.isEventEnabled()) break block29;
                        Tr.event((TraceComponent)tc, (String)"removeRecoverableUnit failed at shutdown on XAResources log: ", (Object)exception);
                    }
                }
                try {
                    this._xaLog.closeLog();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.shutdown", (String)"824", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"WTRN0029_ERROR_CLOSE_LOG_IN_SHUTDOWN");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown");
        }
    }

    private int replayPartnerLog() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"replayPartnerLog");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        LogCursor logCursor = null;
        LogCursor logCursor2 = null;
        try {
            logCursor = this._xaLog.recoverableUnits();
            while (logCursor.hasNext()) {
                ++n3;
                RecoverableUnit recoverableUnit = (RecoverableUnit)logCursor.next();
                long l = recoverableUnit.identity();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Replaying record " + l + " from the partner log"));
                }
                logCursor2 = recoverableUnit.sections();
                block14: while (logCursor2.hasNext()) {
                    RecoverableUnitSection recoverableUnitSection = (RecoverableUnitSection)logCursor2.next();
                    int n4 = recoverableUnitSection.identity();
                    byte[] byArray = recoverableUnitSection.lastData();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Replaying section " + n4), (Object)Util.toHexString((byte[])byArray));
                    }
                    switch (n4) {
                        case 34: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"XA resources data record");
                            }
                            if (byArray == null) continue block14;
                            XARecoveryData xARecoveryData = new XARecoveryData(byArray, null, l);
                            PartnerLogData.addPartnerEntry(xARecoveryData);
                            ++n;
                            continue block14;
                        }
                        case 35: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"WS coordinator data record");
                            }
                            if (byArray == null) continue block14;
                            try {
                                WSCRecoveryData.replay(l, byArray);
                                continue block14;
                            }
                            catch (Exception exception) {
                                Tr.error((TraceComponent)tc, (String)"WTRN0030_XARESOURCE_RECOVER_FAILURE", (Object)exception);
                                throw exception;
                            }
                        }
                        case 33: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Class path data record");
                            }
                            if (this._classpathSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log CLASSPATH_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._classpathSection = recoverableUnitSection;
                            ++n2;
                            if (byArray == null || byArray.length == 0) continue block14;
                            this._extraPaths = this.filterClassPaths(this._classPath, Util.toString((byte[])byArray));
                            if (this._extraPaths == null || this._extraPaths.equals("")) continue block14;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Extra classpaths: " + this._extraPaths));
                            }
                            this._classPath = this._extraPaths + File.pathSeparator + this._classPath;
                            continue block14;
                        }
                        case 32: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Server state data record");
                            }
                            if (this._stateSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log SERVER_STATE_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._stateSection = recoverableUnitSection;
                            ++n2;
                            int n5 = -1;
                            if (byArray != null && byArray.length > 3) {
                                n5 = XID.bytesToInt(byArray);
                            }
                            if (n5 == 1) {
                                if (!tc.isEventEnabled()) continue block14;
                                Tr.event((TraceComponent)tc, (String)"previous server may have crashed");
                                continue block14;
                            }
                            if (n5 == 3) {
                                if (!tc.isEventEnabled()) continue block14;
                                Tr.event((TraceComponent)tc, (String)"previous server closed down cleanly with transactions still running");
                                continue block14;
                            }
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Invalid log record data in SERVER_STATE_SECTION");
                            }
                            Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                            throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                        }
                        case 255: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Server name data record");
                            }
                            if (this._partnerServerSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log SERVER_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._partnerServerSection = recoverableUnitSection;
                            ++n2;
                            if (byArray == null || byArray.length == 0) continue block14;
                            this._recoveredServerName = Util.toString((byte[])byArray);
                            if (this._fqServerName.equals(this._recoveredServerName)) continue block14;
                            Tr.warning((TraceComponent)tc, (String)"WTRN0020_RECOVERING_TRANSACTIONS", (Object)this._recoveredServerName);
                            continue block14;
                        }
                        case 253: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Applid data record");
                            }
                            if (this._partnerApplIdSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log APPLID_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._partnerApplIdSection = recoverableUnitSection;
                            ++n2;
                            if (byArray == null) continue block14;
                            this._recoveredApplId = byArray;
                            continue block14;
                        }
                        case 254: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Epoch data record");
                            }
                            if (this._partnerEpochSection != null) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log EPOCH_DATA_SECTIONs found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            if (this._partnerServiceData == null) {
                                this._partnerServiceData = recoverableUnit;
                            } else if (this._partnerServiceData != recoverableUnit) {
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Multiple log service data records found");
                                }
                                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                            }
                            this._partnerEpochSection = recoverableUnitSection;
                            ++n2;
                            if (byArray == null || byArray.length <= 3) continue block14;
                            this._recoveredEpoch = XID.bytesToInt(byArray);
                            if (!tc.isDebugEnabled()) continue block14;
                            Tr.debug((TraceComponent)tc, (String)("Recovered epoch: " + this._recoveredEpoch));
                            continue block14;
                        }
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Invalid partner log data records found");
                    }
                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                }
                logCursor2.close();
            }
            logCursor.close();
            if (n3 > 1) {
                if (n2 != 5) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Recoverable log records found without service data records");
                    }
                    Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                    throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
                }
            } else if (n2 != 0 && n2 != 5) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Only a subset of service data records recovered");
                }
                Tr.warning((TraceComponent)tc, (String)"WTRN0019_LOGFILE_CORRUPTED", (Object)this._xaLog.logProperties().logName());
                throw new IOException(this._xaLog.logProperties().logName() + " corrupted");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.replayPartnerLog", (String)"980", (Object)this);
            if (logCursor2 != null) {
                logCursor2.close();
            }
            if (logCursor != null) {
                logCursor.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"replayPartnerLog");
            }
            throw new SystemException(throwable.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("replayPartnerLog " + n));
        }
        return n;
    }

    public void checkClassPath() throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkClassPath");
        }
        String string2 = Configuration.getClassLoader().getClassPath();
        if (tc.isDebugEnabled()) {
            RecoveryManager.traceDebugClassPath("Classloader classpath:", string2);
        }
        if ((string = this.filterClassPaths(this._classPath, string2)) != null && !string.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("New classpaths: " + string));
            }
            this._classPath = string + File.pathSeparator + this._classPath;
            try {
                if (this._xaLog != null) {
                    this.updateClassPath(0);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.checkClassPath", (String)"1059", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"updateClassPath failed at checkClassPath on XAResources log", (Object)exception);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkClassPath");
                }
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkClassPath");
        }
    }

    public static void traceDebugClassPath(String string, String string2) {
        Tr.debug((TraceComponent)tc, (String)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Tr.debug((TraceComponent)tc, (String)("classpath[" + n + "]=" + stringTokenizer.nextToken()));
            ++n;
        }
    }

    private String filterClassPaths(String string, String string2) {
        int n;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filterClassPaths");
        }
        String string3 = null;
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (hashSet.contains(object)) continue;
            hashSet.add((String)object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"current classpath entries from hashset:");
            object = hashSet.iterator();
            n = 0;
            while (object.hasNext()) {
                Tr.debug((TraceComponent)tc, (String)("classpath[" + n + "]=" + (String)object.next()));
                ++n;
            }
            RecoveryManager.traceDebugClassPath("Logged classpath:", string2);
        }
        object = new StringBuffer();
        stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (hashSet.contains(string4)) continue;
            if (n > 0) {
                ((StringBuffer)object).append(File.pathSeparator);
            }
            ((StringBuffer)object).append(string4);
            ++n;
        }
        hashSet.clear();
        if (n > 0) {
            string3 = ((StringBuffer)object).toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("filterClassPaths: " + string3));
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateTranLogServiceData() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateTranLogServiceData");
        }
        try {
            try {
                if (this._tranlogServiceData == null) {
                    this._tranlogServiceData = this._tranLog.createRecoverableUnit(0L);
                    this._tranlogServerSection = this._tranlogServiceData.createSection(255, true);
                    this._tranlogApplIdSection = this._tranlogServiceData.createSection(253, true);
                    this._tranlogEpochSection = this._tranlogServiceData.createSection(254, true);
                    this._tranlogServerSection.addData(Util.byteArray((String)this._fqServerName));
                    this._tranlogApplIdSection.addData(this._ourApplId);
                }
                this._tranlogEpochSection.addData(XID.intToBytes(this._ourEpoch));
                this._tranlogServiceData.forceSections();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.updateTranLogSeviceData", (String)"1130", (Object)this);
                if (!tc.isDebugEnabled()) throw exception;
                Tr.debug((TraceComponent)tc, (String)"Exception raised in updateTranLogServiceData:", (Object)exception);
                throw exception;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"updateTranLogServiceData");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"updateTranLogServiceData");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updatePartnerServiceData() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updatePartnerServiceData");
        }
        try {
            try {
                if (this._partnerServiceData == null) {
                    this._partnerServiceData = this._xaLog.createRecoverableUnit(0L);
                    this._partnerServerSection = this._partnerServiceData.createSection(255, true);
                    this._partnerApplIdSection = this._partnerServiceData.createSection(253, true);
                    this._partnerEpochSection = this._partnerServiceData.createSection(254, true);
                    this._partnerServerSection.addData(Util.byteArray((String)this._fqServerName));
                    this._partnerApplIdSection.addData(this._ourApplId);
                }
                this._partnerEpochSection.addData(XID.intToBytes(this._ourEpoch));
                this.updateClassPath(1);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.updatePartnerSeviceData", (String)"1224", (Object)this);
                if (!tc.isDebugEnabled()) throw exception;
                Tr.debug((TraceComponent)tc, (String)"Exception raised in updatePartnerServiceData:", (Object)exception);
                throw exception;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"updatePartnerServiceData");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"updatePartnerServiceData");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateClassPath(int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateClassPath: " + n));
        }
        try {
            try {
                if (n != 0) {
                    if (this._stateSection == null) {
                        this._stateSection = this._partnerServiceData.createSection(32, true);
                    }
                    this._stateSection.addData(XID.intToBytes(n));
                }
                if (this._classpathSection == null) {
                    this._classpathSection = this._partnerServiceData.createSection(33, true);
                }
                if (tc.isDebugEnabled()) {
                    RecoveryManager.traceDebugClassPath("Saving classpath:", this._classPath);
                }
                byte[] byArray = Util.byteArray((String)this._classPath);
                this._classpathSection.addData(byArray);
                this._partnerServiceData.forceSections();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.updateClassPath", (String)"1260", (Object)this);
                if (!tc.isDebugEnabled()) throw exception;
                Tr.debug((TraceComponent)tc, (String)"Exception raised in updateClassPath on partner log:", (Object)exception);
                throw exception;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"updateClassPath");
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"updateClassPath");
    }

    public void waitForRecovery() {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"waitForRecovery");
            }
            if (this.recoveryInProgress != null) {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"starting to wait for recovery");
                    }
                    this.recoveryInProgress.waitEvent();
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"completed wait for recovery");
                    }
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.Transaction.JTA.RecoveryManager.waitForRecovery", (String)"1242", (Object)this);
                    if (!tc.isEventEnabled()) break block7;
                    Tr.event((TraceComponent)tc, (String)"Wait for resync complete interrupted.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"waitForRecovery");
        }
    }

    void resync(TransactionImpl[] transactionImplArray) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resync");
        }
        ExtClassLoader extClassLoader = Configuration.getClassLoader();
        if (this._extraPaths != null && !this._extraPaths.equals("")) {
            extClassLoader = new ExtClassLoader(this._extraPaths, (ClassLoader)extClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)extClassLoader);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"New Class loader: ", (Object)extClassLoader);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"New Class loader classpath: ", (Object)extClassLoader.getClassPath());
            }
        }
        byte[] byArray = XID.createBqual(this._ourApplId, this._ourEpoch, 0);
        boolean bl = XARecoveryData.recover(byArray, extClassLoader);
        for (n = 0; n < transactionImplArray.length; ++n) {
            try {
                transactionImplArray[n].recover();
                continue;
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (Object)throwable);
            }
        }
        n = 0;
        int n2 = retryIntervalCounts[n];
        while (!bl) {
            if (--n2 == 0) {
                if (n < retryIntervals.length - 1) {
                    ++n;
                }
                n2 = retryIntervalCounts[n];
            }
            try {
                Thread.sleep(retryIntervals[n]);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl = XARecoveryData.recover(byArray, extClassLoader);
        }
        Tr.exit((TraceComponent)tc, (String)"resync");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

