/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import java.util.Hashtable;

public final class TimeoutManager {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$Transaction$JTA$TimeoutManager == null ? (class$com$ibm$ws$Transaction$JTA$TimeoutManager = TimeoutManager.class$("com.ibm.ws.Transaction.JTA.TimeoutManager")) : class$com$ibm$ws$Transaction$JTA$TimeoutManager), (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int CANCEL_TIMEOUT = 0;
    public static final int NO_TIMEOUT = 0;
    public static final int ACTIVE_TIMEOUT = 1;
    public static final int IN_DOUBT_TIMEOUT = 2;
    public static final int REPEAT_TIMEOUT = 3;
    public static final int INACTIVITY_TIMEOUT = 4;
    private static Hashtable pendingTimeouts = new Hashtable();
    private static Hashtable inactivityTimeouts = new Hashtable();
    static /* synthetic */ Class class$com$ibm$ws$Transaction$JTA$TimeoutManager;

    public static void setTimeout(TransactionImpl transactionImpl, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeout", (Object)new Object[]{transactionImpl, new Integer(n), new Integer(n2)});
        }
        if (transactionImpl == null) {
            throw new IllegalArgumentException("setTimeout called with null tran");
        }
        TimeoutInfo timeoutInfo = null;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                timeoutInfo = new TimeoutInfo(transactionImpl, n2, n);
                timeoutInfo = pendingTimeouts.put(transactionImpl, timeoutInfo);
                if (!tc.isDebugEnabled() || timeoutInfo == null || n == 3) break;
                Tr.debug((TraceComponent)tc, (String)("Found existing timeout for transaction: " + timeoutInfo));
                break;
            }
            case 4: {
                if (n2 == 0) {
                    timeoutInfo = (TimeoutInfo)inactivityTimeouts.remove(transactionImpl);
                    if (null != timeoutInfo) {
                        timeoutInfo.cancelAlarm();
                        break;
                    }
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Failed to find existing timeout for transaction: " + transactionImpl));
                    break;
                }
                timeoutInfo = new TimeoutInfo(transactionImpl, n2, n);
                timeoutInfo = inactivityTimeouts.put(transactionImpl, timeoutInfo);
                if (!tc.isDebugEnabled() || timeoutInfo == null) break;
                Tr.debug((TraceComponent)tc, (String)("Found existing inactivity timeout for transaction: " + timeoutInfo));
                break;
            }
            default: {
                timeoutInfo = (TimeoutInfo)pendingTimeouts.remove(transactionImpl);
                if (null != timeoutInfo) {
                    timeoutInfo.cancelAlarm();
                    break;
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("Failed to find existing timeout for transaction: " + transactionImpl));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTimeout");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TimeoutInfo
    implements AlarmListener {
        private TransactionImpl _tran = null;
        private int _duration = 0;
        private long _expireTime = 0L;
        private int _timeoutType = 0;
        private Alarm _alarm = null;

        TimeoutInfo(TransactionImpl transactionImpl, int n, int n2) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"TimeoutInfo", (Object)transactionImpl);
            }
            this._tran = transactionImpl;
            this._duration = n;
            this._timeoutType = n2;
            this._alarm = AlarmManager.create((long)((long)this._duration * 1000L), (AlarmListener)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"TimeoutInfo");
            }
        }

        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"alarm", (Object)this._tran);
            }
            switch (this._timeoutType) {
                case 1: {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction timeout", (Object)this._tran);
                    }
                    Tr.info((TraceComponent)tc, (String)"WTRN0006_TRANSACTION_HAS_TIMED_OUT", (Object)new Object[]{this._tran.getGlobalTID(), new Integer(this._duration)});
                    this._tran.timeoutTransaction(true);
                    break;
                }
                case 3: {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction repeat timeout", (Object)this._tran);
                    }
                    this._tran.timeoutTransaction(false);
                    break;
                }
                case 4: {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Transaction inactivity timeout", (Object)this._tran);
                    }
                    Tr.info((TraceComponent)tc, (String)"WTRN0080_CLIENT_INACTIVITY_TIMEOUT", (Object)new Object[]{this._tran.getGlobalTID(), new Integer(this._duration)});
                    inactivityTimeouts.remove(this._tran);
                    this._tran.inactivityTimeout();
                    break;
                }
                case 2: {
                    pendingTimeouts.remove(this._tran);
                    this._tran.recover();
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"alarm");
            }
        }

        public void cancelAlarm() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"cancelAlarm", (Object)this._alarm);
            }
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"cancelAlarm");
            }
        }
    }
}

