/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.XARecUtil;
import com.ibm.ws.Transaction.JTA.XARecoveryWrapper;
import com.ibm.ws.Transaction.JTA.XARminst;
import com.ibm.ws.Transaction.XAResourceFactory;
import com.ibm.ws.Transaction.XAResourceNotAvailableException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.classloader.ExtJarClassLoader;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.transaction.xa.XAResource;

public final class XARecoveryData
extends PartnerLogData {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$Transaction$JTA$XARecoveryData == null ? (class$com$ibm$ws$Transaction$JTA$XARecoveryData = XARecoveryData.class$("com.ibm.ws.Transaction.JTA.XARecoveryData")) : class$com$ibm$ws$Transaction$JTA$XARecoveryData), (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static ArrayList xarmList = new ArrayList();
    private static String _txRecoveryUtilsPath = null;
    private ExtJarClassLoader _recoveryClassLoader = null;
    static /* synthetic */ Class class$com$ibm$ws$Transaction$JTA$XARecoveryData;

    public XARecoveryData(XARecoveryWrapper xARecoveryWrapper) {
        super(xARecoveryWrapper);
    }

    public XARecoveryData(byte[] byArray, XARecoveryWrapper xARecoveryWrapper, long l) {
        super(byArray, xARecoveryWrapper, l);
    }

    public static XARecoveryData getRecoveryEntry(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRecoveryEntry: index = " + n));
        }
        XARecoveryData xARecoveryData = null;
        PartnerLogData partnerLogData = PartnerLogData.getPartnerEntry(n);
        if (partnerLogData instanceof XARecoveryData) {
            xARecoveryData = (XARecoveryData)partnerLogData;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoveryEntry");
        }
        return xARecoveryData;
    }

    public static synchronized int findRecoveryEntry(XARecoveryWrapper xARecoveryWrapper) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findRecoveryEntry", (Object)xARecoveryWrapper);
        }
        int n = -1;
        boolean bl = false;
        Iterator iterator = XARecoveryData.getIterator();
        while (iterator.hasNext()) {
            ++n;
            object = ((PartnerLogData)iterator.next())._logData;
            if (object == null || !xARecoveryWrapper.equals(object)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found entry in table");
            }
            bl = true;
            break;
        }
        if (!bl) {
            Serializable serializable;
            Object object2;
            object = new XARecoveryData(xARecoveryWrapper);
            n = XARecoveryData.addPartnerEntry((PartnerLogData)object);
            byte[] byArray = XARecUtil.serObjByte((Object)xARecoveryWrapper);
            String[] stringArray = xARecoveryWrapper.getXAResourceFactoryClasspath();
            if (byArray == null) {
                Tr.warning((TraceComponent)tc, (String)"WTRN0039_SERIALIZE_FAILED");
                object2 = new NotSerializableException("XAResource recovery information failed serialization");
                Tr.audit((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object)new Object[]{xARecoveryWrapper.getXAResourceInfo(), object2});
            } else {
                try {
                    object2 = null;
                    if (stringArray != null) {
                        object2 = XARecoveryData.buildRecoveryClassLoader(stringArray, Thread.currentThread().getContextClassLoader());
                    }
                    if ((serializable = XARecoveryData.deserializeWrapper(byArray, (ClassLoader)object2)) != null) {
                        ((XARecoveryWrapper)serializable).setXAResourceFactoryClasspath(stringArray);
                    }
                    if (serializable == null || !((XARecoveryWrapper)serializable).equals(xARecoveryWrapper)) {
                        Tr.error((TraceComponent)tc, (String)"WTRN0039_SERIALIZE_FAILED");
                        NotSerializableException notSerializableException = new NotSerializableException("XAResource recovery information failed deserialization");
                        Tr.audit((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object)new Object[]{xARecoveryWrapper.getXAResourceInfo(), notSerializableException});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"XAResourceInfo fails equality test");
                        }
                        byArray = null;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.findRecoveryEntry", (String)"196");
                    Tr.error((TraceComponent)tc, (String)"WTRN0040_OBJECT_DESERIALIZE_FAILED", (Object)exception);
                    Tr.audit((TraceComponent)tc, (String)"WTRN0045_CANNOT_RECOVER_RESOURCE", (Object)new Object[]{xARecoveryWrapper.getXAResourceInfo(), exception});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"XAResourceInfo fails deserialization test", (Object)exception);
                    }
                    byArray = null;
                }
            }
            if (byArray != null) {
                object2 = null;
                if (stringArray != null) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"XAResourceInfo classpath data found. Adding to log data");
                    }
                    serializable = new StringBuffer();
                    if (tc.isDebugEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Creating String from array elements.");
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Element [" + i + "] = " + stringArray[i]));
                        }
                        ((StringBuffer)serializable).append(stringArray[i]);
                        ((StringBuffer)serializable).append(File.pathSeparator);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ResourceInfo classpath", (Object)((StringBuffer)serializable).toString());
                    }
                    byte[] byArray2 = ((StringBuffer)serializable).toString().getBytes();
                    object2 = new byte[byArray2.length + 1 + byArray.length];
                    System.arraycopy(byArray2, 0, object2, 0, byArray2.length);
                    object2[byArray2.length] = false;
                    System.arraycopy(byArray, 0, object2, byArray2.length + 1, byArray.length);
                } else {
                    object2 = new byte[1 + byArray.length];
                    object2[0] = false;
                    System.arraycopy(byArray, 0, object2, 1, byArray.length);
                }
                ((PartnerLogData)object).setSerializedLogData((byte[])object2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findRecoveryEntry: " + n));
        }
        return n;
    }

    public synchronized void logRecoveryEntry() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logRecoveryEntry", (Object)this);
        }
        if (this._terminating) {
            Tr.warning((TraceComponent)tc, (String)"WTRN0084_RESOURCE_ENDING");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"logRecoveryEntry: Terminating");
            }
            throw new IllegalStateException();
        }
        if (!this._loggedToDisk) {
            if (this._serializedLogData == null) {
                Tr.warning((TraceComponent)tc, (String)"WTRN0039_SERIALIZE_FAILED");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"logRecoveryEntry: NotSerializable");
                }
                throw new NotSerializableException("XAResource recovery information not serializable");
            }
            try {
                _recmgr.checkClassPath();
                XARecoveryData.logData(this._recoveryId, 34, this._serializedLogData);
                this._loggedToDisk = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.logRecoveryEntry", (String)"284", (Object)this);
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logRecoveryEntry");
        }
    }

    public void deserialize(ClassLoader classLoader) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deserialize", (Object)this);
        }
        int n = 0;
        for (int i = 0; i < this._serializedLogData.length; ++i) {
            if (this._serializedLogData[i] != 0) continue;
            n = i;
            break;
        }
        byte[] byArray = new byte[this._serializedLogData.length - n - 1];
        System.arraycopy(this._serializedLogData, n + 1, byArray, 0, byArray.length);
        String[] stringArray = null;
        if (n > 0) {
            object = new byte[n];
            System.arraycopy(this._serializedLogData, 0, object, 0, ((byte[])object).length);
            String string = new String((byte[])object);
            Tr.debug((TraceComponent)tc, (String)"Classpath data recovered.", (Object)string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("extDirs[" + i + "] = " + stringArray[i]));
            }
            if (this._recoveryClassLoader == null) {
                this._recoveryClassLoader = XARecoveryData.buildRecoveryClassLoader(stringArray, classLoader);
            }
        }
        if ((object = (Object)XARecoveryData.deserializeWrapper(byArray, (ClassLoader)this._recoveryClassLoader)) != null) {
            if (stringArray != null) {
                ((XARecoveryWrapper)object).setXAResourceFactoryClasspath(stringArray);
            }
            this._logData = object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deserialize");
        }
    }

    public static ExtJarClassLoader buildRecoveryClassLoader(String[] stringArray, ClassLoader classLoader) {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"buildRecoveryClassLoader", (Object)classLoader);
        }
        if (_txRecoveryUtilsPath == null) {
            object3 = ((WsClassLoader)classLoader).getClassPath();
            object2 = new StringTokenizer((String)object3, File.pathSeparator);
            while (((StringTokenizer)object2).hasMoreTokens() && _txRecoveryUtilsPath == null) {
                object = ((StringTokenizer)object2).nextToken();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("classpath token:" + (String)object));
                }
                if (((String)object).indexOf("txRecoveryUtils.jar") == -1) continue;
                _txRecoveryUtilsPath = object;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"txRecoveryUtils.jar path", (Object)_txRecoveryUtilsPath);
            }
            if (!((File)(object = new File(_txRecoveryUtilsPath))).exists()) {
                Tr.error((TraceComponent)tc, (String)"WTRN0003_RECOVERY_TXRECUTILS_LOAD_FAILED", (Object)_txRecoveryUtilsPath);
            }
        }
        object3 = classLoader;
        object2 = stringArray;
        object = _txRecoveryUtilsPath;
        ExtJarClassLoader extJarClassLoader = (ExtJarClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((String[])object2, (ClassLoader)object3, (String)object){
            private final /* synthetic */ String[] val$cPath;
            private final /* synthetic */ ClassLoader val$pClassLoader;
            private final /* synthetic */ String val$txRecoveryUtilsPath;
            {
                this.val$cPath = stringArray;
                this.val$pClassLoader = classLoader;
                this.val$txRecoveryUtilsPath = string;
            }

            public Object run() {
                ExtJarClassLoader extJarClassLoader = new ExtJarClassLoader(this.val$cPath, this.val$pClassLoader, null, false);
                extJarClassLoader.addPath(this.val$txRecoveryUtilsPath);
                return extJarClassLoader;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildRecoveryClassLoader", (Object)extJarClassLoader);
        }
        return extJarClassLoader;
    }

    public static XARecoveryWrapper deserializeWrapper(byte[] byArray, ClassLoader classLoader) {
        XARecoveryWrapper xARecoveryWrapper;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"deserializeWrapper", (Object)classLoader);
            }
            xARecoveryWrapper = null;
            try {
                if (classLoader != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Classpath data logged. Deserializing using custom classloader");
                    }
                    final String string = new XARecUtil().getClass().getName();
                    final ClassLoader classLoader2 = classLoader;
                    final byte[] byArray2 = byArray;
                    try {
                        xARecoveryWrapper = (XARecoveryWrapper)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                Class<?> clazz = Class.forName(string, true, classLoader2);
                                return clazz.getMethod("deserObjByte", byArray2.getClass()).invoke(null, new Object[]{byArray2});
                            }
                        });
                        break block10;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.deserializeWrapper", (String)"456");
                        Exception exception = privilegedActionException.getException();
                        throw exception;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No classpath data recovered. Deserializing normally.");
                }
                xARecoveryWrapper = (XARecoveryWrapper)XARecUtil.deserObjByte((byte[])byArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.deserializeWrapper", (String)"496");
                String string = classNotFoundException.getMessage();
                int n = string.indexOf(":");
                string = string.substring(n + 1);
                Tr.error((TraceComponent)tc, (String)"WTRN0002_UNABLE_TO_FIND_RESOURCE_CLASS", (Object)string);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.deserializeWrapper", (String)"509");
                Tr.error((TraceComponent)tc, (String)"WTRN0040_OBJECT_DESERIALIZE_FAILED", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deserializeWrapper", (Object)xARecoveryWrapper);
        }
        return xARecoveryWrapper;
    }

    public static synchronized boolean recover(byte[] byArray, ExtClassLoader extClassLoader) {
        XARecoveryWrapper xARecoveryWrapper = null;
        String string = null;
        XAResourceFactory xAResourceFactory = null;
        XAResource xAResource = null;
        XARminst xARminst = null;
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover");
        }
        PartnerLogData.getIterator();
        int n = recoveryTable.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            PartnerLogData partnerLogData = (PartnerLogData)recoveryTable.get(i);
            if (!(partnerLogData instanceof XARecoveryData) || partnerLogData._recovered) continue;
            if (partnerLogData._terminating) {
                bl = false;
                continue;
            }
            if (partnerLogData._logData == null) {
                ((XARecoveryData)partnerLogData).deserialize((ClassLoader)extClassLoader);
                if (partnerLogData._logData == null) {
                    bl = false;
                    continue;
                }
            }
            xARecoveryWrapper = (XARecoveryWrapper)partnerLogData._logData;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"recovering: ", (Object)xARecoveryWrapper);
            }
            ClassLoader classLoader = ((XARecoveryData)partnerLogData).getRecoveryClassLoader();
            string = xARecoveryWrapper.getXAResourceFactoryClassName();
            try {
                object = null;
                object = classLoader != null ? Class.forName(string, true, classLoader) : Class.forName(string);
                xAResourceFactory = (XAResourceFactory)object.newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.recover", (String)"479");
                Tr.error((TraceComponent)tc, (String)"WTRN0004_CANT_CREATE_XARESOURCEFACTORY", (Object)new Object[]{string, exception});
                bl = false;
                continue;
            }
            object = xARecoveryWrapper.getXAResourceInfo();
            try {
                xAResource = xAResourceFactory.getXAResource(object);
            }
            catch (XAResourceNotAvailableException xAResourceNotAvailableException) {
                FFDCFilter.processException((Throwable)xAResourceNotAvailableException, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.recover", (String)"498");
                Tr.warning((TraceComponent)tc, (String)"WTRN0005_CANT_RECREATE_XARESOURCE", (Object)new Object[]{object, xAResourceNotAvailableException});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"An XAResource for a transaction participant could not be recreated and transaction recovery may not be able to complete properly: ", (Object)((Object)xAResourceNotAvailableException));
                }
                bl = false;
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.Transaction.JTA.XARecoveryData.recover", (String)"509");
                Tr.warning((TraceComponent)tc, (String)"WTRN0005_CANT_RECREATE_XARESOURCE", (Object)new Object[]{object, exception});
                bl = false;
                continue;
            }
            xARminst = new XARminst(xAResource, xAResourceFactory);
            xarmList.add(xARminst);
            xARminst.recover((XARecoveryData)partnerLogData, byArray);
            if (partnerLogData._recovered) continue;
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("recover " + bl));
        }
        return bl;
    }

    public static XARecoveryData findRecoveryEntry(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findRecoveryEntry: " + l));
        }
        PartnerLogData partnerLogData = PartnerLogData.findPartnerEntry(l);
        XARecoveryData xARecoveryData = null;
        if (partnerLogData instanceof XARecoveryData) {
            xARecoveryData = (XARecoveryData)partnerLogData;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findRecoveryEntry", (Object)xARecoveryData);
        }
        return xARecoveryData;
    }

    public static synchronized void recoveryCompleted(XARminst xARminst) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryCompleted", (Object)xARminst);
        }
        if ((n = xarmList.indexOf(xARminst)) > -1) {
            xarmList.remove(n);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Entry in recovery table not found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryCompleted");
        }
    }

    public XARecoveryWrapper getXARecoveryWrapper() {
        if (this._logData instanceof XARecoveryWrapper) {
            return (XARecoveryWrapper)this._logData;
        }
        return null;
    }

    public ClassLoader getRecoveryClassLoader() {
        return this._recoveryClassLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

