/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction.JTA;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import javax.transaction.xa.Xid;
import org.omg.CosTransactions.otid_t;

public final class XID
implements Xid {
    private int formatId;
    private int gtrid_length;
    private int bqual_length;
    private byte[] data;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private static final int XIDDATASIZE = 128;
    private int hashValue = 0;
    public static final int WAS_FORMAT_ID = 1463898948;
    private static final int ONEPHASE_FORMAT_ID = 122771;
    private static final int NULL_FORMAT_ID = -1;
    private static byte[] ourApplId = null;
    private static byte[] ourEpoch = null;
    private static int applIdSize;
    private static final int epochSize = 4;
    private static final int rmidSize = 4;
    private static int bqualSize;
    private static final TraceComponent tc;
    static /* synthetic */ Class class$com$ibm$ws$Transaction$JTA$XID;

    public XID() {
        this.data = new byte[0];
        this.formatId = -1;
    }

    public XID(int n, byte[] byArray, byte[] byArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("XID: fid = " + n + ", gtrid length = " + byArray.length + ", bqual length = " + byArray2.length));
        }
        this.formatId = n;
        this.gtrid_length = byArray.length;
        this.bqual_length = byArray2.length;
        this.data = new byte[this.gtrid_length + this.bqual_length];
        System.arraycopy(byArray, 0, this.data, 0, this.gtrid_length);
        System.arraycopy(byArray2, 0, this.data, this.gtrid_length, this.bqual_length);
        if (this.bqual_length > 3) {
            this.hashValue = ((byArray2[this.bqual_length - 4] & 0xFF) << 24) + ((byArray2[this.bqual_length - 3] & 0xFF) << 16) + ((byArray2[this.bqual_length - 2] & 0xFF) << 8) + (byArray2[this.bqual_length - 1] & 0xFF);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("hashValue: " + this.hashValue));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XID", (Object)this);
        }
    }

    public XID(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("XID: rmid = " + Integer.toHexString(n)));
        }
        this.formatId = 122771;
        this.data = XID.intToBytes(n);
        this.gtrid_length = this.data.length;
        this.bqual_length = 0;
        this.hashValue = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XID", (Object)this);
        }
    }

    public XID(otid_t otid_t2, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("XID: otid: " + otid_t2 + ", rmid: " + Integer.toHexString(n)));
        }
        if (otid_t2 == null || otid_t2.formatID == -1) {
            this.formatId = -1;
            this.data = new byte[0];
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"XID", (Object)this);
            }
            return;
        }
        if (otid_t2.tid == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("otid length: 0 bqual_length: " + otid_t2.bqual_length));
            }
            this.gtrid_length = 0;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("otid length: " + otid_t2.tid.length + " bqual_length: " + otid_t2.bqual_length));
            }
            this.gtrid_length = otid_t2.tid.length - otid_t2.bqual_length;
            if (this.gtrid_length > 64) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"gtrid_length of otid is greater than 64");
                }
                this.gtrid_length = 64;
            }
        }
        this.formatId = 1463898948;
        if (ourEpoch == null) {
            XID.initialiseServerValues();
        }
        this.bqual_length = bqualSize;
        this.data = new byte[this.gtrid_length + this.bqual_length];
        if (otid_t2.tid != null) {
            System.arraycopy(otid_t2.tid, 0, this.data, 0, this.gtrid_length);
        }
        System.arraycopy(ourApplId, 0, this.data, this.gtrid_length, applIdSize);
        System.arraycopy(ourEpoch, 0, this.data, this.gtrid_length + applIdSize, 4);
        int n2 = this.gtrid_length + this.bqual_length;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("xid's bqual_length is " + this.bqual_length + " gtrid_length is " + this.gtrid_length));
        }
        for (int i = 0; i < 4; ++i) {
            this.data[n2 - 4 + i] = (byte)(n >> i * 8);
        }
        this.hashValue = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"XID", (Object)this);
        }
    }

    private static synchronized void initialiseServerValues() {
        if (ourEpoch == null) {
            ourApplId = Configuration.getApplId();
            applIdSize = ourApplId.length;
            bqualSize = applIdSize + 4 + 4;
            ourEpoch = XID.intToBytes(Configuration.getCurrentEpoch());
        }
    }

    public static byte[] createBqual(byte[] byArray, int n, int n2) {
        XID.initialiseServerValues();
        if (byArray.length != applIdSize) {
            return null;
        }
        byte[] byArray2 = new byte[bqualSize];
        System.arraycopy(byArray, 0, byArray2, 0, applIdSize);
        System.arraycopy(XID.intToBytes(n), 0, byArray2, applIdSize, 4);
        System.arraycopy(XID.intToBytes(n2), 0, byArray2, applIdSize + 4, 4);
        return byArray2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XID)) {
            return false;
        }
        XID xID = (XID)object;
        if (this.formatId == -1 && xID.formatId == -1) {
            return true;
        }
        if (this.formatId != xID.formatId || this.gtrid_length != xID.gtrid_length || this.bqual_length != xID.bqual_length) {
            return false;
        }
        int n = this.gtrid_length + this.bqual_length;
        while (--n >= 0) {
            if (this.data[n] == xID.data[n]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashValue;
    }

    public String toString() {
        return new String("{XID: formatId(" + Integer.toHexString(this.formatId) + "), gtrid_length(" + this.gtrid_length + "), bqual_length(" + this.bqual_length + "), data(" + Util.toHexString((byte[])this.data) + ")}");
    }

    public byte[] getBranchQualifier() {
        byte[] byArray = new byte[this.bqual_length];
        System.arraycopy(this.data, this.gtrid_length, byArray, 0, this.bqual_length);
        return byArray;
    }

    public void setBranchQualifier(byte[] byArray) {
        this.bqual_length = byArray.length > 64 ? 64 : byArray.length;
        System.arraycopy(byArray, 0, this.data, this.gtrid_length, this.bqual_length);
    }

    public int getFormatId() {
        return this.formatId;
    }

    public void setFormatId(int n) {
        this.formatId = n;
    }

    public static boolean isRecoverableBranchQualifier(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3 = byArray.length > 64 ? 64 : byArray.length;
        int n4 = n2 = byArray2.length > 64 ? 64 : byArray2.length;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isRecoverableBranchQualifier: length1 = " + n3 + ", bqual1 = " + Util.toHexString((byte[])byArray) + " length2 = " + n2 + ", bqual2 = " + Util.toHexString((byte[])byArray2)));
        }
        if (n3 != n2) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isRecoverableBranchQualifier: false");
            }
            return false;
        }
        for (n = 0; n < applIdSize; ++n) {
            if (byArray[n] == byArray2[n]) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isRecoverableBranchQualifier: false");
            }
            return false;
        }
        for (n = 0; n < 4; ++n) {
            if (byArray[n + applIdSize] == byArray2[n + applIdSize]) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isRecoverableBranchQualifier: true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isRecoverableBranchQualifier: false");
        }
        return false;
    }

    public byte[] getGlobalTransactionId() {
        byte[] byArray = new byte[this.gtrid_length];
        System.arraycopy(this.data, 0, byArray, 0, this.gtrid_length);
        return byArray;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getGtridLength() {
        return this.gtrid_length;
    }

    public int getBqualLength() {
        return this.bqual_length;
    }

    public static XID bytesToXid(byte[] byArray, byte[] byArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bytesToXid: length = " + byArray.length + ", data = " + Util.toHexString((byte[])byArray) + ", gtrid length = " + byArray2.length + ", data = " + Util.toHexString((byte[])byArray2)));
        }
        XID xID = null;
        if (byArray.length >= 8) {
            int n = byArray.length - 8;
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 8, byArray3, 0, n);
            xID = new XID(1463898948, byArray2, byArray3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"bytesToXid: returning: ", xID);
        }
        return xID;
    }

    public static long bytesToLong(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bytesToLong: length = " + byArray.length + ", data = " + Util.toHexString((byte[])byArray)));
        }
        long l = -1L;
        if (byArray.length >= 8) {
            l = ((byArray[0] & 0xFF) << 56) + ((byArray[1] & 0xFF) << 48) + ((byArray[2] & 0xFF) << 40) + ((byArray[3] & 0xFF) << 32) + ((byArray[4] & 0xFF) << 24) + ((byArray[5] & 0xFF) << 16) + ((byArray[6] & 0xFF) << 8) + (byArray[7] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("bytesToLong " + l));
        }
        return l;
    }

    public static int bytesToInt(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("bytesToInt: length = " + byArray.length + ", data = " + Util.toHexString((byte[])byArray)));
        }
        int n = -1;
        if (byArray.length >= 4) {
            n = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("bytesToInt " + n));
        }
        return n;
    }

    public static byte[] longToBytes(long l) {
        return new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    public static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        tc = Tr.register((Class)(class$com$ibm$ws$Transaction$JTA$XID == null ? (class$com$ibm$ws$Transaction$JTA$XID = XID.class$("com.ibm.ws.Transaction.JTA.XID")) : class$com$ibm$ws$Transaction$JTA$XID), (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    }
}

