/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.csi.TransactionControlImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.StrUtils;
import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.tran.SyncDriverFactory;
import com.ibm.websphere.csi.UOWControl;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.LocalTransaction.LocalTranDeployCheck;
import com.ibm.ws.Transaction.JTA.PartnerLogData;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.CoordinatorResourceImpl;
import com.ibm.ws.Transaction.JTS.CurrentImpl;
import com.ibm.ws.Transaction.JTS.RecoveryCoordinatorImpl;
import com.ibm.ws.Transaction.JTS.TransactionDiagnosticModule;
import com.ibm.ws.Transaction.JTS.TransactionFactoryImpl;
import com.ibm.ws.Transaction.JTS.TransactionWorkloadRegulator;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.Transaction.test.XAFlowCallbackControl;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.component.TransactionMBean;
import com.ibm.ws.runtime.component.TransactionServiceMetaData;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.TxService;
import com.ibm.ws.runtime.service.WLM;
import com.ibm.ws.runtime.workloadcontroller.WorkloadController;
import com.ibm.ws.runtime.workloadcontroller.WorkloadRegulator;
import java.io.File;
import java.security.MessageDigest;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.omg.CORBA.Object;

public final class TxServiceImpl
extends ComponentImpl
implements TxService,
RecoveryAgent {
    private static TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$runtime$component$TxServiceImpl == null ? (class$com$ibm$ws$runtime$component$TxServiceImpl = TxServiceImpl.class$("com.ibm.ws.runtime.component.TxServiceImpl")) : class$com$ibm$ws$runtime$component$TxServiceImpl), (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TranManagerSet txService;
    private RecoveryDirector recDirector;
    private SyncDriverFactory sdFactory;
    private TransactionServiceMetaData metaData;
    private TransactionService txServiceConfig;
    private String serverName;
    private static long minimumLogFileSize = 65536L;
    private static long defaultLogFileSize = 0x100000L;
    private FileLogProperties transactionLogProps = null;
    private FileLogProperties partnerLogProps = null;
    private static int transactionLogRLI = 1;
    private static int partnerLogRLI = 2;
    static /* synthetic */ Class class$com$ibm$ws$runtime$component$TxServiceImpl;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$TxService;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$ORB;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$Server;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$WLM;
    static /* synthetic */ Class class$com$ibm$ws$runtime$service$MetaDataService;

    public void initialize(java.lang.Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initialize : Config=" + object));
        }
        this.txServiceConfig = (TransactionService)object;
        this.metaData = new TransactionServiceMetaData(this.txServiceConfig);
        TransactionImpl.LPSLoggingEnabled = this.txServiceConfig.isEnableLoggingForHeuristicReporting();
        this.addService(class$com$ibm$ws$runtime$service$TxService == null ? (class$com$ibm$ws$runtime$service$TxService = TxServiceImpl.class$("com.ibm.ws.runtime.service.TxService")) : class$com$ibm$ws$runtime$service$TxService);
        ExtClassLoader extClassLoader = (ExtClassLoader)Thread.currentThread().getContextClassLoader();
        while (extClassLoader.getParent() instanceof ExtClassLoader) {
            extClassLoader = (ExtClassLoader)extClassLoader.getParent();
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Class loader classpath: ", (java.lang.Object)extClassLoader.getClassPath());
        }
        Configuration.setClassLoader((ExtClassLoader)extClassLoader);
        TransactionDiagnosticModule transactionDiagnosticModule = TransactionDiagnosticModule.instance();
        transactionDiagnosticModule.registerWithFFDCService();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeError, RuntimeWarning {
        RecoveryLogManager recoveryLogManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        ORB oRB = null;
        Server server = null;
        WLM wLM = null;
        MetaDataService metaDataService = null;
        try {
            InitialContext initialContext;
            java.lang.Object object;
            TransactionFactoryImpl transactionFactoryImpl;
            oRB = (ORB)this.getService(class$com$ibm$ws$runtime$service$ORB == null ? (class$com$ibm$ws$runtime$service$ORB = TxServiceImpl.class$("com.ibm.ws.runtime.service.ORB")) : class$com$ibm$ws$runtime$service$ORB);
            if (oRB == null) {
                throw new RuntimeError("TransactionService requires ORB");
            }
            Configuration.setORB((org.omg.CORBA.ORB)oRB.getORB());
            server = (Server)this.getService(class$com$ibm$ws$runtime$service$Server == null ? (class$com$ibm$ws$runtime$service$Server = TxServiceImpl.class$("com.ibm.ws.runtime.service.Server")) : class$com$ibm$ws$runtime$service$Server);
            this.serverName = server.getName();
            Configuration.setServerName((String)this.serverName);
            Configuration.setApplId((byte[])this.createApplicationId(this.serverName));
            this.txService = TranManagerSet.instance();
            XAFlowCallbackControl.initialize();
            Configuration.setCommitRetries((int)-1);
            Configuration.setInactivityTimeout((int)this.metaData.getClientInactivityTimeout());
            Configuration.setTotalTransactionTimeout((int)this.metaData.getTotalTranLifetimeTimeout());
            this.createTranLogs(this.serverName);
            try {
                this.recDirector = RecoveryDirectorFactory.recoveryDirector();
                recoveryLogManager = this.recDirector.registerService((RecoveryAgent)this, 2);
                Configuration.setLogManager((RecoveryLogManager)recoveryLogManager);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.runtime.component.TxServiceImpl.start", (String)"410", (java.lang.Object)((java.lang.Object)this));
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception caught in TxServiceImpl.start", (java.lang.Object)exception);
                }
                throw new RuntimeException(exception);
            }
            this.sdFactory = new SyncDriverFactory();
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Bind transaction factory in global jndi");
            }
            recoveryLogManager = AdminServiceFactory.getAdminService();
            String string = recoveryLogManager.getProcessType();
            try {
                transactionFactoryImpl = null;
                transactionFactoryImpl = new TransactionFactoryImpl();
                oRB.getORB().connect((Object)transactionFactoryImpl);
                if ("ManagedProcess".equals(string) || "UnManagedProcess".equals(string)) {
                    object = new Hashtable<String, String>();
                    ((Hashtable)object).put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
                    ((Hashtable)object).put("com.ibm.websphere.naming.namespaceroot", "bootstrapserverroot");
                    ((Hashtable)object).put("java.naming.corba.orb", Configuration.getORB());
                    ((Hashtable)object).put("com.ibm.websphere.naming.jndicache.cacheobject", "none");
                    initialContext = new InitialContext((Hashtable<?, ?>)object);
                    initialContext.rebind("TransactionFactory", (java.lang.Object)transactionFactoryImpl);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Tx service executing in a non-app server process");
                }
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.runtime.component.TxServiceImpl.start", (String)"276", (java.lang.Object)((java.lang.Object)this));
                Tr.error((TraceComponent)tc, (String)"WTRN0011_FACTORY_BIND_FAILURE", (java.lang.Object)namingException);
                throw new RuntimeException("Error binding transaction factory in JNDI");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.runtime.component.TxServiceImpl.start", (String)"281", (java.lang.Object)((java.lang.Object)this));
                Tr.error((TraceComponent)tc, (String)"WTRN0012_UNEXP_FACTORY_REG_FAILURE", (java.lang.Object)throwable);
                throw new RuntimeException("Error initializing transaction factory");
            }
            PmiFactory.createTransactionPerf((java.lang.Object)this.txService);
            System.setProperty("com.ibm.ejs.jts.processType", "server");
            wLM = (WLM)this.getService(class$com$ibm$ws$runtime$service$WLM == null ? (class$com$ibm$ws$runtime$service$WLM = TxServiceImpl.class$("com.ibm.ws.runtime.service.WLM")) : class$com$ibm$ws$runtime$service$WLM);
            if (wLM != null) {
                // empty if block
            }
            transactionFactoryImpl = AdminServiceFactory.getMBeanFactory();
            object = new TransactionMBean(this.metaData);
            initialContext = new DefaultRuntimeCollaborator(object, "TransactionService");
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(object, "Transaction");
            try {
                transactionFactoryImpl.activateMBean("TransactionService", (RuntimeCollaborator)initialContext, transactionFactoryImpl.getConfigId((java.lang.Object)this.txServiceConfig), null);
                transactionFactoryImpl.activateMBean("Transaction", (RuntimeCollaborator)defaultRuntimeCollaborator, "Transaction", null);
            }
            catch (AdminException adminException) {
                FFDCFilter.processException((Throwable)adminException, (String)"com.ibm.ws.runtime.component.TxServiceImpl.start", (String)"228", (java.lang.Object)((java.lang.Object)this));
                Tr.service((TraceComponent)tc, (String)"WTRN0100_GENERIC_ERROR", (java.lang.Object)((java.lang.Object)adminException));
            }
            this.txServiceConfig = null;
            if ("ManagedProcess".equals(string) || "UnManagedProcess".equals(string)) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Bind jta/usertransaction in global jndi");
                }
                this.exportUserTx();
            }
            try {
                metaDataService = (MetaDataService)this.getService(class$com$ibm$ws$runtime$service$MetaDataService == null ? (class$com$ibm$ws$runtime$service$MetaDataService = TxServiceImpl.class$("com.ibm.ws.runtime.service.MetaDataService")) : class$com$ibm$ws$runtime$service$MetaDataService);
                metaDataService.addMetaDataListener((MetaDataListener)new LocalTranDeployCheck());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.runtime.component.TxServiceImpl.start", (String)"249", (java.lang.Object)((java.lang.Object)this));
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception when trying to register as MetaDataListener", (java.lang.Object)exception);
                }
                throw new RuntimeWarning((Throwable)exception);
            }
            java.lang.Object var13_16 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var13_17 = null;
            this.releaseService(oRB);
            this.releaseService(server);
            this.releaseService(wLM);
            this.releaseService(metaDataService);
            throw throwable;
        }
        this.releaseService(oRB);
        this.releaseService(server);
        this.releaseService(wLM);
        this.releaseService(metaDataService);
        recoveryLogManager = new TransactionWorkloadRegulator();
        WorkloadController.registerRegulator((WorkloadRegulator)recoveryLogManager);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"TransactionWorkloadRegulator registered");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void destroy() {
        RecoveryManager recoveryManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        boolean bl = true;
        if (this.txService != null) {
            bl = this.txService.isActive();
        }
        if ((recoveryManager = Configuration.getRecoveryManager()) != null) {
            recoveryManager.shutdown(bl);
        }
        this.txService = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public SyncDriverFactory getSyncDriverFactory() {
        return this.sdFactory;
    }

    public UOWControl createTransactionControl() {
        return new TransactionControlImpl((WebSphereTransactionManager)TranManagerSet.instance(), this.sdFactory, this.metaData.getTotalTranLifetimeTimeout().intValue(), this.metaData.getClientInactivityTimeout() * 1000);
    }

    protected void exportUserTx() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"exportUserTx");
        }
        try {
            InitialContext initialContext = new InitialContext();
            Reference reference = new Reference("java.lang.Object", "com.ibm.ws.Transaction.JTA.UtxJNDIFactory", null);
            JndiHelper.recursiveRebind((Context)initialContext, (String)"jta/usertransaction", (java.lang.Object)reference);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.runtime.component.TxServiceImpl.exportUserTx", (String)"234", (java.lang.Object)((java.lang.Object)this));
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"UtxFactory binding failure ", (java.lang.Object)namingException);
            }
            throw new RuntimeException("Error binding UtxFactory into jta/ in JNDI");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"exportUserTx");
        }
    }

    private void createTranLogs(String string) throws RuntimeException {
        java.lang.Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTranLogs");
        }
        String string2 = this.metaData.getTransactionLogDirectory();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Transaction Log Spec=" + string2));
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string2.equals(";0")) {
            Tr.warning((TraceComponent)tc, (String)"WTRN0013_LOGGING_IN_MEMORY");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createTranLogs : return=null");
            }
            return;
        }
        String string3 = null;
        String string4 = null;
        if (string2.lastIndexOf(59) == -1) {
            string3 = string2;
        } else {
            object = StrUtils.split((String)string2, (int)59);
            string3 = object[0];
            string4 = object[1];
        }
        if (string3.equals("")) {
            object = null;
            try {
                object = this.expandVariable("${TRANLOG_ROOT}");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"TRANLOG_ROOT returned from SM", (java.lang.Object)object);
            }
            if (object == null || ((String)object).equals("")) {
                try {
                    object = this.expandVariable("${RECOVERYLOG_ROOT}");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"RECOVERYLOG_ROOT returned from SM", (java.lang.Object)object);
                }
            }
            if (object == null || ((String)object).equals("")) {
                object = "$(USER_INSTALL_ROOT)" + File.separator + "tranlog";
            }
            string3 = (String)object + File.separator + string + File.separator + this.clientName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logFile path before var expand: " + string3));
        }
        try {
            string3 = this.expandVariable(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.runtime.component.TxServiceImpl.createTranLogs", (String)"303", (java.lang.Object)((java.lang.Object)this));
            Tr.warning((TraceComponent)tc, (String)"WTRN0014_UNEXPECTED_LOGFILE_SPECIFICATION");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createTranLogs : return=null");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logFile path after var expand: " + string3));
        }
        this.metaData.setTransactionLogDirectory(string3);
        long l = defaultLogFileSize;
        if (string4 != null && !string4.equals("")) {
            string4.trim();
            try {
                if (string4.endsWith("M")) {
                    l = Long.parseLong(string4.substring(0, string4.length() - 1));
                    l *= 0x100000L;
                } else if (string4.endsWith("K")) {
                    l = Long.parseLong(string4.substring(0, string4.length() - 1));
                    l *= 1024L;
                } else {
                    l = Long.parseLong(string4);
                }
                if (l < minimumLogFileSize) {
                    Tr.warning((TraceComponent)tc, (String)"WTRN0015_DEFAULT_AND_MINIMUM_LOG_SIZE", (java.lang.Object)string4);
                    l = defaultLogFileSize;
                }
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.runtime.component.TxServiceImpl.createTranLogs", (String)"514", (java.lang.Object)((java.lang.Object)this));
                Tr.warning((TraceComponent)tc, (String)"WTRN0015_DEFAULT_AND_MINIMUM_LOG_SIZE", (java.lang.Object)string4);
            }
        }
        int n = (int)(l / 1024L);
        this.transactionLogProps = new FileLogProperties(transactionLogRLI, "tranlog", string3 + File.separator + "tranlog", n);
        this.partnerLogProps = new FileLogProperties(partnerLogRLI, "partnerlog", string3 + File.separator + "partnerlog", n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createTranLogs : return=" + string3));
        }
    }

    public void initiateRecovery(FailureScope failureScope) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initiateRecovery", (java.lang.Object)failureScope);
        }
        boolean bl = true;
        byte[] byArray = null;
        int n = 0;
        String string = new String(failureScope.failureScopeToken());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("serverName to recover: " + string));
        }
        if (string == null || string.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"serverName to recover is not specified");
            }
            throw new RecoveryFailedException();
        }
        if (!string.equals(this.serverName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"serverName to recover is not this server");
            }
            bl = false;
            throw new RecoveryFailedException();
        }
        try {
            RecoveryLogManager recoveryLogManager = Configuration.getLogManager();
            RecoveryLog recoveryLog = null;
            if (this.transactionLogProps != null) {
                recoveryLog = recoveryLogManager.getRecoveryLog(failureScope, (LogProperties)this.transactionLogProps);
            }
            RecoveryLog recoveryLog2 = null;
            if (this.partnerLogProps != null) {
                recoveryLog2 = recoveryLogManager.getRecoveryLog(failureScope, (LogProperties)this.partnerLogProps);
            }
            RecoveryManager recoveryManager = new RecoveryManager(recoveryLog, recoveryLog2);
            if (bl) {
                Configuration.setRecoveryManager((RecoveryManager)recoveryManager);
                byArray = Configuration.getApplId();
                n = Configuration.getCurrentEpoch();
            }
            PartnerLogData.initialize(recoveryManager);
            com.ibm.CORBA.iiop.ORB oRB = (com.ibm.CORBA.iiop.ORB)Configuration.getORB();
            CoordinatorResourceImpl.createServantManager((com.ibm.CORBA.iiop.ORB)oRB, (RecoveryManager)recoveryManager);
            RecoveryCoordinatorImpl.createServantManager((com.ibm.CORBA.iiop.ORB)oRB, (RecoveryManager)recoveryManager);
            recoveryManager.initialise(byArray, n);
            this.recDirector.recoveryComplete((RecoveryAgent)this, failureScope);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.runtime.component.TxServiceImpl.initiateRecovery", (String)"550", (java.lang.Object)((java.lang.Object)this));
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Exception caught during transaction log creation!", (java.lang.Object)exception);
            }
            Tr.error((TraceComponent)tc, (String)"WTRN0016_EXC_DURING_RECOVERY", (java.lang.Object)exception);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initiateRecovery");
            }
            throw new RecoveryFailedException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initiateRecovery");
        }
    }

    public int clientIdentifier() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clientIdentifier");
        }
        return 1;
    }

    public String clientName() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clientName");
        }
        return "transaction";
    }

    private byte[] createApplicationId(String string) {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createApplicationId", (java.lang.Object)string);
        }
        try {
            String string2 = Configuration.getORB().object_to_string((Object)CurrentImpl.instance());
            string2 = string2 + string + System.currentTimeMillis();
            byArray = MessageDigest.getInstance("SHA").digest(Util.byteArray((String)string2));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.runtime.component.TxServiceImpl.createApplicationId", (String)"608", (java.lang.Object)((java.lang.Object)this));
            byArray = Util.byteArray((String)("j" + System.currentTimeMillis() % 9997L + ":" + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createApplicationId : return=", (java.lang.Object)Util.toHexString((byte[])byArray));
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

