/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.texteditor.EditPosition;
import org.eclipse.ui.internal.texteditor.EditorMessages;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.texteditor.ITextEditor;

public class GotoLastEditPositionAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private IAction fAction;

    public GotoLastEditPositionAction() {
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.goto_last_edit_position_action_context");
        this.setId("org.eclipse.ui.edit.text.gotoLastEditPosition");
        this.setActionDefinitionId("org.eclipse.ui.edit.text.gotoLastEditPosition");
        this.setEnabled(false);
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        IEditorPart editor;
        EditPosition editPosition = TextEditorPlugin.getDefault().getLastEditPosition();
        if (editPosition == null) {
            return;
        }
        final Position pos = editPosition.getPosition();
        if (pos == null || pos.isDeleted) {
            return;
        }
        IWorkbenchWindow window = this.getWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        try {
            editor = page.openEditor(editPosition.getEditorInput(), editPosition.getEditorId());
        }
        catch (PartInitException partInitException) {
            editor = null;
        }
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(pos.offset, pos.length);
        } else if (editor != null) {
            final IEditorInput input = editor.getEditorInput();
            final IEditorPart finalEditor = editor;
            if (input instanceof IFileEditorInput) {
                WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException {
                        block3: {
                            IMarker marker = null;
                            try {
                                marker = ((IFileEditorInput)input).getFile().createMarker("org.eclipse.core.resources.textmarker");
                                marker.setAttribute("charStart", pos.offset);
                                marker.setAttribute("charEnd", pos.offset + pos.length);
                                finalEditor.gotoMarker(marker);
                            }
                            catch (Throwable throwable) {
                                Object var3_4 = null;
                                if (marker != null) {
                                    marker.delete();
                                }
                                throw throwable;
                            }
                            Object var3_5 = null;
                            if (marker == null) break block3;
                            marker.delete();
                        }
                    }
                };
                try {
                    op.run(null);
                }
                catch (InvocationTargetException ex) {
                    String message = EditorMessages.getString("Editor.error.gotoLastEditPosition.message");
                    if (this.fWindow != null) {
                        Shell shell = this.fWindow.getShell();
                        String title = EditorMessages.getString("Editor.error.gotoLastEditPosition.title");
                        MessageDialog.openError((Shell)shell, (String)title, (String)message);
                    } else {
                        Throwable t = ex.getTargetException();
                        Status status = new Status(4, "org.eclipse.ui", 0, message, t);
                        TextEditorPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be cancelled");
                }
            }
            editor.setFocus();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enabled = TextEditorPlugin.getDefault().getLastEditPosition() != null;
        this.setEnabled(enabled);
        action.setEnabled(enabled);
        if (!enabled) {
            TextEditorPlugin.getDefault().addLastEditPositionDependentAction(action);
            this.fAction = action;
        }
    }

    private IWorkbenchWindow getWindow() {
        if (this.fWindow == null) {
            this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return this.fWindow;
    }

    public void dispose() {
        this.fWindow = null;
        TextEditorPlugin.getDefault().removeLastEditPositionDependentAction(this.fAction);
    }
}

