/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IDocumentProviderExtension2;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IElementStateListenerExtension;

public abstract class AbstractDocumentProvider
implements IDocumentProvider,
IDocumentProviderExtension,
IDocumentProviderExtension2 {
    protected static final boolean PR10806_UC5_ENABLED = false;
    protected static final boolean PR14469_ENABLED = true;
    protected static final IStatus STATUS_OK = new Status(0, "org.eclipse.ui", 0, EditorMessages.getString("AbstractDocumentProvider.ok"), null);
    protected static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.ui", 1, EditorMessages.getString("AbstractDocumentProvider.error"), null);
    private Map fElementInfoMap = new HashMap();
    private List fElementStateListeners = new ArrayList();
    private IProgressMonitor fProgressMonitor;

    protected AbstractDocumentProvider() {
    }

    protected abstract IDocument createDocument(Object var1) throws CoreException;

    protected abstract IAnnotationModel createAnnotationModel(Object var1) throws CoreException;

    protected abstract void doSaveDocument(IProgressMonitor var1, Object var2, IDocument var3, boolean var4) throws CoreException;

    protected ElementInfo getElementInfo(Object element) {
        return (ElementInfo)this.fElementInfoMap.get(element);
    }

    protected ElementInfo createElementInfo(Object element) throws CoreException {
        return new ElementInfo(this.createDocument(element), this.createAnnotationModel(element));
    }

    protected void disposeElementInfo(Object element, ElementInfo info) {
    }

    protected void addUnchangedElementListeners(Object element, ElementInfo info) {
        if (info.fDocument != null) {
            info.fDocument.addDocumentListener((IDocumentListener)info);
        }
    }

    protected void removeUnchangedElementListeners(Object element, ElementInfo info) {
        if (info.fDocument != null) {
            info.fDocument.removeDocumentListener((IDocumentListener)info);
        }
    }

    protected Iterator getConnectedElements() {
        HashSet s = new HashSet();
        Set keys = this.fElementInfoMap.keySet();
        if (keys != null) {
            s.addAll(keys);
        }
        return s.iterator();
    }

    public final void connect(Object element) throws CoreException {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info == null) {
            info = this.createElementInfo(element);
            if (info == null) {
                info = new ElementInfo(null, null);
            }
            info.fElement = element;
            this.addUnchangedElementListeners(element, info);
            this.fElementInfoMap.put(element, info);
            if (this.fElementInfoMap.size() == 1) {
                this.connected();
            }
        }
        ++info.fCount;
    }

    protected void connected() {
    }

    public final void disconnect(Object element) {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info == null) {
            return;
        }
        if (info.fCount == 1) {
            this.fElementInfoMap.remove(element);
            this.removeUnchangedElementListeners(element, info);
            this.disposeElementInfo(element, info);
            if (this.fElementInfoMap.size() == 0) {
                this.disconnected();
            }
        } else {
            --info.fCount;
        }
    }

    protected void disconnected() {
    }

    public IDocument getDocument(Object element) {
        if (element == null) {
            return null;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        return info != null ? info.fDocument : null;
    }

    public boolean mustSaveDocument(Object element) {
        if (element == null) {
            return false;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        return info != null ? info.fCount == 1 && info.fCanBeSaved : false;
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        if (element == null) {
            return null;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        return info != null ? info.fModel : null;
    }

    public boolean canSaveDocument(Object element) {
        if (element == null) {
            return false;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        return info != null ? info.fCanBeSaved : false;
    }

    public void resetDocument(Object element) throws CoreException {
        if (element == null) {
            return;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            IDocument original = null;
            IStatus status = null;
            try {
                original = this.createDocument(element);
            }
            catch (CoreException x) {
                status = x.getStatus();
            }
            info.fStatus = status;
            if (original != null) {
                this.fireElementContentAboutToBeReplaced(element);
                info.fDocument.set(original.get());
                if (info.fCanBeSaved) {
                    info.fCanBeSaved = false;
                    this.addUnchangedElementListeners(element, info);
                }
                this.fireElementContentReplaced(element);
                this.fireElementDirtyStateChanged(element, false);
            }
        }
    }

    public void saveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element == null) {
            return;
        }
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            if (info.fDocument != document) {
                Status status = new Status(2, "org.eclipse.ui", 4, EditorMessages.getString("AbstractDocumentProvider.error.save.inuse"), null);
                throw new CoreException((IStatus)status);
            }
            this.doSaveDocument(monitor, element, document, overwrite);
            info.fCanBeSaved = false;
            this.addUnchangedElementListeners(element, info);
            this.fireElementDirtyStateChanged(element, false);
        } else {
            this.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    public void aboutToChange(Object element) {
    }

    public void changed(Object element) {
    }

    public void addElementStateListener(IElementStateListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fElementStateListeners.contains(listener)) {
            this.fElementStateListeners.add(listener);
        }
    }

    public void removeElementStateListener(IElementStateListener listener) {
        Assert.isNotNull((Object)listener);
        this.fElementStateListeners.remove(listener);
    }

    protected void fireElementDirtyStateChanged(Object element, boolean isDirty) {
        Iterator e = ((AbstractList)new ArrayList(this.fElementStateListeners)).iterator();
        while (e.hasNext()) {
            IElementStateListener l = (IElementStateListener)e.next();
            l.elementDirtyStateChanged(element, isDirty);
        }
    }

    protected void fireElementContentAboutToBeReplaced(Object element) {
        Iterator e = ((AbstractList)new ArrayList(this.fElementStateListeners)).iterator();
        while (e.hasNext()) {
            IElementStateListener l = (IElementStateListener)e.next();
            l.elementContentAboutToBeReplaced(element);
        }
    }

    protected void fireElementContentReplaced(Object element) {
        Iterator e = ((AbstractList)new ArrayList(this.fElementStateListeners)).iterator();
        while (e.hasNext()) {
            IElementStateListener l = (IElementStateListener)e.next();
            l.elementContentReplaced(element);
        }
    }

    protected void fireElementDeleted(Object element) {
        Iterator e = ((AbstractList)new ArrayList(this.fElementStateListeners)).iterator();
        while (e.hasNext()) {
            IElementStateListener l = (IElementStateListener)e.next();
            l.elementDeleted(element);
        }
    }

    protected void fireElementMoved(Object originalElement, Object movedElement) {
        Iterator e = ((AbstractList)new ArrayList(this.fElementStateListeners)).iterator();
        while (e.hasNext()) {
            IElementStateListener l = (IElementStateListener)e.next();
            l.elementMoved(originalElement, movedElement);
        }
    }

    public long getModificationStamp(Object element) {
        return 0L;
    }

    public long getSynchronizationStamp(Object element) {
        return 0L;
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    public boolean isReadOnly(Object element) {
        return true;
    }

    public boolean isModifiable(Object element) {
        return false;
    }

    public boolean isStateValidated(Object element) {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            return info.fIsStateValidated;
        }
        return false;
    }

    protected void doValidateState(Object element, Object computationContext) throws CoreException {
    }

    public final void validateState(Object element, Object computationContext) throws CoreException {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info == null) {
            return;
        }
        this.doValidateState(element, computationContext);
        this.doUpdateStateCache(element);
        info.fIsStateValidated = true;
        this.fireElementStateValidationChanged(element, true);
    }

    protected void doUpdateStateCache(Object element) throws CoreException {
    }

    protected boolean invalidatesState(Object element, boolean wasReadOnly) {
        boolean readOnlyChanged;
        Assert.isTrue((boolean)true);
        boolean bl = readOnlyChanged = this.isReadOnly(element) != wasReadOnly;
        return readOnlyChanged && !this.canSaveDocument(element);
    }

    public final void updateStateCache(Object element) throws CoreException {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            boolean wasReadOnly = this.isReadOnly(element);
            this.doUpdateStateCache(element);
            if (this.invalidatesState(element, wasReadOnly)) {
                info.fIsStateValidated = false;
                this.fireElementStateValidationChanged(element, false);
            }
        }
    }

    public void setCanSaveDocument(Object element) {
        ElementInfo info;
        if (element != null && (info = (ElementInfo)this.fElementInfoMap.get(element)) != null) {
            info.fCanBeSaved = true;
            this.removeUnchangedElementListeners(element, info);
            this.fireElementDirtyStateChanged(element, info.fCanBeSaved);
        }
    }

    protected void fireElementStateValidationChanged(Object element, boolean isStateValidated) {
        Iterator e = ((AbstractList)new ArrayList(this.fElementStateListeners)).iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof IElementStateListenerExtension)) continue;
            IElementStateListenerExtension l = (IElementStateListenerExtension)o;
            l.elementStateValidationChanged(element, isStateValidated);
        }
    }

    protected void fireElementStateChanging(Object element) {
        Iterator e = ((AbstractList)new ArrayList(this.fElementStateListeners)).iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof IElementStateListenerExtension)) continue;
            IElementStateListenerExtension l = (IElementStateListenerExtension)o;
            l.elementStateChanging(element);
        }
    }

    protected void fireElementStateChangeFailed(Object element) {
        Iterator e = ((AbstractList)new ArrayList(this.fElementStateListeners)).iterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof IElementStateListenerExtension)) continue;
            IElementStateListenerExtension l = (IElementStateListenerExtension)o;
            l.elementStateChangeFailed(element);
        }
    }

    public IStatus getStatus(Object element) {
        ElementInfo info = (ElementInfo)this.fElementInfoMap.get(element);
        if (info != null) {
            if (info.fStatus != null) {
                return info.fStatus;
            }
            return info.fDocument == null ? STATUS_ERROR : STATUS_OK;
        }
        return STATUS_ERROR;
    }

    public void synchronize(Object element) throws CoreException {
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor == null ? new NullProgressMonitor() : this.fProgressMonitor;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }

    protected class ElementInfo
    implements IDocumentListener {
        public Object fElement;
        public int fCount;
        public boolean fCanBeSaved;
        public IDocument fDocument;
        public IAnnotationModel fModel;
        public boolean fIsStateValidated;
        public IStatus fStatus;

        public ElementInfo(IDocument document, IAnnotationModel model) {
            this.fDocument = document;
            this.fModel = model;
            this.fCount = 0;
            this.fCanBeSaved = false;
            this.fIsStateValidated = false;
        }

        public boolean equals(Object o) {
            if (o instanceof ElementInfo) {
                ElementInfo e = (ElementInfo)o;
                return this.fDocument.equals(e.fDocument);
            }
            return false;
        }

        public int hashCode() {
            return this.fDocument.hashCode();
        }

        public void documentChanged(DocumentEvent event) {
            this.fCanBeSaved = true;
            AbstractDocumentProvider.this.removeUnchangedElementListeners(this.fElement, this);
            AbstractDocumentProvider.this.fireElementDirtyStateChanged(this.fElement, this.fCanBeSaved);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    }
}

