/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class BasicTextEditorActionContributor
extends EditorActionBarContributor {
    private static final String[] ACTIONS = new String[]{"undo", "redo", "cut", "copy", "paste", "delete", "selectAll", "find", "bookmark", "addTask", "print", "revert"};
    private static final String[] STATUSFIELDS = new String[]{"ElementState", "InputMode", "InputPosition"};
    private IEditorPart fActiveEditorPart;
    private RetargetTextEditorAction fFindNext = new RetargetTextEditorAction(EditorMessages.getResourceBundle(), "Editor.FindNext.");
    private RetargetTextEditorAction fFindPrevious;
    private RetargetTextEditorAction fIncrementalFind;
    private RetargetTextEditorAction fIncrementalFindReverse;
    private RetargetTextEditorAction fGotoLine;
    private Map fStatusFields;

    public BasicTextEditorActionContributor() {
        this.fFindNext.setActionDefinitionId("org.eclipse.ui.edit.findNext");
        this.fFindPrevious = new RetargetTextEditorAction(EditorMessages.getResourceBundle(), "Editor.FindPrevious.");
        this.fFindPrevious.setActionDefinitionId("org.eclipse.ui.edit.findPrevious");
        this.fIncrementalFind = new RetargetTextEditorAction(EditorMessages.getResourceBundle(), "Editor.FindIncremental.");
        this.fIncrementalFind.setActionDefinitionId("org.eclipse.ui.edit.findIncremental");
        this.fIncrementalFindReverse = new RetargetTextEditorAction(EditorMessages.getResourceBundle(), "Editor.FindIncrementalReverse.");
        this.fIncrementalFindReverse.setActionDefinitionId("org.eclipse.ui.edit.findIncrementalReverse");
        this.fGotoLine = new RetargetTextEditorAction(EditorMessages.getResourceBundle(), "Editor.GotoLine.");
        this.fGotoLine.setActionDefinitionId("org.eclipse.ui.edit.text.goto.line");
        this.fStatusFields = new HashMap(3);
        int i = 0;
        while (i < STATUSFIELDS.length) {
            this.fStatusFields.put(STATUSFIELDS[i], new StatusLineContributionItem(STATUSFIELDS[i]));
            ++i;
        }
    }

    protected final IEditorPart getActiveEditorPart() {
        return this.fActiveEditorPart;
    }

    protected final IAction getAction(ITextEditor editor, String actionId) {
        return editor == null ? null : editor.getAction(actionId);
    }

    private void doSetActiveEditor(IEditorPart part) {
        if (this.fActiveEditorPart == part) {
            return;
        }
        if (this.fActiveEditorPart instanceof ITextEditorExtension) {
            ITextEditorExtension extension = (ITextEditorExtension)this.fActiveEditorPart;
            int i = 0;
            while (i < STATUSFIELDS.length) {
                extension.setStatusField(null, STATUSFIELDS[i]);
                ++i;
            }
        }
        this.fActiveEditorPart = part;
        ITextEditor editor = part instanceof ITextEditor ? (ITextEditor)part : null;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            int i = 0;
            while (i < ACTIONS.length) {
                actionBars.setGlobalActionHandler(ACTIONS[i], this.getAction(editor, ACTIONS[i]));
                ++i;
            }
        }
        this.fFindNext.setAction(this.getAction(editor, "FindNext"));
        this.fFindPrevious.setAction(this.getAction(editor, "FindPrevious"));
        this.fIncrementalFind.setAction(this.getAction(editor, "FindIncremental"));
        this.fIncrementalFindReverse.setAction(this.getAction(editor, "FindIncrementalReverse"));
        this.fGotoLine.setAction(this.getAction(editor, "GotoLine"));
        if (this.fActiveEditorPart instanceof ITextEditorExtension) {
            ITextEditorExtension extension = (ITextEditorExtension)this.fActiveEditorPart;
            int i = 0;
            while (i < STATUSFIELDS.length) {
                extension.setStatusField((IStatusField)this.fStatusFields.get(STATUSFIELDS[i]), STATUSFIELDS[i]);
                ++i;
            }
        }
    }

    public void setActiveEditor(IEditorPart part) {
        this.doSetActiveEditor(part);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager navigateMenu;
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.appendToGroup("cut.ext", (IAction)this.fFindNext);
            editMenu.appendToGroup("cut.ext", (IAction)this.fFindPrevious);
            editMenu.appendToGroup("cut.ext", (IAction)this.fIncrementalFind);
            editMenu.appendToGroup("cut.ext", (IAction)this.fIncrementalFindReverse);
        }
        if ((navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("additions", (IAction)this.fGotoLine);
        }
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        int i = 0;
        while (i < STATUSFIELDS.length) {
            statusLineManager.add((IContributionItem)this.fStatusFields.get(STATUSFIELDS[i]));
            ++i;
        }
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        super.dispose();
    }
}

