/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class DefaultMarkerAnnotationAccess
implements IAnnotationAccess {
    public static final String UNKNOWN = "org.eclipse.ui.workbench.texteditor.unknown";
    protected MarkerAnnotationPreferences fMarkerAnnotationPreferences;

    public DefaultMarkerAnnotationAccess(MarkerAnnotationPreferences markerAnnotationPreferences) {
        this.fMarkerAnnotationPreferences = markerAnnotationPreferences;
    }

    private AnnotationPreference getAnnotationPreference(IMarker marker) {
        try {
            int severity = marker.getAttribute("severity", 0);
            Iterator e = this.fMarkerAnnotationPreferences.getAnnotationPreferences().iterator();
            while (e.hasNext()) {
                AnnotationPreference info = (AnnotationPreference)e.next();
                if (!marker.isSubtypeOf(info.getMarkerType()) || severity != info.getSeverity()) continue;
                return info;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public Object getType(Annotation annotation) {
        AnnotationPreference preference;
        MarkerAnnotation markerAnnotation;
        IMarker marker;
        if (annotation instanceof MarkerAnnotation && (marker = (markerAnnotation = (MarkerAnnotation)annotation).getMarker()) != null && marker.exists() && (preference = this.getAnnotationPreference(marker)) != null) {
            return preference.getAnnotationType();
        }
        return UNKNOWN;
    }

    public boolean isMultiLine(Annotation annotation) {
        return true;
    }

    public boolean isTemporary(Annotation annotation) {
        return false;
    }
}

