/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.FindReplaceDialog;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IFindReplaceTargetExtension2;
import org.eclipse.ui.texteditor.TextUtilities;

class FindReplaceDialog
extends Dialog {
    private static final int HISTORY_SIZE = 5;
    private Point fLocation;
    private Point fIncrementalBaseLocation;
    private boolean fWrapInit = false;
    private boolean fCaseInit = false;
    private boolean fWholeWordInit = false;
    private boolean fForwardInit = true;
    private boolean fGlobalInit = true;
    private boolean fIncrementalInit = false;
    private List fFindHistory;
    private List fReplaceHistory;
    private IRegion fOldScope;
    private boolean fIsTargetEditable;
    private IFindReplaceTarget fTarget = null;
    private Shell fParentShell = null;
    private Shell fActiveShell;
    private ActivationListener fActivationListener = new ActivationListener();
    private ModifyListener fFindModifyListener = new FindModifyListener();
    private Label fReplaceLabel;
    private Label fStatusLabel;
    private Button fForwardRadioButton;
    private Button fGlobalRadioButton;
    private Button fSelectedRangeRadioButton;
    private Button fCaseCheckBox;
    private Button fWrapCheckBox;
    private Button fWholeWordCheckBox;
    private Button fIncrementalCheckBox;
    private Button fReplaceSelectionButton;
    private Button fReplaceFindButton;
    private Button fFindNextButton;
    private Button fReplaceAllButton;
    private Combo fFindField;
    private Combo fReplaceField;
    private Rectangle fDialogPositionInit = null;
    private IDialogSettings fDialogSettings;
    static /* synthetic */ Class class$0;

    public FindReplaceDialog(Shell parentShell) {
        super(parentShell);
        this.fFindHistory = new ArrayList(4);
        this.fReplaceHistory = new ArrayList(4);
        this.readConfiguration();
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }

    private boolean okToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        if (this.fLocation != null) {
            shell.setLocation(this.fLocation);
        }
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ui.find_replace_dialog_context");
        this.updateCombo(this.fFindField, this.fFindHistory);
        this.updateCombo(this.fReplaceField, this.fReplaceHistory);
        this.initFindStringFromSelection();
        if (this.fDialogPositionInit != null) {
            shell.setBounds(this.fDialogPositionInit);
        }
        shell.setText(EditorMessages.getString("FindReplace.title"));
    }

    private Composite createButtonSection(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = -2;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        this.fFindNextButton = this.makeButton(panel, "FindReplace.FindNextButton.label", 102, true, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.isIncrementalSearch()) {
                    FindReplaceDialog.this.initIncrementalBaseLocation();
                }
                FindReplaceDialog.this.performSearch();
                FindReplaceDialog.this.updateFindHistory();
                FindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fFindNextButton, 4, true, 4, false);
        this.fReplaceFindButton = this.makeButton(panel, "FindReplace.ReplaceFindButton.label", 103, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performReplaceSelection();
                FindReplaceDialog.this.performSearch();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.fReplaceFindButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceFindButton, 4, true, 4, false);
        this.fReplaceSelectionButton = this.makeButton(panel, "FindReplace.ReplaceSelectionButton.label", 104, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performReplaceSelection();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceSelectionButton, 4, true, 4, false);
        this.fReplaceAllButton = this.makeButton(panel, "FindReplace.ReplaceAllButton.label", 105, false, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performReplaceAll();
                FindReplaceDialog.this.updateFindAndReplaceHistory();
                FindReplaceDialog.this.fFindNextButton.setFocus();
            }
        });
        this.setGridData((Control)this.fReplaceAllButton, 4, true, 4, false);
        this.fReplaceAllButton.setEnabled(this.isEditable());
        return panel;
    }

    private Composite createConfigPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Composite directionGroup = this.createDirectionGroup(panel);
        this.setGridData((Control)directionGroup, 4, true, 4, false);
        Composite scopeGroup = this.createScopeGroup(panel);
        this.setGridData((Control)scopeGroup, 4, true, 4, false);
        Composite optionsGroup = this.createOptionsGroup(panel);
        this.setGridData((Control)optionsGroup, 4, true, 4, false);
        GridData data = (GridData)optionsGroup.getLayoutData();
        data.horizontalSpan = 2;
        optionsGroup.setLayoutData((Object)data);
        return panel;
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        Composite inputPanel = this.createInputPanel(panel);
        this.setGridData((Control)inputPanel, 4, true, 2, false);
        Composite configPanel = this.createConfigPanel(panel);
        this.setGridData((Control)configPanel, 4, true, 2, true);
        Composite buttonPanelB = this.createButtonSection(panel);
        this.setGridData((Control)buttonPanelB, 4, true, 2, false);
        Composite statusBar = this.createStatusAndCloseButton(panel);
        this.setGridData((Control)statusBar, 4, true, 2, false);
        this.updateButtonState();
        Dialog.applyDialogFont((Control)panel);
        return panel;
    }

    private Composite createDirectionGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(EditorMessages.getString("FindReplace.Direction"));
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.isIncrementalSearch()) {
                    FindReplaceDialog.this.initIncrementalBaseLocation();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fForwardRadioButton = new Button((Composite)group, 16400);
        this.fForwardRadioButton.setText(EditorMessages.getString("FindReplace.ForwardRadioButton.label"));
        this.setGridData((Control)this.fForwardRadioButton, 1, false, 2, false);
        this.fForwardRadioButton.addSelectionListener(selectionListener);
        Button backwardRadioButton = new Button((Composite)group, 16400);
        backwardRadioButton.setText(EditorMessages.getString("FindReplace.BackwardRadioButton.label"));
        this.setGridData((Control)backwardRadioButton, 1, false, 2, false);
        backwardRadioButton.addSelectionListener(selectionListener);
        backwardRadioButton.setSelection(!this.fForwardInit);
        this.fForwardRadioButton.setSelection(this.fForwardInit);
        return panel;
    }

    private Composite createScopeGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(EditorMessages.getString("FindReplace.Scope"));
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        this.fGlobalRadioButton = new Button((Composite)group, 16400);
        this.fGlobalRadioButton.setText(EditorMessages.getString("FindReplace.GlobalRadioButton.label"));
        this.setGridData((Control)this.fGlobalRadioButton, 1, false, 2, false);
        this.fGlobalRadioButton.setSelection(this.fGlobalInit);
        this.fGlobalRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FindReplaceDialog.this.fGlobalRadioButton.getSelection()) {
                    return;
                }
                FindReplaceDialog.this.useSelectedLines(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fSelectedRangeRadioButton = new Button((Composite)group, 16400);
        this.fSelectedRangeRadioButton.setText(EditorMessages.getString("FindReplace.SelectedRangeRadioButton.label"));
        this.setGridData((Control)this.fSelectedRangeRadioButton, 1, false, 2, false);
        this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
        this.fSelectedRangeRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FindReplaceDialog.this.fSelectedRangeRadioButton.getSelection()) {
                    return;
                }
                FindReplaceDialog.this.useSelectedLines(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return panel;
    }

    private void useSelectedLines(boolean selectedLines) {
        if (this.isIncrementalSearch()) {
            this.initIncrementalBaseLocation();
        }
        if (this.fTarget == null || !(this.fTarget instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension extensionTarget = (IFindReplaceTargetExtension)this.fTarget;
        if (selectedLines) {
            IRegion scope;
            if (this.fOldScope == null) {
                Point lineSelection = extensionTarget.getLineSelection();
                scope = new Region(lineSelection.x, lineSelection.y);
            } else {
                scope = this.fOldScope;
                this.fOldScope = null;
            }
            int offset = this.isForwardSearch() ? scope.getOffset() : scope.getOffset() + scope.getLength();
            extensionTarget.setSelection(offset, 0);
            extensionTarget.setScope(scope);
        } else {
            this.fOldScope = extensionTarget.getScope();
            extensionTarget.setScope(null);
        }
    }

    private Composite createInputPanel(Composite parent) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindReplaceDialog.this.updateButtonState();
            }
        };
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label findLabel = new Label(panel, 16384);
        findLabel.setText(EditorMessages.getString("FindReplace.Find.label"));
        this.setGridData((Control)findLabel, 1, false, 2, false);
        this.fFindField = new Combo(panel, 2052);
        this.setGridData((Control)this.fFindField, 4, true, 2, false);
        this.fFindField.addModifyListener(this.fFindModifyListener);
        this.fReplaceLabel = new Label(panel, 16384);
        this.fReplaceLabel.setText(EditorMessages.getString("FindReplace.Replace.label"));
        this.setGridData((Control)this.fReplaceLabel, 1, false, 2, false);
        this.fReplaceField = new Combo(panel, 2052);
        this.setGridData((Control)this.fReplaceField, 4, true, 2, false);
        this.fReplaceField.addModifyListener(listener);
        return panel;
    }

    private Composite createOptionsGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 32);
        group.setText(EditorMessages.getString("FindReplace.Options"));
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        groupLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(1808));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fCaseCheckBox = new Button((Composite)group, 16416);
        this.fCaseCheckBox.setText(EditorMessages.getString("FindReplace.CaseCheckBox.label"));
        this.setGridData((Control)this.fCaseCheckBox, 1, false, 2, false);
        this.fCaseCheckBox.setSelection(this.fCaseInit);
        this.fCaseCheckBox.addSelectionListener(selectionListener);
        this.fWrapCheckBox = new Button((Composite)group, 16416);
        this.fWrapCheckBox.setText(EditorMessages.getString("FindReplace.WrapCheckBox.label"));
        this.setGridData((Control)this.fWrapCheckBox, 1, false, 2, false);
        this.fWrapCheckBox.setSelection(this.fWrapInit);
        this.fWrapCheckBox.addSelectionListener(selectionListener);
        this.fWholeWordCheckBox = new Button((Composite)group, 16416);
        this.fWholeWordCheckBox.setText(EditorMessages.getString("FindReplace.WholeWordCheckBox.label"));
        this.setGridData((Control)this.fWholeWordCheckBox, 1, false, 2, false);
        this.fWholeWordCheckBox.setSelection(this.fWholeWordInit);
        this.fWholeWordCheckBox.addSelectionListener(selectionListener);
        this.fIncrementalCheckBox = new Button((Composite)group, 16416);
        this.fIncrementalCheckBox.setText(EditorMessages.getString("FindReplace.IncrementalCheckBox.label"));
        this.setGridData((Control)this.fIncrementalCheckBox, 1, false, 2, false);
        this.fIncrementalCheckBox.setSelection(this.fIncrementalInit);
        this.fIncrementalCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (FindReplaceDialog.this.isIncrementalSearch()) {
                    FindReplaceDialog.this.initIncrementalBaseLocation();
                }
                FindReplaceDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return panel;
    }

    private Composite createStatusAndCloseButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        this.fStatusLabel = new Label(panel, 16384);
        this.setGridData((Control)this.fStatusLabel, 4, true, 2, false);
        String label = EditorMessages.getString("FindReplace.CloseButton.label");
        Button closeButton = this.createButton(panel, 101, label, false);
        this.setGridData((Control)closeButton, 3, false, 3, false);
        return panel;
    }

    protected void buttonPressed(int buttonID) {
        if (buttonID == 101) {
            this.close();
        }
    }

    private int findIndex(String findString, int startPosition, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord) {
        if (forwardSearch) {
            if (wrapSearch) {
                int index = this.fTarget.findAndSelect(startPosition, findString, true, caseSensitive, wholeWord);
                if (index == -1) {
                    index = this.fTarget.findAndSelect(-1, findString, true, caseSensitive, wholeWord);
                }
                return index;
            }
            return this.fTarget.findAndSelect(startPosition, findString, true, caseSensitive, wholeWord);
        }
        if (wrapSearch) {
            int index = this.fTarget.findAndSelect(startPosition - 1, findString, false, caseSensitive, wholeWord);
            if (index == -1) {
                index = this.fTarget.findAndSelect(-1, findString, false, caseSensitive, wholeWord);
            }
            return index;
        }
        return this.fTarget.findAndSelect(startPosition - 1, findString, false, caseSensitive, wholeWord);
    }

    private boolean findNext(String findString, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean incremental, boolean global) {
        int index;
        if (this.fTarget == null) {
            return false;
        }
        Point r = this.fTarget.getSelection();
        int findReplacePosition = r.x;
        if (forwardSearch) {
            findReplacePosition += r.y;
        }
        if (incremental) {
            int n = findReplacePosition = forwardSearch ? this.fIncrementalBaseLocation.x + this.fIncrementalBaseLocation.y : this.fIncrementalBaseLocation.x;
        }
        return (index = this.findIndex(findString, findReplacePosition, forwardSearch, caseSensitive, wrapSearch, wholeWord)) != -1;
    }

    private Rectangle getDialogBoundaries() {
        if (this.okToUse((Control)this.getShell())) {
            return this.getShell().getBounds();
        }
        return this.fDialogPositionInit;
    }

    private List getFindHistory() {
        return this.fFindHistory;
    }

    private String getFindString() {
        if (this.okToUse((Control)this.fFindField)) {
            return this.fFindField.getText();
        }
        return "";
    }

    private List getReplaceHistory() {
        return this.fReplaceHistory;
    }

    private String getReplaceString() {
        if (this.okToUse((Control)this.fReplaceField)) {
            return this.fReplaceField.getText();
        }
        return "";
    }

    private String getSelectionString() {
        String selection = this.fTarget.getSelectionText();
        if (selection != null && selection.length() > 0) {
            int[] info = TextUtilities.indexOf(TextUtilities.fgDelimiters, selection, 0);
            if (info[0] > 0) {
                return selection.substring(0, info[0]);
            }
            if (info[0] == -1) {
                return selection;
            }
        }
        return null;
    }

    public boolean close() {
        this.handleDialogClose();
        return super.close();
    }

    private void handleDialogClose() {
        if (this.fParentShell != null) {
            this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            this.fParentShell = null;
        }
        this.getShell().removeShellListener((ShellListener)this.fActivationListener);
        this.storeSettings();
        if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
            ((IFindReplaceTargetExtension)this.fTarget).endSession();
        }
        this.fActiveShell = null;
        this.fTarget = null;
    }

    private void storeSettings() {
        this.fDialogPositionInit = this.getDialogBoundaries();
        this.fWrapInit = this.isWrapSearch();
        this.fWholeWordInit = this.isWholeWordSearch();
        this.fCaseInit = this.isCaseSensitiveSearch();
        this.fIncrementalInit = this.isIncrementalSearch();
        this.fForwardInit = this.isForwardSearch();
        this.writeConfiguration();
    }

    private void initFindStringFromSelection() {
        if (this.fTarget != null && this.okToUse((Control)this.fFindField)) {
            String selection = this.getSelectionString();
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            if (selection != null) {
                this.fFindField.setText(selection);
                if (!selection.equals(this.fTarget.getSelectionText())) {
                    this.useSelectedLines(true);
                    this.fGlobalRadioButton.setSelection(false);
                    this.fSelectedRangeRadioButton.setSelection(true);
                }
            } else if ("".equals(this.fFindField.getText())) {
                if (this.fFindHistory.size() > 0) {
                    this.fFindField.setText((String)this.fFindHistory.get(0));
                } else {
                    this.fFindField.setText("");
                }
            }
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void initIncrementalBaseLocation() {
        this.fIncrementalBaseLocation = this.fTarget != null && this.isIncrementalSearch() ? this.fTarget.getSelection() : new Point(0, 0);
    }

    private boolean isCaseSensitiveSearch() {
        if (this.okToUse((Control)this.fCaseCheckBox)) {
            return this.fCaseCheckBox.getSelection();
        }
        return this.fCaseInit;
    }

    private boolean isForwardSearch() {
        if (this.okToUse((Control)this.fForwardRadioButton)) {
            return this.fForwardRadioButton.getSelection();
        }
        return this.fForwardInit;
    }

    private boolean isGlobalSearch() {
        if (this.okToUse((Control)this.fGlobalRadioButton)) {
            return this.fGlobalRadioButton.getSelection();
        }
        return this.fGlobalInit;
    }

    private boolean isWholeWordSearch() {
        if (this.okToUse((Control)this.fWholeWordCheckBox)) {
            return this.fWholeWordCheckBox.getSelection();
        }
        return this.fWholeWordInit;
    }

    private boolean isWrapSearch() {
        if (this.okToUse((Control)this.fWrapCheckBox)) {
            return this.fWrapCheckBox.getSelection();
        }
        return this.fWrapInit;
    }

    private boolean isIncrementalSearch() {
        if (this.okToUse((Control)this.fIncrementalCheckBox)) {
            return this.fIncrementalCheckBox.getSelection();
        }
        return this.fIncrementalInit;
    }

    private Button makeButton(Composite parent, String key, int id, boolean dfltButton, SelectionListener listener) {
        String label = EditorMessages.getString(key);
        Button b = this.createButton(parent, id, label, dfltButton);
        b.addSelectionListener(listener);
        return b;
    }

    private IEditorStatusLine getStatusLineManager() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IWorkbenchWindow window = plugin.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IEditorStatusLine)editor.getAdapter((Class)clazz);
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        IEditorStatusLine statusLine = this.getStatusLineManager();
        if (statusLine != null) {
            statusLine.setMessage(error, message, null);
        }
        if (error) {
            this.getShell().getDisplay().beep();
        }
    }

    private void statusError(String message) {
        this.statusMessage(true, message);
    }

    private void statusMessage(String message) {
        this.statusMessage(false, message);
    }

    private void performReplaceAll() {
        int replaceCount = 0;
        String replaceString = this.getReplaceString();
        String findString = this.getFindString();
        if (findString != null && findString.length() > 0) {
            class ReplaceAllRunnable
            implements Runnable {
                public int replaceCount;
                final /* synthetic */ FindReplaceDialog this$0;
                private final /* synthetic */ String val$findString;
                private final /* synthetic */ String val$replaceString;

                ReplaceAllRunnable(FindReplaceDialog findReplaceDialog, String string, String string2) {
                    this.this$0 = findReplaceDialog;
                    this.val$findString = string;
                    this.val$replaceString = string2;
                }

                public void run() {
                    this.replaceCount = FindReplaceDialog.access$29(this.this$0, this.val$findString, this.val$replaceString == null ? "" : this.val$replaceString, FindReplaceDialog.access$14(this.this$0), FindReplaceDialog.access$16(this.this$0), FindReplaceDialog.access$27(this.this$0), FindReplaceDialog.access$17(this.this$0), FindReplaceDialog.access$28(this.this$0));
                }
            }
            ReplaceAllRunnable runnable = new ReplaceAllRunnable(this, findString, replaceString);
            BusyIndicator.showWhile((Display)this.fActiveShell.getDisplay(), (Runnable)runnable);
            replaceCount = runnable.replaceCount;
            if (replaceCount != 0) {
                if (replaceCount == 1) {
                    this.statusMessage(EditorMessages.getString("FindReplace.Status.replacement.label"));
                } else {
                    String msg = EditorMessages.getString("FindReplace.Status.replacements.label");
                    msg = MessageFormat.format(msg, String.valueOf(replaceCount));
                    this.statusMessage(msg);
                }
            } else {
                this.statusError(EditorMessages.getString("FindReplace.Status.noMatch.label"));
            }
        }
        this.updateButtonState();
    }

    private boolean validateTargetState() {
        IFindReplaceTargetExtension2 extension;
        if (this.fTarget instanceof IFindReplaceTargetExtension2 && !(extension = (IFindReplaceTargetExtension2)this.fTarget).validateTargetState()) {
            this.statusError(EditorMessages.getString("FindReplaceDialog.read_only"));
            this.updateButtonState();
            return false;
        }
        return this.isEditable();
    }

    private void performReplaceSelection() {
        if (!this.validateTargetState()) {
            return;
        }
        String replaceString = this.getReplaceString();
        if (replaceString == null) {
            replaceString = "";
        }
        this.fTarget.replaceSelection(replaceString);
        this.updateButtonState();
    }

    private void performSearch() {
        String findString = this.getFindString();
        if (findString != null && findString.length() > 0) {
            boolean somethingFound = this.findNext(findString, this.isForwardSearch(), this.isCaseSensitiveSearch(), this.isWrapSearch(), this.isWholeWordSearch(), this.isIncrementalSearch(), this.isGlobalSearch());
            if (somethingFound) {
                this.statusMessage("");
            } else {
                this.statusError(EditorMessages.getString("FindReplace.Status.noMatch.label"));
            }
        }
        this.updateButtonState();
    }

    private int replaceAll(String findString, String replaceString, boolean forwardSearch, boolean caseSensitive, boolean wrapSearch, boolean wholeWord, boolean global) {
        int replaceCount;
        block12: {
            replaceCount = 0;
            int findReplacePosition = 0;
            if (wrapSearch) {
                findReplacePosition = 0;
                forwardSearch = true;
            } else if (this.fTarget.getSelectionText() != null) {
                Point selection = this.fTarget.getSelection();
                findReplacePosition = selection.x;
            }
            if (!this.validateTargetState()) {
                return replaceCount;
            }
            if (this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).setReplaceAllMode(true);
            }
            try {
                int index = 0;
                while (index != -1) {
                    index = this.fTarget.findAndSelect(findReplacePosition, findString, forwardSearch, caseSensitive, wholeWord);
                    if (index == -1) continue;
                    this.fTarget.replaceSelection(replaceString);
                    ++replaceCount;
                    if (forwardSearch) {
                        findReplacePosition = index + replaceString.length();
                        continue;
                    }
                    findReplacePosition = index - replaceString.length();
                    if (findReplacePosition != -1) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (this.fTarget instanceof IFindReplaceTargetExtension) {
                    ((IFindReplaceTargetExtension)this.fTarget).setReplaceAllMode(false);
                }
                throw throwable;
            }
            Object var11_14 = null;
            if (!(this.fTarget instanceof IFindReplaceTargetExtension)) break block12;
            ((IFindReplaceTargetExtension)this.fTarget).setReplaceAllMode(false);
        }
        return replaceCount;
    }

    private void setGridData(Control component, int horizontalAlignment, boolean grabExcessHorizontalSpace, int verticalAlignment, boolean grabExcessVerticalSpace) {
        GridData gd = new GridData();
        gd.horizontalAlignment = horizontalAlignment;
        gd.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        gd.verticalAlignment = verticalAlignment;
        gd.grabExcessVerticalSpace = grabExcessVerticalSpace;
        component.setLayoutData((Object)gd);
    }

    private void updateButtonState() {
        if (this.okToUse((Control)this.getShell()) && this.okToUse((Control)this.fFindNextButton)) {
            String selectedText = null;
            if (this.fTarget != null) {
                selectedText = this.fTarget.getSelectionText();
            }
            boolean selection = selectedText != null && selectedText.length() > 0;
            boolean enable = this.fTarget != null && (this.fActiveShell == this.fParentShell || this.fActiveShell == this.getShell());
            String str = this.getFindString();
            boolean findString = str != null && str.length() > 0;
            this.fFindNextButton.setEnabled(enable && findString);
            this.fReplaceSelectionButton.setEnabled(enable && this.isEditable() && selection);
            this.fReplaceFindButton.setEnabled(enable && this.isEditable() && findString && selection);
            this.fReplaceAllButton.setEnabled(enable && this.isEditable() && findString);
        }
    }

    private void updateCombo(Combo combo, List content) {
        combo.removeAll();
        int i = 0;
        while (i < content.size()) {
            combo.add(content.get(i).toString());
            ++i;
        }
    }

    private void updateFindAndReplaceHistory() {
        this.updateFindHistory();
        if (this.okToUse((Control)this.fReplaceField)) {
            this.updateHistory(this.fReplaceField, this.fReplaceHistory);
        }
    }

    private void updateFindHistory() {
        if (this.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener(this.fFindModifyListener);
            this.updateHistory(this.fFindField, this.fFindHistory);
            this.fFindField.addModifyListener(this.fFindModifyListener);
        }
    }

    private void updateHistory(Combo combo, List history) {
        String findString = combo.getText();
        int index = history.indexOf(findString);
        if (index != 0) {
            if (index != -1) {
                history.remove(index);
            }
            history.add(0, findString);
            this.updateCombo(combo, history);
            combo.setText(findString);
        }
    }

    private boolean isEditable() {
        boolean isEditable;
        boolean bl = isEditable = this.fTarget == null ? false : this.fTarget.isEditable();
        return this.fIsTargetEditable && isEditable;
    }

    public void updateTarget(IFindReplaceTarget target, boolean isTargetEditable) {
        this.fIsTargetEditable = isTargetEditable;
        if (target != this.fTarget) {
            if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).endSession();
            }
            this.fTarget = target;
            if (this.fTarget != null && this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.fTarget).beginSession();
                this.fGlobalInit = true;
                this.fGlobalRadioButton.setSelection(this.fGlobalInit);
                this.fSelectedRangeRadioButton.setSelection(!this.fGlobalInit);
            }
        }
        if (this.okToUse((Control)this.fReplaceLabel)) {
            this.fReplaceLabel.setEnabled(this.isEditable());
            this.fReplaceField.setEnabled(this.isEditable());
            this.initFindStringFromSelection();
            this.initIncrementalBaseLocation();
            this.updateButtonState();
        }
    }

    public void setParentShell(Shell shell) {
        if (shell != this.fParentShell) {
            if (this.fParentShell != null) {
                this.fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fParentShell = shell;
            this.fParentShell.addShellListener((ShellListener)this.fActivationListener);
        }
        this.fActiveShell = shell;
    }

    private IDialogSettings getDialogSettings() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings settings = plugin.getDialogSettings();
        this.fDialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        String[] replaceHistory;
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        this.fWrapInit = s.getBoolean("wrap");
        this.fCaseInit = s.getBoolean("casesensitive");
        this.fWholeWordInit = s.getBoolean("wholeword");
        this.fIncrementalInit = s.getBoolean("incremental");
        String[] findHistory = s.getArray("findhistory");
        if (findHistory != null) {
            List history = this.getFindHistory();
            history.clear();
            int i = 0;
            while (i < findHistory.length) {
                history.add(findHistory[i]);
                ++i;
            }
        }
        if ((replaceHistory = s.getArray("replacehistory")) != null) {
            List history = this.getReplaceHistory();
            history.clear();
            int i = 0;
            while (i < replaceHistory.length) {
                history.add(replaceHistory[i]);
                ++i;
            }
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        s.put("wrap", this.fWrapInit);
        s.put("casesensitive", this.fCaseInit);
        s.put("wholeword", this.fWholeWordInit);
        s.put("incremental", this.fIncrementalInit);
        List history = this.getFindHistory();
        while (history.size() > 8) {
            history.remove(8);
        }
        String[] names = new String[history.size()];
        history.toArray(names);
        s.put("findhistory", names);
        history = this.getReplaceHistory();
        while (history.size() > 8) {
            history.remove(8);
        }
        names = new String[history.size()];
        history.toArray(names);
        s.put("replacehistory", names);
    }

    static /* synthetic */ boolean access$27(FindReplaceDialog findReplaceDialog) {
        return findReplaceDialog.isWrapSearch();
    }

    static /* synthetic */ boolean access$28(FindReplaceDialog findReplaceDialog) {
        return findReplaceDialog.isGlobalSearch();
    }

    static /* synthetic */ int access$29(FindReplaceDialog findReplaceDialog, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return findReplaceDialog.replaceAll(string, string2, bl, bl2, bl3, bl4, bl5);
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            String oldText = FindReplaceDialog.this.fFindField.getText();
            ArrayList oldList = new ArrayList();
            oldList.addAll(FindReplaceDialog.this.fFindHistory);
            FindReplaceDialog.this.readConfiguration();
            FindReplaceDialog.this.updateCombo(FindReplaceDialog.this.fFindField, FindReplaceDialog.this.fFindHistory);
            FindReplaceDialog.this.fFindField.removeModifyListener(FindReplaceDialog.this.fFindModifyListener);
            if (!FindReplaceDialog.this.fFindHistory.equals(oldList) && !FindReplaceDialog.this.fFindHistory.isEmpty()) {
                FindReplaceDialog.this.fFindField.setText((String)FindReplaceDialog.this.fFindHistory.get(0));
            } else {
                FindReplaceDialog.this.fFindField.setText(oldText);
            }
            FindReplaceDialog.this.fFindField.addModifyListener(FindReplaceDialog.this.fFindModifyListener);
            FindReplaceDialog.this.fActiveShell = (Shell)e.widget;
            FindReplaceDialog.this.updateButtonState();
            if (FindReplaceDialog.this.getShell() == FindReplaceDialog.this.fActiveShell && !FindReplaceDialog.this.fFindField.isDisposed()) {
                FindReplaceDialog.this.fFindField.setFocus();
            }
        }

        public void shellDeactivated(ShellEvent e) {
            FindReplaceDialog.this.storeSettings();
            FindReplaceDialog.this.fGlobalRadioButton.setSelection(true);
            FindReplaceDialog.this.fSelectedRangeRadioButton.setSelection(false);
            if (FindReplaceDialog.this.fTarget != null && FindReplaceDialog.this.fTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)FindReplaceDialog.this.fTarget).setScope(null);
            }
            FindReplaceDialog.this.fOldScope = null;
            FindReplaceDialog.this.fActiveShell = null;
            FindReplaceDialog.this.updateButtonState();
        }
    }

    private class FindModifyListener
    implements ModifyListener {
        FindModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (FindReplaceDialog.this.isIncrementalSearch()) {
                if (FindReplaceDialog.this.fFindField.getText().equals("") && FindReplaceDialog.this.fTarget != null) {
                    int offset = FindReplaceDialog.this.isForwardSearch() ? ((FindReplaceDialog)FindReplaceDialog.this).fIncrementalBaseLocation.x + ((FindReplaceDialog)FindReplaceDialog.this).fIncrementalBaseLocation.y : ((FindReplaceDialog)FindReplaceDialog.this).fIncrementalBaseLocation.x;
                    FindReplaceDialog.this.fTarget.findAndSelect(offset, "", FindReplaceDialog.this.isForwardSearch(), FindReplaceDialog.this.isCaseSensitiveSearch(), FindReplaceDialog.this.isWholeWordSearch());
                } else {
                    FindReplaceDialog.this.performSearch();
                }
            }
            FindReplaceDialog.this.updateButtonState();
        }
    }
}

