/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.IMarkRegionTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.EditorMessages;

public class MarkRegionTarget
implements IMarkRegionTarget {
    private final ITextViewer fViewer;
    private final IStatusLineManager fStatusLine;

    public MarkRegionTarget(ITextViewer viewer, IStatusLineManager manager) {
        this.fViewer = viewer;
        this.fStatusLine = manager;
    }

    public void setMarkAtCursor(boolean set) {
        if (!(this.fViewer instanceof ITextViewerExtension)) {
            return;
        }
        ITextViewerExtension viewerExtension = (ITextViewerExtension)this.fViewer;
        if (set) {
            Point selection = this.fViewer.getSelectedRange();
            viewerExtension.setMark(selection.x);
            this.fStatusLine.setErrorMessage("");
            this.fStatusLine.setMessage(EditorMessages.getString("Editor.mark.status.message.mark.set"));
        } else {
            viewerExtension.setMark(-1);
            this.fStatusLine.setErrorMessage("");
            this.fStatusLine.setMessage(EditorMessages.getString("Editor.mark.status.message.mark.cleared"));
        }
    }

    public void swapMarkAndCursor() {
        if (!(this.fViewer instanceof ITextViewerExtension)) {
            return;
        }
        ITextViewerExtension viewerExtension = (ITextViewerExtension)this.fViewer;
        int markPosition = viewerExtension.getMark();
        if (markPosition == -1) {
            this.fStatusLine.setErrorMessage(EditorMessages.getString("MarkRegionTarget.markNotSet"));
            this.fStatusLine.setMessage("");
            return;
        }
        if (!MarkRegionTarget.isVisible(this.fViewer, markPosition)) {
            this.fStatusLine.setErrorMessage(EditorMessages.getString("MarkRegionTarget.markNotVisible"));
            this.fStatusLine.setMessage("");
            return;
        }
        Point selection = this.fViewer.getSelectedRange();
        viewerExtension.setMark(selection.x);
        this.fViewer.setSelectedRange(markPosition, 0);
        this.fViewer.revealRange(markPosition, 0);
        this.fStatusLine.setErrorMessage("");
        this.fStatusLine.setMessage(EditorMessages.getString("Editor.mark.status.message.mark.swapped"));
    }

    protected static final boolean isVisible(ITextViewer viewer, int offset) {
        if (viewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)viewer;
            return extension.modelOffset2WidgetOffset(offset) >= 0;
        }
        IRegion region = viewer.getVisibleRegion();
        int vOffset = region.getOffset();
        return vOffset <= offset && offset <= vOffset + region.getLength();
    }
}

