/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.AnnotationPreference;

public class MarkerAnnotationPreferences {
    private List fPreferences;

    public List getAnnotationPreferences() {
        if (this.fPreferences == null) {
            this.initialize();
        }
        return this.fPreferences;
    }

    private void initialize() {
        this.fPreferences = new ArrayList(2);
        IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.ui.workbench.texteditor", "markerAnnotationSpecification");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                AnnotationPreference spec = this.createSpec(elements[i]);
                if (spec != null) {
                    this.fPreferences.add(this.createSpec(elements[i]));
                }
                ++i;
            }
        }
    }

    private AnnotationPreference createSpec(IConfigurationElement element) {
        AnnotationPreference info = new AnnotationPreference();
        String s = element.getAttribute("annotationType");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        info.setAnnotationType(s);
        s = element.getAttribute("label");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        info.setPreferenceLabel(s);
        s = element.getAttribute("markerType");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        info.setMarkerType(s);
        int i = 0;
        s = element.getAttribute("markerSeverity");
        if (s != null && s.trim().length() > 0) {
            i = StringConverter.asInt((String)s, (int)0);
        }
        info.setSeverity(i);
        s = element.getAttribute("textPreferenceKey");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        info.setTextPreferenceKey(s);
        boolean b = false;
        s = element.getAttribute("textPreferenceValue");
        if (s != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
        }
        info.setTextPreferenceValue(b);
        s = element.getAttribute("overviewRulerPreferenceKey");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        info.setOverviewRulerPreferenceKey(s);
        b = false;
        s = element.getAttribute("overviewRulerPreferenceValue");
        if (s != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
        }
        info.setOverviewRulerPreferenceValue(b);
        s = element.getAttribute("colorPreferenceKey");
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        info.setColorPreferenceKey(s);
        RGB rgb = null;
        s = element.getAttribute("colorPreferenceValue");
        if (s != null && s.trim().length() > 0) {
            rgb = StringConverter.asRGB((String)s);
        }
        info.setColorPreferenceValue(rgb == null ? new RGB(0, 0, 0) : rgb);
        i = 0;
        s = element.getAttribute("presentationLayer");
        if (s != null && s.trim().length() > 0) {
            i = StringConverter.asInt((String)s, (int)0);
        }
        info.setPresentationLayer(i);
        b = false;
        s = element.getAttribute("contributesToHeader");
        if (s != null && s.trim().length() > 0) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
        }
        info.setContributesToHeader(b);
        return info;
    }
}

