/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public final class MarkerUtilities {
    private MarkerUtilities() {
    }

    public static int getCharEnd(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "charEnd", -1);
    }

    public static int getCharStart(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "charStart", -1);
    }

    private static int getIntAttribute(IMarker marker, String attributeName, int defaultValue) {
        if (marker.exists()) {
            return marker.getAttribute(attributeName, defaultValue);
        }
        return defaultValue;
    }

    public static int getLineNumber(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "lineNumber", -1);
    }

    public static int getPriority(IMarker marker) {
        return MarkerUtilities.getIntAttribute(marker, "priority", 1);
    }

    private static void handleCoreException(CoreException e) {
        Platform.getPlugin((String)"org.eclipse.ui").getLog().log(e.getStatus());
    }

    public static boolean isMarkerType(IMarker marker, String type) {
        try {
            return marker.exists() && marker.isSubtypeOf(type);
        }
        catch (CoreException e) {
            MarkerUtilities.handleCoreException(e);
            return false;
        }
    }

    public static void setCharEnd(IMarker marker, int charEnd) {
        MarkerUtilities.setIntAttribute(marker, "charEnd", charEnd);
    }

    public static void setCharEnd(Map map, int charEnd) {
        map.put("charEnd", new Integer(charEnd));
    }

    public static void setCharStart(IMarker marker, int charStart) {
        MarkerUtilities.setIntAttribute(marker, "charStart", charStart);
    }

    public static void setCharStart(Map map, int charStart) {
        map.put("charStart", new Integer(charStart));
    }

    private static void setIntAttribute(IMarker marker, String attributeName, int value) {
        try {
            if (marker.exists()) {
                marker.setAttribute(attributeName, value);
            }
        }
        catch (CoreException e) {
            MarkerUtilities.handleCoreException(e);
        }
    }

    public static void setLineNumber(IMarker marker, int lineNum) {
        MarkerUtilities.setIntAttribute(marker, "lineNumber", lineNum);
    }

    public static void setLineNumber(Map map, int lineNum) {
        map.put("lineNumber", new Integer(lineNum));
    }

    public static void setMessage(Map map, String message) {
        map.put("message", message);
    }

    public static void createMarker(final IResource resource, final Map attributes, final String markerType) throws CoreException {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(markerType);
                marker.setAttributes(attributes);
            }
        };
        resource.getWorkspace().run(r, null);
    }
}

