/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.EditorMessages;

public class ResourceMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IWorkspace fWorkspace;
    private IResource fResource;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private IResourceDeltaVisitor fResourceDeltaVisitor = new ResourceDeltaVisitor();

    public ResourceMarkerAnnotationModel(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.fResource = resource;
        this.fWorkspace = resource.getWorkspace();
    }

    protected boolean isAcceptable(IMarker marker) {
        return marker != null && this.fResource.equals((Object)marker.getResource());
    }

    protected void update(IMarkerDelta[] markerDeltas) {
        if (markerDeltas.length == 0) {
            return;
        }
        int i = 0;
        while (i < markerDeltas.length) {
            IMarkerDelta delta = markerDeltas[i];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(delta.getMarker());
                }
            }
            ++i;
        }
        this.fireModelChanged();
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, null);
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        return this.fResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
    }

    protected IResource getResource() {
        return this.fResource;
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null) {
                    delta.accept(ResourceMarkerAnnotationModel.this.fResourceDeltaVisitor);
                }
            }
            catch (CoreException x) {
                ResourceMarkerAnnotationModel.this.handleCoreException(x, EditorMessages.getString("ResourceMarkerAnnotationModel.resourceChanged"));
            }
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null && ResourceMarkerAnnotationModel.this.fResource.equals((Object)delta.getResource())) {
                ResourceMarkerAnnotationModel.this.update(delta.getMarkerDeltas());
                return false;
            }
            return true;
        }
    }
}

