/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.validation;

import com.ibm.etools.validation.IMessage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Message
implements IMessage {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private String id = null;
    private String[] params = null;
    private int severity = -1;
    private Object targetObject = null;
    private String bundleName = null;
    private String groupName = null;
    private int lineNumber = 0;
    private int length = -1;
    private int offset = -1;

    public Message() {
    }

    public Message(String string, int n, String string2) {
        this(string, n, string2, null, null);
    }

    public Message(String string, int n, String string2, String[] stringArray) {
        this(string, n, string2, stringArray, null);
    }

    public Message(String string, int n, String string2, String[] stringArray, Object object) {
        this.bundleName = string;
        this.severity = n;
        this.id = string2;
        this.params = stringArray;
        this.targetObject = object;
    }

    public ResourceBundle getBundle(Locale locale, ClassLoader classLoader) {
        ResourceBundle resourceBundle;
        block3: {
            resourceBundle = null;
            try {
                if (classLoader == null) {
                    resourceBundle = ResourceBundle.getBundle(this.getBundleName(), locale);
                    break block3;
                }
                resourceBundle = ResourceBundle.getBundle(this.getBundleName(), locale, classLoader);
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
            }
        }
        return resourceBundle;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public int getLineNo() {
        return this.lineNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public String[] getParams() {
        return this.params;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public String getText() {
        return this.getText(Locale.getDefault(), null);
    }

    public String getText(ClassLoader classLoader) {
        return this.getText(Locale.getDefault(), classLoader);
    }

    public String getText(Locale locale) {
        return this.getText(locale, null);
    }

    public String getText(Locale locale, ClassLoader classLoader) {
        String string = "";
        if (locale == null) {
            return string;
        }
        ResourceBundle resourceBundle = this.getBundle(locale, classLoader);
        if (resourceBundle == null) {
            return string;
        }
        try {
            string = resourceBundle.getString(this.getId());
            if (this.getParams() != null) {
                string = MessageFormat.format(string, this.getParams());
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getMessage());
            System.err.println(this.getId());
        }
        catch (NullPointerException nullPointerException) {
            System.err.println(nullPointerException.getMessage());
            System.err.println(this.getId());
        }
        return string;
    }

    public void setBundleName(String string) {
        this.bundleName = string;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setLength(int n) {
        if (n < 0) {
            n = -1;
        }
        this.length = n;
    }

    public void setLineNo(int n) {
        this.lineNumber = n < 0 ? 0 : n;
    }

    public void setOffset(int n) {
        if (n < 0) {
            n = -1;
        }
        this.offset = n;
    }

    public void setParams(String[] stringArray) {
        this.params = stringArray;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    public void setTargetObject(Object object) {
        this.targetObject = object;
    }
}

