/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdo.xmlmediator.impl;

import com.ibm.etools.wdo.DataObject;
import com.ibm.etools.wdo.datagraph.DataGraph;
import com.ibm.etools.wdo.datagraph.EDataGraph;
import com.ibm.etools.wdo.datagraph.WdoFactory;
import com.ibm.etools.wdo.datagraph.impl.WdoConfig;
import com.ibm.etools.wdo.xmlmediator.XMLMediator;
import com.ibm.etools.wdo.xmlmediator.impl.DataGraphResourceImpl;
import com.ibm.etools.wdo.xmlmediator.impl.DataGraphXMLHelperImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public class XMLMediatorImpl
implements XMLMediator {
    protected ResourceSet resourceSet;

    public XMLMediatorImpl() {
    }

    public XMLMediatorImpl(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = WdoFactory.eINSTANCE.createEDataGraphResourceSet();
        }
        return this.resourceSet;
    }

    protected DataGraph createDataGraph(EClass eClass) {
        WdoFactory wdoFactory = (WdoFactory)eClass.getEPackage().getEFactoryInstance();
        EDataGraph eDataGraph = wdoFactory.createEDataGraph(eClass, this.getResourceSet());
        return eDataGraph;
    }

    public DataGraph createDataGraph(String string, String string2) {
        EPackage ePackage = WdoConfig.getPackage((String)string, (ResourceSet)this.getResourceSet(), (boolean)true);
        EClass eClass = (EClass)ePackage.getEClassifier(string2);
        return this.createDataGraph(eClass);
    }

    public DataGraph load(String string, Map map) throws IOException {
        DataGraphResourceImpl dataGraphResourceImpl = new DataGraphResourceImpl(URI.createURI((String)string));
        this.getResourceSet().getResources().add(dataGraphResourceImpl);
        dataGraphResourceImpl.load(map);
        return this.processDataGraph(dataGraphResourceImpl);
    }

    public DataGraph load(InputStream inputStream, Map map) throws IOException {
        DataGraphResourceImpl dataGraphResourceImpl = new DataGraphResourceImpl(URI.createURI((String)""));
        this.getResourceSet().getResources().add(dataGraphResourceImpl);
        dataGraphResourceImpl.load(inputStream, map);
        return this.processDataGraph(dataGraphResourceImpl);
    }

    protected DataGraph processDataGraph(DataGraphResourceImpl dataGraphResourceImpl) {
        EClass eClass = dataGraphResourceImpl.getSchema();
        EDataGraph eDataGraph = (EDataGraph)this.createDataGraph(eClass);
        String string = dataGraphResourceImpl.getRootFeature();
        DataObject dataObject = (DataObject)dataGraphResourceImpl.getContents().get(0);
        eDataGraph.getDataObject().set(string, dataObject.get(string));
        eDataGraph.getEventLog().startLogging();
        eDataGraph.getEvents().addAll(dataGraphResourceImpl.getEvents());
        this.getResourceSet().getResources().remove((Object)dataGraphResourceImpl);
        dataGraphResourceImpl.getContents().clear();
        return eDataGraph;
    }

    public void save(DataGraph dataGraph, String string, Map map) throws IOException {
        URIConverter uRIConverter = this.getResourceSet().getURIConverter();
        OutputStream outputStream = uRIConverter.createOutputStream(URI.createURI((String)string));
        this.save(dataGraph, outputStream, map);
    }

    public void save(DataGraph dataGraph, OutputStream outputStream, Map map) throws IOException {
        DataGraphXMLHelperImpl dataGraphXMLHelperImpl = new DataGraphXMLHelperImpl(dataGraph);
        dataGraphXMLHelperImpl.saveDataGraph(map, "UTF-8", outputStream);
    }
}

