/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.common.rmcutil;

import com.ibm.rsct.rmc.McSession;
import com.ibm.rsct.rmcjni.McApi;
import com.ibm.rsct.util.CuException;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.common.rmcutil.NIMcSession;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public abstract class NIMcSessionManager {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$common$rmcutil$NIMcSessionManager == null ? (class$com$ibm$storage$ess$ni$agent$common$rmcutil$NIMcSessionManager = NIMcSessionManager.class$("com.ibm.storage.ess.ni.agent.common.rmcutil.NIMcSessionManager")) : class$com$ibm$storage$ess$ni$agent$common$rmcutil$NIMcSessionManager);
    private static Hashtable sessions = new Hashtable();
    private static int numberReconnectTries = 10;
    private static boolean sessionsEstablished = false;
    public static long localSession = 1L;
    public static long remoteSession = 2L;
    public static long sessionClosed = -2L;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$common$rmcutil$NIMcSessionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long startNewSession(int n, long l) throws NIServerException {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            NIMcSession nIMcSession = null;
            boolean bl = true;
            long l2 = 3L;
            long l3 = 0L;
            nIMcSession = NIMcSessionManager.startSession(n, true, l);
            while (sessions.containsKey(new Long(l2))) {
                ++l2;
            }
            sessions.put(new Long(l2), nIMcSession);
            logger.debug_general("RMC session established.");
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(long l) {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            long l2 = 0L;
            NIMcSession nIMcSession = (NIMcSession)sessions.remove(new Long(l));
            l2 = nIMcSession.getSavedSessionHandle();
            try {
                McApi.endSession((long)l2);
            }
            catch (CuException cuException) {
                logger.error("Failed to close RMC session.");
                logger.throwable((Throwable)cuException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll() {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            Set set = sessions.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                NIMcSessionManager.stop((Long)iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reEstablishSession(long l, NIMcSession nIMcSession) {
        boolean bl = false;
        NIMcSession nIMcSession2 = null;
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            logger.debug_general("Attempting to re-establish session");
            if (sessions.containsKey(new Long(l))) {
                NIMcSession nIMcSession3 = (NIMcSession)sessions.get(new Long(l));
                if (nIMcSession3 != nIMcSession) {
                    logger.debug_general("Another thread established a new session");
                    bl = true;
                } else {
                    logger.debug_general("Attempting to establish a new session");
                    nIMcSession2 = NIMcSessionManager.startSession(nIMcSession.getSessionOptions(), true, l);
                    if (nIMcSession2 != null) {
                        logger.debug_general("RMC Session successfully re-established");
                        nIMcSession = (NIMcSession)sessions.remove(new Long(l));
                        sessions.put(new Long(l), nIMcSession2);
                        long l2 = nIMcSession.getSavedSessionHandle();
                        bl = true;
                        try {
                            McApi.endSession((long)l2);
                        }
                        catch (CuException cuException) {
                            logger.throwable((Throwable)cuException);
                        }
                    } else {
                        logger.error("Failed to re-establish RMC Session");
                        nIMcSession3.setOpen(false);
                        bl = false;
                    }
                }
            } else {
                logger.error("Failed to find virtual session handle, either it never existed or another thread is trying to reconnect it");
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NIMcSession getSession(long l) throws NIServerException {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            NIMcSession nIMcSession = null;
            if (!sessions.containsKey(new Long(l))) {
                throw new NIServerException(2, "Invalid RMC session handle passed");
            }
            nIMcSession = (NIMcSession)sessions.get(new Long(l));
            return nIMcSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void establishSessions(boolean bl) {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            NIMcSession nIMcSession = null;
            NIMcSession nIMcSession2 = null;
            if (!sessionsEstablished) {
                nIMcSession = NIMcSessionManager.startSession(2, false, localSession);
                sessions.put(new Long(localSession), nIMcSession);
                logger.debug_general("RMC local session established.");
                sessionsEstablished = true;
                if (!bl) {
                    nIMcSession2 = NIMcSessionManager.startSession(4, false, remoteSession);
                    sessions.put(new Long(remoteSession), nIMcSession2);
                    logger.debug_general("RMC remote session established.");
                    sessionsEstablished = true;
                }
            }
        }
    }

    private static NIMcSession startSession(int n, boolean bl, long l) throws NullPointerException {
        boolean bl2;
        NIMcSession nIMcSession = null;
        int n2 = 0;
        do {
            try {
                McSession mcSession = new McSession(null, n, null, null);
                nIMcSession = new NIMcSession(mcSession, n, l);
                bl2 = true;
            }
            catch (CuException cuException) {
                Long l2 = new Long(cuException.getErrorId());
                logger.error("RMC connection error : " + l2.toString() + "  " + cuException.getMessage());
                bl2 = false;
                int n3 = cuException.getErrorId();
                if (n3 == 17 || n3 == 3 || n3 == 2) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.throwable((Throwable)interruptedException);
                        interruptedException.printStackTrace();
                    }
                }
                logger.throwable((Throwable)cuException);
                logger.error("Caught CuException from RMC when trying to open a session");
            }
            if (bl2) {
                logger.debug_general("RMC session established");
            }
            if (!bl) continue;
            ++n2;
        } while (!bl2 && n2 < numberReconnectTries);
        return nIMcSession;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

