/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.ci;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIOutstandingRequestTable;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPabsByteOS;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData;
import com.ibm.storage.ess.ni.agent.sfiserver.utility.NIByteArrayServices;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.jni.ci.NICIBuffer;
import com.ibm.storage.ess.ni.jni.ci.NICIClientInt;
import com.ibm.storage.ess.ni.jni.ci.NICIConnectionException;
import com.ibm.storage.ess.ni.jni.ci.NICIException;
import com.ibm.storage.ess.ni.jni.ci.NICIOptionException;
import com.ibm.storage.ess.ni.jni.ci.NICIOptions;
import com.ibm.storage.ess.ni.jni.ci.NICIStatus;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;

public class NICpssddInterface
extends NICIClientInt {
    public int result;
    private NICIOptions opts = new NICIOptions();
    private NIOutstandingRequestTable ort;
    private boolean Test = false;
    private int COMPONENT_PA = 3;
    private final int MAX_NUM_OF_PATHING_COMMANDS = 224;
    private final String DIAGNOSTIC_CONTROL_WARMSTART = "14";
    public int MAX_REQUEST_WAIT_TIME = 900;
    private final boolean SEND_REQUEST = true;
    private final boolean RECEIVE_REQUEST = false;
    private final int FIVE_MINUTES = 300000;
    private static long outputBufferCounter;
    private static int numberOfCommandsSent;
    private static long currentRequestedWarmstartTime;
    private static long lastSuccessfulWarmstartTime;
    public int numberOfQueries = 0;
    public boolean timeoutWarmstartEnabled;
    private static final Logger logger;
    private static NICpssddInterface ci;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$ci$NICpssddInterface;

    public static NICpssddInterface getInstance() {
        if (ci == null) {
            ci = new NICpssddInterface();
            numberOfCommandsSent = 0;
            lastSuccessfulWarmstartTime = 0L;
            currentRequestedWarmstartTime = 0L;
            ci.setOrt(NIOutstandingRequestTable.getInstance());
        }
        return ci;
    }

    private NICpssddInterface() {
        try {
            this.niCIOpen();
            this.timeoutWarmstartEnabled = true;
        }
        catch (NICIException nICIException) {
            logger.throwable((Throwable)nICIException);
            this.opts = new NICIOptions();
        }
    }

    public synchronized void sendSyncRequest(byte[] byArray) {
        NIResponseData nIResponseData = new NIResponseData(byArray);
        nIResponseData.getNextResponse();
        String string = nIResponseData.getCommand();
        Integer n = new Integer(nIResponseData.getPaIoctlTagID());
        try {
            int n2;
            this.opts.setOption(0, this.COMPONENT_PA);
            NICIBuffer nICIBuffer = new NICIBuffer();
            int n3 = 0;
            while (!this.setCommandCounter(nIResponseData.getNumberOfRequest(), true) && n3 < this.MAX_REQUEST_WAIT_TIME) {
                try {
                    logger.debug_general(">>> " + string + " Reached PA Max, need to wait a second.  Total seconds elapsed: " + n3);
                    ++n3;
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.warning(">>> Update retry interrupted.  Not a big deal, just good to know.  Trying looping again...");
                    logger.throwable((Throwable)interruptedException);
                }
            }
            if (n3 == this.MAX_REQUEST_WAIT_TIME) {
                if (this.timeoutWarmstartEnabled) {
                    try {
                        logger.debug_general(">>> " + string + " Timed out in the CPSSDDInterface and out of requests to send, issuing a warmstart!! Will continue to send request after warmstart.");
                        n2 = this.niCISendSyncRequest(this.getIoctlWarmstartCCW(), this.opts, nICIBuffer);
                        logger.debug_general("CPSSDD >>>> Warmstart  -- CI TagID: " + n2);
                        this.wait(15000L);
                        this.timeoutWarmstartEnabled = false;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.warning(">>> Update retry interrupted.  Not a big deal, just good to know.  Trying looping again...");
                        logger.throwable((Throwable)interruptedException);
                    }
                } else {
                    logger.debug_general(">>> " + string + " Timed out in the CPSSDDInterface and out or requests to send, not issuing a warmstart!!  Will continue to send request.");
                }
            }
            n2 = this.niCISendSyncRequest(byArray, this.opts, nICIBuffer);
            logger.debug_general("CPSSDD >>>> " + string + " -- CI TagID: " + n2 + " -- ORT Command TagID: " + n);
            this.responseHandler(nICIBuffer);
        }
        catch (NICIConnectionException nICIConnectionException) {
            logger.throwable((Throwable)nICIConnectionException);
            nIResponseData.setErrorCode(nICIConnectionException.getType());
            n = new Integer(nIResponseData.getPaIoctlTagID());
            logger.debug_general("CS >>>> " + string + " CI connection exception.  Error code: " + nICIConnectionException.getType() + " Size of Request: " + byArray.length + "TagID: " + n);
            this.setCommandCounter(nIResponseData.getNumberOfRequest(), false);
            this.ort.updateRequest(n, nIResponseData);
        }
        catch (NICIOptionException nICIOptionException) {
            logger.throwable((Throwable)nICIOptionException);
        }
    }

    public synchronized void sendRequest(byte[] byArray) {
        NIResponseData nIResponseData = new NIResponseData(byArray);
        nIResponseData.getNextResponse();
        String string = nIResponseData.getCommand();
        Integer n = new Integer(nIResponseData.getPaIoctlTagID());
        try {
            int n2;
            int n3 = 0;
            while (!this.setCommandCounter(nIResponseData.getNumberOfRequest(), true) && n3 < this.MAX_REQUEST_WAIT_TIME) {
                try {
                    logger.debug_general(">>> " + string + " Reached PA Max, need to wait a second.  Total seconds elapsed: " + n3);
                    ++n3;
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.warning(">>> update retry interrupted.  Not a big deal, just good to know.  Trying looping again...");
                    logger.throwable((Throwable)interruptedException);
                }
            }
            if (n3 == this.MAX_REQUEST_WAIT_TIME) {
                if (this.timeoutWarmstartEnabled) {
                    try {
                        NICIBuffer nICIBuffer = new NICIBuffer();
                        logger.debug_general(">>> " + string + " Timed out in the CPSSDDInterface and out of requests to send, issuing a warmstart!! Will continue to send request after warmstart.");
                        n2 = this.niCISendSyncRequest(this.getIoctlWarmstartCCW(), this.opts, nICIBuffer);
                        logger.debug_general("CPSSDD >>>> Warmstart  -- CI TagID: " + n2);
                        this.wait(15000L);
                        this.timeoutWarmstartEnabled = false;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.warning(">>> Update retry interrupted.  Not a big deal, just good to know.  Trying looping again...");
                        logger.throwable((Throwable)interruptedException);
                    }
                } else {
                    logger.debug_general(">>> " + string + " Timed out in the CPSSDDInterface and out or requests to send, not issuing a warmstart!!  Will continue to send request.");
                }
            }
            this.opts.setOption(0, this.COMPONENT_PA);
            n2 = this.niCISendRequest(byArray, this.opts);
            logger.debug_general("CPSSDD >>>> " + string + " -- CI TagID: " + n2 + " -- ORT Command TagID: " + n);
        }
        catch (NICIConnectionException nICIConnectionException) {
            logger.throwable((Throwable)nICIConnectionException);
            nIResponseData.setErrorCode(nICIConnectionException.getType());
            logger.debug_general("CPSSDD >>>> " + string + " CI connection exception.  Error code: " + nICIConnectionException.getType() + " Size of Request: " + byArray.length + "TagID: " + n);
            this.setCommandCounter(nIResponseData.getNumberOfRequest(), false);
            this.ort.updateRequest(n, nIResponseData);
        }
        catch (NICIOptionException nICIOptionException) {
            logger.throwable((Throwable)nICIOptionException);
        }
    }

    public synchronized void responseHandler(NICIBuffer nICIBuffer) {
        NICIStatus nICIStatus = nICIBuffer.getRequestStatus();
        NIResponseData nIResponseData = new NIResponseData(nICIBuffer.getRequest());
        if (nIResponseData.getRawData().length == 0) {
            logger.debug_general("CPSSDD >>> ***** No Data returned by CI *****");
            return;
        }
        nIResponseData.getNextResponse();
        String string = nIResponseData.getCommand();
        int n = nIResponseData.getPaIoctlReturnCode();
        Integer n2 = new Integer(nIResponseData.getPaIoctlTagID());
        try {
            Object object;
            String string2 = "";
            if (!nICIStatus.isSuccessful()) {
                nIResponseData.setErrorCode(nICIStatus.getCode());
                if (1 == nICIStatus.getCode() && this.timeoutWarmstartEnabled) {
                    object = new NICIBuffer();
                    logger.debug_general(">>> " + string + " Timed out returned from CI, issuing a warmstart!!");
                    int n3 = this.niCISendSyncRequest(this.getIoctlWarmstartCCW(), this.opts, (NICIBuffer)object);
                    logger.debug_general("CPSSDD >>>> Warmstart  -- CI TagID: " + n3);
                    this.timeoutWarmstartEnabled = false;
                }
                logger.error("CPSSDD >>> " + string + ": TagID: " + n2 + " LSS: 0x: " + Integer.toHexString(0xFF & nIResponseData.getLss()) + " Device: 0x: " + Integer.toHexString(0xFF & nIResponseData.getDevice()) + " Request failed at CI, reason code = " + nICIStatus.getCode() + " Set Error Code to: 0x: " + Integer.toHexString(0xFFFFFFFF & nIResponseData.getErrorCode()));
            } else if (0 != n) {
                string2 = Integer.toHexString(0xFFFF & nIResponseData.getErrorCode());
                object = n == 1024 ? NIByteArrayServices.getHexString(nIResponseData.getSenseData(32), 32, string) : ">>> " + string + ": No Sense.  Failed by Pathing ";
                logger.error("CPSSDD >>> " + string + ": TagID: " + n2 + " LSS: 0x: " + Integer.toHexString(0xFF & nIResponseData.getLss()) + " Device: 0x: " + Integer.toHexString(0xFF & nIResponseData.getDevice()) + " Failed at Pathing with return code:  0x: " + Integer.toHexString(0xFFFF & n) + "\n\t\t\t\t>>> " + string + ": Sense Data: 0x: \n\t\t\t\t" + (String)object);
                if ("14".equals(string)) {
                    currentRequestedWarmstartTime = lastSuccessfulWarmstartTime;
                }
            } else {
                logger.debug_general("CPSSDD >>> " + string + " :-) Successful Command for  TagID: " + n2 + " LSS: 0x: " + Integer.toHexString(0xFF & nIResponseData.getLss()) + " Device: 0x: " + Integer.toHexString(0xFF & nIResponseData.getDevice()) + " Size of request: " + nICIBuffer.getRequest().length + " Byte Count: " + nIResponseData.getByteCount());
                if ("14" == string) {
                    lastSuccessfulWarmstartTime = currentRequestedWarmstartTime;
                }
            }
            if (outputBufferCounter > 0L) {
                logger.error(">>> " + string + ": There are " + --outputBufferCounter + "buffers left.");
                byte[] byArray = nIResponseData.getOutputDataArray();
                object = NIByteArrayServices.getHexString(byArray, byArray.length, string);
                logger.error("CPSSDD buffer >>>> " + string + ": \n\t\t\t\t" + (String)object);
            }
            this.setCommandCounter(nIResponseData.getNumberOfRequest(), false);
            this.ort.updateRequest(n2, nIResponseData);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            NIServerException nIServerException = new NIServerException(0, "CPSSDD interface exception");
            this.ort.updateRequest(n2, nIServerException);
        }
    }

    public void setOrt(NIOutstandingRequestTable nIOutstandingRequestTable) {
        this.ort = nIOutstandingRequestTable;
    }

    public void setBufferOutputCount(long l) {
        outputBufferCounter = l;
    }

    public boolean isTestSet() {
        return this.Test;
    }

    public synchronized boolean setCommandCounter(int n, boolean bl) {
        if (bl) {
            if (224 < n + numberOfCommandsSent) {
                return false;
            }
            logger.debug_general(">>> Number of commands outstanding (sending): " + (numberOfCommandsSent += n));
            return true;
        }
        if (numberOfCommandsSent < n) {
            numberOfCommandsSent = 0;
        }
        logger.debug_general(">>> Number of commands outstanding (receiving): " + (numberOfCommandsSent -= n));
        return true;
    }

    public synchronized boolean isWarmStartAllowed(long l) {
        if (l - currentRequestedWarmstartTime < 300000L) {
            return false;
        }
        currentRequestedWarmstartTime = l;
        return true;
    }

    public byte[] getIoctlWarmstartCCW() {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[20];
        byArray2[0] = 20;
        byArray2[1] = 11;
        byArray2[3] = 16;
        NIPabsByteOS nIPabsByteOS = new NIPabsByteOS(243, 0);
        nIPabsByteOS.addPabiArray(byArray2, n, byArray2.length, n2, n3, byArray);
        nIPabsByteOS.closeOS();
        return nIPabsByteOS.toByteArray();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$ci$NICpssddInterface == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$ci$NICpssddInterface = NICpssddInterface.class$("com.ibm.storage.ess.ni.agent.sfiserver.ci.NICpssddInterface")) : class$com$ibm$storage$ess$ni$agent$sfiserver$ci$NICpssddInterface);
        ci = null;
    }
}

