/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.common;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.sfiserver.common.NIPabsByteOS;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NICSErrorCodeParser;

public class NIResponseData {
    private int currentResponse = -1;
    private boolean lastResponse = false;
    private byte[] rawData;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$common$NIResponseData == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$common$NIResponseData = NIResponseData.class$("com.ibm.storage.ess.ni.agent.sfiserver.common.NIResponseData")) : class$com$ibm$storage$ess$ni$agent$sfiserver$common$NIResponseData);
    private static final int SIZE_OF_PA_OUTPUT_DATA_SMALL_BUFFER = 1504;
    private static final int SIZE_OF_PA_OUTPUT_DATA_LARGE_BUFFER = 64000;
    private static final int SIZE_OF_PA_RESPONSE = NIPabsByteOS.OFFSET_TO_PA_IOCTL_OUTPUT_DATA + 1504;
    private static final int FINAL_RESPONSE = 0x800000;
    private boolean commandWasSuccessful = true;
    private static final int SUCCESS = 0;
    private static final int TIME_OUT = 1;
    private static final int NO_RESOURCES = 2;
    private static final int WARM_START = 3;
    private static final int PRSD_COMMAND = 24;
    public static final int NI_CONNECTION_EXCEPTION = 255;
    private int errorCode = 0;
    private static final int PARAMETER_INVALID = 1024;
    private static final int PARAMTER_TRACK_INVALID = 2816;
    private static final int PPRC_SECONDARY_COMMAND_INVALID = 3584;
    private static final int REDRIVE_COMMAND = 61440;
    private static final int STATUS_CANNOT_BE_DETERMINED = 64512;
    private static final int ERROR_SENSE_0F = 3840;
    private static final int COMMAND_REJECT = 128;
    private static final int INTERVENTION_REQUIRED = 64;
    private static final int EQUIPMENT_CHECK = 16;
    public static final int NUMBER_OF_ERROR_SENSE_BYTES = 32;
    private static final int REDRIVE_COMMAND_FEW_SECONDS = 30;
    private static final int REDRIVE_COMMAND_FEW_MINUTES = 29;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$common$NIResponseData;

    public NIResponseData(byte[] byArray) {
        this.rawData = byArray;
    }

    public boolean getNextResponse() {
        if (this.lastResponse) {
            return false;
        }
        ++this.currentResponse;
        int n = this.getPaIoctlFlags(this.rawData);
        if ((n & 0x800000) != 0) {
            this.lastResponse = true;
        }
        return true;
    }

    public int getPaIoctlFlags(byte[] byArray) {
        int n = this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_FLAGS;
        int n2 = this.getIntValueFromByteArray(n, 4);
        return n2;
    }

    public int getPaIoctlReturnCode() {
        int n = this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_RETURN_CODE;
        return this.getIntValueFromByteArray(n, 2);
    }

    public int getPaIoctlTagID() {
        int n = this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_TAGID;
        return this.getIntValueFromByteArray(n, 4);
    }

    public int getByteCount() {
        int n = this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_BYTE_COUNT;
        int n2 = this.getIntValueFromByteArray(n, 2);
        return n2;
    }

    public int getErrorCode() {
        int n = 1;
        if (!this.commandWasSuccessful) {
            return this.errorCode;
        }
        int n2 = this.getIndexToOutputData();
        int n3 = 0xFF & this.getIntValueFromByteArray(n2, 1);
        int n4 = this.getIntValueFromByteArray(n2 + 7, 2);
        int n5 = this.getIntValueFromByteArray(n2 + 25, 1);
        if (n3 == 16) {
            n = -1099952128;
        } else if (n3 == 64) {
            n = -1099939840;
        } else if (n3 == 128) {
            switch (n4 & 0xFF00) {
                case 1024: {
                    n = 3852;
                    break;
                }
                case 2816: {
                    n = 3853;
                    break;
                }
                case 3584: {
                    n = 3854;
                    break;
                }
                case 61440: {
                    n = this.getFormatF0ReturnCode(n5);
                    break;
                }
                case 64512: {
                    n = 3865;
                    break;
                }
                case 3840: {
                    n = NICSErrorCodeParser.get0FReasonCode(n4);
                    break;
                }
            }
        } else if ((n4 & 0xFF00) == 61440) {
            n = this.getFormatF0ReturnCode(n5);
        }
        if (n == 1) {
            logger.debug_general("messageSense = " + n3 + " errorSense " + n4 + " errorSenseByte25 = " + n5);
        }
        return n;
    }

    private int getFormatF0ReturnCode(int n) {
        int n2 = n == 30 ? 3872 : (n == 29 ? 3873 : 3855);
        return n2;
    }

    public int getIntValueFromByteArray(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = n2 - 1;
        while (n5 >= 0) {
            n3 += NIResponseData.unsignedByteToInt(this.rawData[n4++]) << 8 * n5;
            --n5;
        }
        return n3;
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public static long unsignedIntToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public int getIndexToOutputData() {
        int n = this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_OUTPUT_DATA;
        return n;
    }

    public int getIndexToEssniData() {
        int n = this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_ESSNI_DATA;
        return n;
    }

    public int getLss() {
        return this.rawData[this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_LSS];
    }

    public int getDevice() {
        return this.rawData[this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_DEVICE];
    }

    public int getIndexToInputData() {
        int n = this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_INPUT_DATA;
        return n;
    }

    public byte getCommandCode() {
        return this.rawData[this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_COMMAND_CODE];
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public void setRawData(byte[] byArray) {
        this.rawData = byArray;
    }

    public void setErrorCode(int n) {
        switch (n) {
            case 0: {
                this.commandWasSuccessful = true;
                break;
            }
            case 1: {
                this.errorCode = -1099956224;
                this.commandWasSuccessful = false;
                break;
            }
            case 2: {
                this.errorCode = 3841;
                this.commandWasSuccessful = false;
                break;
            }
            case 3: {
                this.errorCode = 3840;
                this.commandWasSuccessful = false;
                break;
            }
            case 255: {
                this.errorCode = -1099694073;
                this.commandWasSuccessful = false;
                break;
            }
            default: {
                this.errorCode = 1;
                this.commandWasSuccessful = false;
            }
        }
    }

    public boolean wasCommandSuccessful() {
        return this.commandWasSuccessful;
    }

    public int getIndexToNumberOfRequests() {
        return this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_NUM_OF_REQ;
    }

    public int getNumberOfRequest() {
        int n = this.currentResponse * SIZE_OF_PA_RESPONSE + NIPabsByteOS.OFFSET_TO_PA_IOCTL_NUM_OF_REQ;
        return this.getIntValueFromByteArray(n, 1);
    }

    public byte[] getOutputDataArray() {
        int n = this.getIndexToOutputData();
        int n2 = this.getByteCount();
        if (n2 >= 64000) {
            n2 = 64000;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.rawData, n, byArray, 0, n2);
        return byArray;
    }

    public byte[] getLargeOutputDataArray() {
        int n = this.getIndexToOutputData();
        byte[] byArray = new byte[64000];
        int n2 = 0;
        while (n2 < 64000) {
            byArray[n2] = this.rawData[n + n2];
            ++n2;
        }
        return byArray;
    }

    public byte[] getSenseData(int n) {
        int n2 = this.getIndexToOutputData();
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = this.rawData[n3 + n2];
            ++n3;
        }
        return byArray;
    }

    public String getCommand() {
        if (24 == this.rawData[this.getIndexToInputData()]) {
            return Integer.toHexString(0xFF & this.rawData[this.getIndexToInputData() + 6]);
        }
        return Integer.toHexString(0xFF & this.rawData[this.getIndexToInputData()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

