/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.lssinfo;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.commandagent.common.NILssInfo;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIByteArray;
import java.io.Serializable;
import java.util.Arrays;

public class NIPAIoctlLssInfo
implements Serializable,
NILssInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$agent$sfiserver$lssinfo$NIPAIoctlLssInfo == null ? (class$com$ibm$storage$ess$ni$agent$sfiserver$lssinfo$NIPAIoctlLssInfo = NIPAIoctlLssInfo.class$("com.ibm.storage.ess.ni.agent.sfiserver.lssinfo.NIPAIoctlLssInfo")) : class$com$ibm$storage$ess$ni$agent$sfiserver$lssinfo$NIPAIoctlLssInfo);
    private static final int DEVS_PER_LSS = 2;
    private static final int MAX_LSS_NUM = NIAgentProperties.getAgentType() == 4 ? 31 : 255;
    private byte[] lssInfo = new byte[MAX_LSS_NUM + 1];
    private byte[] vols = new byte[(MAX_LSS_NUM + 1) * 2];
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$agent$sfiserver$lssinfo$NIPAIoctlLssInfo;

    public NIPAIoctlLssInfo(byte[] byArray) {
        this(byArray, 0);
    }

    public NIPAIoctlLssInfo(byte[] byArray, int n) {
        if (byArray.length - n > this.lssInfo.length + this.vols.length) {
            System.arraycopy(byArray, n, this.lssInfo, 0, this.lssInfo.length);
            System.arraycopy(byArray, n + this.lssInfo.length, this.vols, 0, this.vols.length);
        } else {
            logger.error("Data returned not large enough to fill lss info", "NIPAIoctlLssInfo", "<init>", null);
        }
    }

    public int getOwningServerNumber(int n) {
        int n2 = -1;
        if (n >= 0 && n <= MAX_LSS_NUM) {
            if ((this.lssInfo[n] & 0xFFFFFF80) != 0) {
                n2 = 0;
            } else if ((this.lssInfo[n] & 0x40) != 0) {
                n2 = 1;
            }
        }
        return n2;
    }

    public boolean isOwnedBy(int n, int n2) {
        boolean bl = false;
        if (n2 >= 0 && n2 <= MAX_LSS_NUM) {
            bl = (this.lssInfo[n2] & PaIoctlLssInfoFlags.CLUSTER_MASKS[n]) != 0;
        }
        return bl;
    }

    public int getLssType(int n) {
        int n2 = -1;
        if (n >= 0 && n <= MAX_LSS_NUM) {
            if ((this.lssInfo[n] & 0x20) != 0) {
                n2 = 0;
            } else if ((this.lssInfo[n] & 0x10) != 0) {
                n2 = 1;
            }
        }
        return n2;
    }

    public boolean isType(int n, int n2) {
        boolean bl = false;
        if (n2 >= 0 && n2 <= MAX_LSS_NUM) {
            bl = (this.lssInfo[n2] & PaIoctlLssInfoFlags.TYPE_MASKS[n]) != 0;
        }
        return bl;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof NIPAIoctlLssInfo && Arrays.equals(((NIPAIoctlLssInfo)object).lssInfo, this.lssInfo) && Arrays.equals(((NIPAIoctlLssInfo)object).vols, this.vols);
    }

    public String toString() {
        return NIByteArray.toHexString(this.lssInfo) + " " + NIByteArray.toHexString(this.vols);
    }

    public boolean exists(int n) {
        boolean bl = false;
        if (n >= 0 && n <= MAX_LSS_NUM) {
            bl = this.lssInfo[n] != 0 && this.lssInfo[n] != 8;
        }
        return bl;
    }

    public int getFirstVolNum(int n) {
        int n2 = 0;
        if (n >= 0 && n <= MAX_LSS_NUM) {
            n2 = this.vols[n * 2];
        }
        return n2;
    }

    public int getLastVolNum(int n) {
        int n2 = 0;
        if (n >= 0 && n <= MAX_LSS_NUM) {
            n2 = this.vols[n * 2 + 1];
        }
        return n2;
    }

    public boolean areVolumesDefined(int n) {
        boolean bl = false;
        if (n >= 0 && n <= MAX_LSS_NUM) {
            bl = this.exists(n) && (this.lssInfo[n] & 8) == 0;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static interface PaIoctlLssInfoFlags {
        public static final byte PA_IOCTL_LSS_OWNED_CLUSTER_0 = -128;
        public static final byte PA_IOCTL_LSS_OWNED_CLUSTER_1 = 64;
        public static final byte PA_IOCTL_LSS_IS_CKD = 32;
        public static final byte PA_IOCTL_LSS_IS_FB = 16;
        public static final byte PA_IOCTL_LSS_NO_READY_DEVICES = 8;
        public static final byte PA_IOCTL_LSS_NOT_CREATED = 0;
        public static final byte[] CLUSTER_MASKS = new byte[]{-128, 64};
        public static final byte[] TYPE_MASKS = new byte[]{32, 16};
    }
}

