/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.agent.sfiserver.utility;

import com.ibm.storage.ess.ni.exception.NIServerException;

public class NIByteArrayServices {
    public static void storeNumberIntoCCW(byte[] byArray, int n, int n2, long l) {
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n2 - n3 - 1] = (byte)(l >> 8 * n3 & 0xFFL);
            ++n3;
        }
    }

    public static void storeStringIntoCCW(byte[] byArray, int n, int n2, String string) throws NIServerException {
        if (string.length() > n2) {
            throw new NIServerException(2, "String \"" + string + "\" is bigger than allowed size of " + n2);
        }
        int n3 = n2 - string.length();
        char[] cArray = string.toCharArray();
        int n4 = 0;
        while (n4 < cArray.length) {
            byArray[n + n4 + n3] = (byte)cArray[n4];
            ++n4;
        }
    }

    public static String getHexString(byte[] byArray) {
        return NIByteArrayServices.getHexString(byArray, byArray.length);
    }

    public static String getHexString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(">>> ");
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 16 == 0 && 0 != n2) {
                stringBuffer.append(" " + (n2 - 1) + "\n\t\t\t\t>>> ");
            }
            if (n2 % 4 == 0) {
                stringBuffer.append(" ");
            }
            if ((0xF0 & byArray[n2]) == 0) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(0xFF & byArray[n2]) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getHexString(byte[] byArray, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(">>> " + string + ": ");
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 16 == 0 && 0 != n2) {
                stringBuffer.append(" " + (n2 - 1) + "\n\t\t\t\t>>> " + string + ": ");
            }
            if (n2 % 4 == 0) {
                stringBuffer.append(" ");
            }
            if ((0xF0 & byArray[n2]) == 0) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(0xFF & byArray[n2]) + " ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getDashedHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            if (n % 4 == 0 && n > 0) {
                stringBuffer.append("-");
            }
            if ((0xF0 & byArray[n]) == 0) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(0xFF & byArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static long getLongValueFromByteArray(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = n;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            l += (long)(NIByteArrayServices.unsignedByteToInt(byArray[n3++]) << 8 * n4);
            --n4;
        }
        return l;
    }

    public static int getIntValueFromByteArray(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        int n5 = n2 - 1;
        while (n5 >= 0) {
            n3 += NIByteArrayServices.unsignedByteToInt(byArray[n4++]) << 8 * n5;
            --n5;
        }
        return n3;
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }
}

